"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueProcessingEc2Service = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const cxapi = require("@aws-cdk/cx-api");
const queue_processing_service_base_1 = require("../base/queue-processing-service-base");
/**
 * Class to create a queue processing EC2 service.
 */
class QueueProcessingEc2Service extends queue_processing_service_base_1.QueueProcessingServiceBase {
    /**
     * Constructs a new instance of the QueueProcessingEc2Service class.
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        jsiiDeprecationWarnings._aws_cdk_aws_ecs_patterns_QueueProcessingEc2ServiceProps(props);
        const containerName = (_b = props.containerName) !== null && _b !== void 0 ? _b : 'QueueProcessingContainer';
        // Create a Task Definition for the container to start
        this.taskDefinition = new aws_ecs_1.Ec2TaskDefinition(this, 'QueueProcessingTaskDef', {
            family: props.family,
        });
        this.taskDefinition.addContainer(containerName, {
            image: props.image,
            memoryLimitMiB: props.memoryLimitMiB,
            memoryReservationMiB: props.memoryReservationMiB,
            cpu: props.cpu,
            gpuCount: props.gpuCount,
            command: props.command,
            environment: this.environment,
            secrets: this.secrets,
            logging: this.logDriver,
        });
        // The desiredCount should be removed from the fargate service when the feature flag is removed.
        const desiredCount = this.node.tryGetContext(cxapi.ECS_REMOVE_DEFAULT_DESIRED_COUNT) ? undefined : this.desiredCount;
        // Create an ECS service with the previously defined Task Definition and configure
        // autoscaling based on cpu utilization and number of messages visible in the SQS queue.
        this.service = new aws_ecs_1.Ec2Service(this, 'QueueProcessingService', {
            cluster: this.cluster,
            desiredCount: desiredCount,
            taskDefinition: this.taskDefinition,
            serviceName: props.serviceName,
            minHealthyPercent: props.minHealthyPercent,
            maxHealthyPercent: props.maxHealthyPercent,
            propagateTags: props.propagateTags,
            enableECSManagedTags: props.enableECSManagedTags,
            deploymentController: props.deploymentController,
            circuitBreaker: props.circuitBreaker,
            capacityProviderStrategies: props.capacityProviderStrategies,
            placementConstraints: props.placementConstraints,
            placementStrategies: props.placementStrategies,
        });
        this.configureAutoscalingForService(this.service);
        this.grantPermissionsToService(this.service);
    }
}
exports.QueueProcessingEc2Service = QueueProcessingEc2Service;
_a = JSII_RTTI_SYMBOL_1;
QueueProcessingEc2Service[_a] = { fqn: "@aws-cdk/aws-ecs-patterns.QueueProcessingEc2Service", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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