"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        this._version = new version_1.Version(this);
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_c = options.projenDuringBuild) !== null && _c !== void 0 ? _c : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_d = options.npmignoreEnabled) !== null && _d !== void 0 ? _d : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_e = options.gitignore) === null || _e === void 0 ? void 0 : _e.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_f = options.npmignore) === null || _f === void 0 ? void 0 : _f.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_RC}`);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_j = options.projenDevDependency) !== null && _j !== void 0 ? _j : true;
        if (projen) {
            const projenVersion = (_k = options.projenVersion) !== null && _k !== void 0 ? _k : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_q = options.buildWorkflow) !== null && _q !== void 0 ? _q : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const workflow = this.createBuildWorkflow('Build', {
                jobId: buildJobId,
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: [
                    {
                        name: 'Commit and push changes (if any)',
                        run: `git diff --exit-code || (git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch})`,
                    },
                    {
                        // only if not running from a fork
                        if: '${{ github.repository == github.event.pull_request.head.repo.full_name }}',
                        name: 'Update status check',
                        run: [
                            'gh api',
                            '-X POST',
                            '/repos/${{ github.event.pull_request.head.repo.full_name }}/check-runs',
                            `-F name="${buildJobId}"`,
                            '-F head_sha="$(git rev-parse HEAD)"',
                            '-F status="completed"',
                            '-F conclusion="success"',
                        ].join(' '),
                        env: {
                            GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                        },
                    },
                ],
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_r = options.codeCov) !== null && _r !== void 0 ? _r : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_s = options.releaseWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true)) {
            const defaultReleaseBranch = (_t = options.defaultReleaseBranch) !== null && _t !== void 0 ? _t : 'main';
            const releaseBranches = (_u = options.releaseBranches) !== null && _u !== void 0 ? _u : [defaultReleaseBranch];
            const trigger = {};
            if ((_v = options.releaseEveryCommit) !== null && _v !== void 0 ? _v : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_w = options.artifactsDirectory) !== null && _w !== void 0 ? _w : 'dist';
            const getVersion = 'v$(node -p \"require(\'./package.json\').version\")';
            const jobId = 'release';
            const releaseSteps = [];
            // to avoid race conditions between two commits trying to release the same
            // version, we check if the head sha is identical to the remote sha. if
            // not, we will skip the release and just finish the build.
            const gitRemoteStep = 'git_remote';
            const latestCommitOutput = 'latest_commit';
            const noNewCommits = `\${{ steps.${gitRemoteStep}.outputs.${latestCommitOutput} == github.sha }}`;
            releaseSteps.push({
                name: 'Check for new commits',
                id: gitRemoteStep,
                run: `echo ::set-output name=${latestCommitOutput}::"$(git ls-remote origin -h \${{ github.ref }} | cut -f1)"`,
            });
            releaseSteps.push({
                name: 'Create release',
                if: noNewCommits,
                run: [
                    `gh release create ${getVersion}`,
                    `-F ${this._version.changelogFile}`,
                    `-t ${getVersion}`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            releaseSteps.push({
                name: 'Unbump',
                run: this.runTaskCommand(this._version.unbumpTask),
            });
            releaseSteps.push({
                name: 'Upload artifact',
                if: noNewCommits,
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: artifactDirectory,
                    path: artifactDirectory,
                },
            });
            const workflow = this.createBuildWorkflow('Release', {
                jobId: jobId,
                trigger,
                env: {
                    RELEASE: 'true',
                },
                preBuildSteps: [
                    {
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    },
                    ...(_x = options.releaseWorkflowSetupSteps) !== null && _x !== void 0 ? _x : [],
                ],
                postSteps: releaseSteps,
                image: options.workflowContainerImage,
                codeCov: false,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId: jobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_0 = this.npmignore) === null || _0 === void 0 ? void 0 : _0.exclude('/.mergify.yml');
        }
        if ((_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : true) {
            (_2 = this.github) === null || _2 === void 0 ? void 0 : _2.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_3 = options.projenUpgradeAutoMerge) !== null && _3 !== void 0 ? _3 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_4 = this.autoMerge) === null || _4 === void 0 ? void 0 : _4.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_5 = options.pullRequestTemplate) !== null && _5 !== void 0 ? _5 : true) {
            (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addPullRequestTemplate(...(_7 = options.pullRequestTemplateContents) !== null && _7 !== void 0 ? _7 : []);
        }
        const projenrcJs = (_8 = options.projenrcJs) !== null && _8 !== void 0 ? _8 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e, _f;
        const buildJobId = options.jobId;
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --ignore-space-at-eol --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
                ...(_e = options.env) !== null && _e !== void 0 ? _e : {},
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Automation"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_f = this.jest) === null || _f === void 0 ? void 0 : _f.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                ...postSteps,
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        workflow.addJobs({ [buildJobId]: job });
        return workflow;
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.75" };
//# sourceMappingURL=data:application/json;base64,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