#
# Autogenerated by Thrift Compiler (0.10.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
import sys
import logging
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport


class Iface(object):
    def exists(self, table, tget):
        """
        Test for the existence of columns in the table, as specified in the TGet.

        @return true if the specified TGet matches one or more keys, false if not

        Parameters:
         - table: the table to check on
         - tget: the TGet to check for
        """
        pass

    def get(self, table, tget):
        """
        Method for getting data from a row.

        If the row cannot be found an empty Result is returned.
        This can be checked by the empty field of the TResult

        @return the result

        Parameters:
         - table: the table to get from
         - tget: the TGet to fetch
        """
        pass

    def getMultiple(self, table, tgets):
        """
        Method for getting multiple rows.

        If a row cannot be found there will be a null
        value in the result list for that TGet at the
        same position.

        So the Results are in the same order as the TGets.

        Parameters:
         - table: the table to get from
         - tgets: a list of TGets to fetch, the Result list
        will have the Results at corresponding positions
        or null if there was an error
        """
        pass

    def put(self, table, tput):
        """
        Commit a TPut to a table.

        Parameters:
         - table: the table to put data in
         - tput: the TPut to put
        """
        pass

    def checkAndPut(self, table, row, family, qualifier, value, tput):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the TPut.

        @return true if the new put was executed, false otherwise

        Parameters:
         - table: to check in and put to
         - row: row to check
         - family: column family to check
         - qualifier: column qualifier to check
         - value: the expected value, if not provided the
        check is for the non-existence of the
        column in question
         - tput: the TPut to put if the check succeeds
        """
        pass

    def putMultiple(self, table, tputs):
        """
        Commit a List of Puts to the table.

        Parameters:
         - table: the table to put data in
         - tputs: a list of TPuts to commit
        """
        pass

    def deleteSingle(self, table, tdelete):
        """
        Deletes as specified by the TDelete.

        Note: "delete" is a reserved keyword and cannot be used in Thrift
        thus the inconsistent naming scheme from the other functions.

        Parameters:
         - table: the table to delete from
         - tdelete: the TDelete to delete
        """
        pass

    def deleteMultiple(self, table, tdeletes):
        """
        Bulk commit a List of TDeletes to the table.

        Throws a TIOError if any of the deletes fail.

        Always returns an empty list for backwards compatibility.

        Parameters:
         - table: the table to delete from
         - tdeletes: list of TDeletes to delete
        """
        pass

    def checkAndDelete(self, table, row, family, qualifier, value, tdelete):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the delete.

        @return true if the new delete was executed, false otherwise

        Parameters:
         - table: to check in and delete from
         - row: row to check
         - family: column family to check
         - qualifier: column qualifier to check
         - value: the expected value, if not provided the
        check is for the non-existence of the
        column in question
         - tdelete: the TDelete to execute if the check succeeds
        """
        pass

    def increment(self, table, tincrement):
        """
        Parameters:
         - table: the table to increment the value on
         - tincrement: the TIncrement to increment
        """
        pass

    def append(self, table, tappend):
        """
        Parameters:
         - table: the table to append the value on
         - tappend: the TAppend to append
        """
        pass

    def openScanner(self, table, tscan):
        """
        Get a Scanner for the provided TScan object.

        @return Scanner Id to be used with other scanner procedures

        Parameters:
         - table: the table to get the Scanner for
         - tscan: the scan object to get a Scanner for
        """
        pass

    def getScannerRows(self, scannerId, numRows):
        """
        Grabs multiple rows from a Scanner.

        @return Between zero and numRows TResults

        Parameters:
         - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
         - numRows: number of rows to return
        """
        pass

    def closeScanner(self, scannerId):
        """
        Closes the scanner. Should be called to free server side resources timely.
        Typically close once the scanner is not needed anymore, i.e. after looping
        over it to get all the required rows.

        Parameters:
         - scannerId: the Id of the Scanner to close *
        """
        pass

    def mutateRow(self, table, trowMutations):
        """
        mutateRow performs multiple mutations atomically on a single row.

        Parameters:
         - table: table to apply the mutations
         - trowMutations: mutations to apply
        """
        pass

    def getScannerResults(self, table, tscan, numRows):
        """
        Get results for the provided TScan object.
        This helper function opens a scanner, get the results and close the scanner.

        @return between zero and numRows TResults

        Parameters:
         - table: the table to get the Scanner for
         - tscan: the scan object to get a Scanner for
         - numRows: number of rows to return
        """
        pass

    def getRegionLocation(self, table, row, reload):
        """
        Given a table and a row get the location of the region that
        would contain the given row key.

        reload = true means the cache will be cleared and the location
        will be fetched from meta.

        Parameters:
         - table
         - row
         - reload
        """
        pass

    def getAllRegionLocations(self, table):
        """
        Get all of the region locations for a given table.


        Parameters:
         - table
        """
        pass


class Client(Iface):
    def __init__(self, iprot, oprot=None):
        self._iprot = self._oprot = iprot
        if oprot is not None:
            self._oprot = oprot
        self._seqid = 0

    def exists(self, table, tget):
        """
        Test for the existence of columns in the table, as specified in the TGet.

        @return true if the specified TGet matches one or more keys, false if not

        Parameters:
         - table: the table to check on
         - tget: the TGet to check for
        """
        self.send_exists(table, tget)
        return self.recv_exists()

    def send_exists(self, table, tget):
        self._oprot.writeMessageBegin('exists', TMessageType.CALL, self._seqid)
        args = exists_args()
        args.table = table
        args.tget = tget
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_exists(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = exists_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "exists failed: unknown result")

    def get(self, table, tget):
        """
        Method for getting data from a row.

        If the row cannot be found an empty Result is returned.
        This can be checked by the empty field of the TResult

        @return the result

        Parameters:
         - table: the table to get from
         - tget: the TGet to fetch
        """
        self.send_get(table, tget)
        return self.recv_get()

    def send_get(self, table, tget):
        self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
        args = get_args()
        args.table = table
        args.tget = tget
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_get(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = get_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result")

    def getMultiple(self, table, tgets):
        """
        Method for getting multiple rows.

        If a row cannot be found there will be a null
        value in the result list for that TGet at the
        same position.

        So the Results are in the same order as the TGets.

        Parameters:
         - table: the table to get from
         - tgets: a list of TGets to fetch, the Result list
        will have the Results at corresponding positions
        or null if there was an error
        """
        self.send_getMultiple(table, tgets)
        return self.recv_getMultiple()

    def send_getMultiple(self, table, tgets):
        self._oprot.writeMessageBegin('getMultiple', TMessageType.CALL, self._seqid)
        args = getMultiple_args()
        args.table = table
        args.tgets = tgets
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getMultiple(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getMultiple_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getMultiple failed: unknown result")

    def put(self, table, tput):
        """
        Commit a TPut to a table.

        Parameters:
         - table: the table to put data in
         - tput: the TPut to put
        """
        self.send_put(table, tput)
        self.recv_put()

    def send_put(self, table, tput):
        self._oprot.writeMessageBegin('put', TMessageType.CALL, self._seqid)
        args = put_args()
        args.table = table
        args.tput = tput
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_put(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = put_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def checkAndPut(self, table, row, family, qualifier, value, tput):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the TPut.

        @return true if the new put was executed, false otherwise

        Parameters:
         - table: to check in and put to
         - row: row to check
         - family: column family to check
         - qualifier: column qualifier to check
         - value: the expected value, if not provided the
        check is for the non-existence of the
        column in question
         - tput: the TPut to put if the check succeeds
        """
        self.send_checkAndPut(table, row, family, qualifier, value, tput)
        return self.recv_checkAndPut()

    def send_checkAndPut(self, table, row, family, qualifier, value, tput):
        self._oprot.writeMessageBegin('checkAndPut', TMessageType.CALL, self._seqid)
        args = checkAndPut_args()
        args.table = table
        args.row = row
        args.family = family
        args.qualifier = qualifier
        args.value = value
        args.tput = tput
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_checkAndPut(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = checkAndPut_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result")

    def putMultiple(self, table, tputs):
        """
        Commit a List of Puts to the table.

        Parameters:
         - table: the table to put data in
         - tputs: a list of TPuts to commit
        """
        self.send_putMultiple(table, tputs)
        self.recv_putMultiple()

    def send_putMultiple(self, table, tputs):
        self._oprot.writeMessageBegin('putMultiple', TMessageType.CALL, self._seqid)
        args = putMultiple_args()
        args.table = table
        args.tputs = tputs
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_putMultiple(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = putMultiple_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def deleteSingle(self, table, tdelete):
        """
        Deletes as specified by the TDelete.

        Note: "delete" is a reserved keyword and cannot be used in Thrift
        thus the inconsistent naming scheme from the other functions.

        Parameters:
         - table: the table to delete from
         - tdelete: the TDelete to delete
        """
        self.send_deleteSingle(table, tdelete)
        self.recv_deleteSingle()

    def send_deleteSingle(self, table, tdelete):
        self._oprot.writeMessageBegin('deleteSingle', TMessageType.CALL, self._seqid)
        args = deleteSingle_args()
        args.table = table
        args.tdelete = tdelete
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteSingle(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteSingle_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def deleteMultiple(self, table, tdeletes):
        """
        Bulk commit a List of TDeletes to the table.

        Throws a TIOError if any of the deletes fail.

        Always returns an empty list for backwards compatibility.

        Parameters:
         - table: the table to delete from
         - tdeletes: list of TDeletes to delete
        """
        self.send_deleteMultiple(table, tdeletes)
        return self.recv_deleteMultiple()

    def send_deleteMultiple(self, table, tdeletes):
        self._oprot.writeMessageBegin('deleteMultiple', TMessageType.CALL, self._seqid)
        args = deleteMultiple_args()
        args.table = table
        args.tdeletes = tdeletes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteMultiple(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteMultiple_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "deleteMultiple failed: unknown result")

    def checkAndDelete(self, table, row, family, qualifier, value, tdelete):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the delete.

        @return true if the new delete was executed, false otherwise

        Parameters:
         - table: to check in and delete from
         - row: row to check
         - family: column family to check
         - qualifier: column qualifier to check
         - value: the expected value, if not provided the
        check is for the non-existence of the
        column in question
         - tdelete: the TDelete to execute if the check succeeds
        """
        self.send_checkAndDelete(table, row, family, qualifier, value, tdelete)
        return self.recv_checkAndDelete()

    def send_checkAndDelete(self, table, row, family, qualifier, value, tdelete):
        self._oprot.writeMessageBegin('checkAndDelete', TMessageType.CALL, self._seqid)
        args = checkAndDelete_args()
        args.table = table
        args.row = row
        args.family = family
        args.qualifier = qualifier
        args.value = value
        args.tdelete = tdelete
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_checkAndDelete(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = checkAndDelete_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndDelete failed: unknown result")

    def increment(self, table, tincrement):
        """
        Parameters:
         - table: the table to increment the value on
         - tincrement: the TIncrement to increment
        """
        self.send_increment(table, tincrement)
        return self.recv_increment()

    def send_increment(self, table, tincrement):
        self._oprot.writeMessageBegin('increment', TMessageType.CALL, self._seqid)
        args = increment_args()
        args.table = table
        args.tincrement = tincrement
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_increment(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = increment_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "increment failed: unknown result")

    def append(self, table, tappend):
        """
        Parameters:
         - table: the table to append the value on
         - tappend: the TAppend to append
        """
        self.send_append(table, tappend)
        return self.recv_append()

    def send_append(self, table, tappend):
        self._oprot.writeMessageBegin('append', TMessageType.CALL, self._seqid)
        args = append_args()
        args.table = table
        args.tappend = tappend
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_append(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = append_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "append failed: unknown result")

    def openScanner(self, table, tscan):
        """
        Get a Scanner for the provided TScan object.

        @return Scanner Id to be used with other scanner procedures

        Parameters:
         - table: the table to get the Scanner for
         - tscan: the scan object to get a Scanner for
        """
        self.send_openScanner(table, tscan)
        return self.recv_openScanner()

    def send_openScanner(self, table, tscan):
        self._oprot.writeMessageBegin('openScanner', TMessageType.CALL, self._seqid)
        args = openScanner_args()
        args.table = table
        args.tscan = tscan
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_openScanner(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = openScanner_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "openScanner failed: unknown result")

    def getScannerRows(self, scannerId, numRows):
        """
        Grabs multiple rows from a Scanner.

        @return Between zero and numRows TResults

        Parameters:
         - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
         - numRows: number of rows to return
        """
        self.send_getScannerRows(scannerId, numRows)
        return self.recv_getScannerRows()

    def send_getScannerRows(self, scannerId, numRows):
        self._oprot.writeMessageBegin('getScannerRows', TMessageType.CALL, self._seqid)
        args = getScannerRows_args()
        args.scannerId = scannerId
        args.numRows = numRows
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getScannerRows(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getScannerRows_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getScannerRows failed: unknown result")

    def closeScanner(self, scannerId):
        """
        Closes the scanner. Should be called to free server side resources timely.
        Typically close once the scanner is not needed anymore, i.e. after looping
        over it to get all the required rows.

        Parameters:
         - scannerId: the Id of the Scanner to close *
        """
        self.send_closeScanner(scannerId)
        self.recv_closeScanner()

    def send_closeScanner(self, scannerId):
        self._oprot.writeMessageBegin('closeScanner', TMessageType.CALL, self._seqid)
        args = closeScanner_args()
        args.scannerId = scannerId
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_closeScanner(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = closeScanner_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def mutateRow(self, table, trowMutations):
        """
        mutateRow performs multiple mutations atomically on a single row.

        Parameters:
         - table: table to apply the mutations
         - trowMutations: mutations to apply
        """
        self.send_mutateRow(table, trowMutations)
        self.recv_mutateRow()

    def send_mutateRow(self, table, trowMutations):
        self._oprot.writeMessageBegin('mutateRow', TMessageType.CALL, self._seqid)
        args = mutateRow_args()
        args.table = table
        args.trowMutations = trowMutations
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_mutateRow(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mutateRow_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def getScannerResults(self, table, tscan, numRows):
        """
        Get results for the provided TScan object.
        This helper function opens a scanner, get the results and close the scanner.

        @return between zero and numRows TResults

        Parameters:
         - table: the table to get the Scanner for
         - tscan: the scan object to get a Scanner for
         - numRows: number of rows to return
        """
        self.send_getScannerResults(table, tscan, numRows)
        return self.recv_getScannerResults()

    def send_getScannerResults(self, table, tscan, numRows):
        self._oprot.writeMessageBegin('getScannerResults', TMessageType.CALL, self._seqid)
        args = getScannerResults_args()
        args.table = table
        args.tscan = tscan
        args.numRows = numRows
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getScannerResults(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getScannerResults_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getScannerResults failed: unknown result")

    def getRegionLocation(self, table, row, reload):
        """
        Given a table and a row get the location of the region that
        would contain the given row key.

        reload = true means the cache will be cleared and the location
        will be fetched from meta.

        Parameters:
         - table
         - row
         - reload
        """
        self.send_getRegionLocation(table, row, reload)
        return self.recv_getRegionLocation()

    def send_getRegionLocation(self, table, row, reload):
        self._oprot.writeMessageBegin('getRegionLocation', TMessageType.CALL, self._seqid)
        args = getRegionLocation_args()
        args.table = table
        args.row = row
        args.reload = reload
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRegionLocation(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRegionLocation_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRegionLocation failed: unknown result")

    def getAllRegionLocations(self, table):
        """
        Get all of the region locations for a given table.


        Parameters:
         - table
        """
        self.send_getAllRegionLocations(table)
        return self.recv_getAllRegionLocations()

    def send_getAllRegionLocations(self, table):
        self._oprot.writeMessageBegin('getAllRegionLocations', TMessageType.CALL, self._seqid)
        args = getAllRegionLocations_args()
        args.table = table
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getAllRegionLocations(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getAllRegionLocations_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getAllRegionLocations failed: unknown result")


class Processor(Iface, TProcessor):
    def __init__(self, handler):
        self._handler = handler
        self._processMap = {}
        self._processMap["exists"] = Processor.process_exists
        self._processMap["get"] = Processor.process_get
        self._processMap["getMultiple"] = Processor.process_getMultiple
        self._processMap["put"] = Processor.process_put
        self._processMap["checkAndPut"] = Processor.process_checkAndPut
        self._processMap["putMultiple"] = Processor.process_putMultiple
        self._processMap["deleteSingle"] = Processor.process_deleteSingle
        self._processMap["deleteMultiple"] = Processor.process_deleteMultiple
        self._processMap["checkAndDelete"] = Processor.process_checkAndDelete
        self._processMap["increment"] = Processor.process_increment
        self._processMap["append"] = Processor.process_append
        self._processMap["openScanner"] = Processor.process_openScanner
        self._processMap["getScannerRows"] = Processor.process_getScannerRows
        self._processMap["closeScanner"] = Processor.process_closeScanner
        self._processMap["mutateRow"] = Processor.process_mutateRow
        self._processMap["getScannerResults"] = Processor.process_getScannerResults
        self._processMap["getRegionLocation"] = Processor.process_getRegionLocation
        self._processMap["getAllRegionLocations"] = Processor.process_getAllRegionLocations

    def process(self, iprot, oprot):
        (name, type, seqid) = iprot.readMessageBegin()
        if name not in self._processMap:
            iprot.skip(TType.STRUCT)
            iprot.readMessageEnd()
            x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
            oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
            x.write(oprot)
            oprot.writeMessageEnd()
            oprot.trans.flush()
            return
        else:
            self._processMap[name](self, seqid, iprot, oprot)
        return True

    def process_exists(self, seqid, iprot, oprot):
        args = exists_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = exists_result()
        try:
            result.success = self._handler.exists(args.table, args.tget)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("exists", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_get(self, seqid, iprot, oprot):
        args = get_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = get_result()
        try:
            result.success = self._handler.get(args.table, args.tget)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("get", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getMultiple(self, seqid, iprot, oprot):
        args = getMultiple_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getMultiple_result()
        try:
            result.success = self._handler.getMultiple(args.table, args.tgets)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getMultiple", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_put(self, seqid, iprot, oprot):
        args = put_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = put_result()
        try:
            self._handler.put(args.table, args.tput)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("put", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_checkAndPut(self, seqid, iprot, oprot):
        args = checkAndPut_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = checkAndPut_result()
        try:
            result.success = self._handler.checkAndPut(args.table, args.row, args.family, args.qualifier, args.value, args.tput)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("checkAndPut", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_putMultiple(self, seqid, iprot, oprot):
        args = putMultiple_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = putMultiple_result()
        try:
            self._handler.putMultiple(args.table, args.tputs)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("putMultiple", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteSingle(self, seqid, iprot, oprot):
        args = deleteSingle_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteSingle_result()
        try:
            self._handler.deleteSingle(args.table, args.tdelete)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteSingle", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteMultiple(self, seqid, iprot, oprot):
        args = deleteMultiple_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteMultiple_result()
        try:
            result.success = self._handler.deleteMultiple(args.table, args.tdeletes)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteMultiple", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_checkAndDelete(self, seqid, iprot, oprot):
        args = checkAndDelete_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = checkAndDelete_result()
        try:
            result.success = self._handler.checkAndDelete(args.table, args.row, args.family, args.qualifier, args.value, args.tdelete)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("checkAndDelete", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_increment(self, seqid, iprot, oprot):
        args = increment_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = increment_result()
        try:
            result.success = self._handler.increment(args.table, args.tincrement)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("increment", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_append(self, seqid, iprot, oprot):
        args = append_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = append_result()
        try:
            result.success = self._handler.append(args.table, args.tappend)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("append", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_openScanner(self, seqid, iprot, oprot):
        args = openScanner_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = openScanner_result()
        try:
            result.success = self._handler.openScanner(args.table, args.tscan)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("openScanner", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getScannerRows(self, seqid, iprot, oprot):
        args = getScannerRows_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getScannerRows_result()
        try:
            result.success = self._handler.getScannerRows(args.scannerId, args.numRows)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TIllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getScannerRows", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_closeScanner(self, seqid, iprot, oprot):
        args = closeScanner_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = closeScanner_result()
        try:
            self._handler.closeScanner(args.scannerId)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TIllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("closeScanner", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_mutateRow(self, seqid, iprot, oprot):
        args = mutateRow_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mutateRow_result()
        try:
            self._handler.mutateRow(args.table, args.trowMutations)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mutateRow", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getScannerResults(self, seqid, iprot, oprot):
        args = getScannerResults_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getScannerResults_result()
        try:
            result.success = self._handler.getScannerResults(args.table, args.tscan, args.numRows)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getScannerResults", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRegionLocation(self, seqid, iprot, oprot):
        args = getRegionLocation_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRegionLocation_result()
        try:
            result.success = self._handler.getRegionLocation(args.table, args.row, args.reload)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRegionLocation", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getAllRegionLocations(self, seqid, iprot, oprot):
        args = getAllRegionLocations_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getAllRegionLocations_result()
        try:
            result.success = self._handler.getAllRegionLocations(args.table)
            msg_type = TMessageType.REPLY
        except (TTransport.TTransportException, KeyboardInterrupt, SystemExit):
            raise
        except TIOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except Exception as ex:
            msg_type = TMessageType.EXCEPTION
            logging.exception(ex)
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getAllRegionLocations", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

# HELPER FUNCTIONS AND STRUCTURES


class exists_args(object):
    """
    Attributes:
     - table: the table to check on
     - tget: the TGet to check for
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tget', (TGet, TGet.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tget=None,):
        self.table = table
        self.tget = tget

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tget = TGet()
                    self.tget.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('exists_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tget is not None:
            oprot.writeFieldBegin('tget', TType.STRUCT, 2)
            self.tget.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tget is None:
            raise TProtocolException(message='Required field tget is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class exists_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.BOOL, 'success', None, None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.BOOL:
                    self.success = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('exists_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.BOOL, 0)
            oprot.writeBool(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class get_args(object):
    """
    Attributes:
     - table: the table to get from
     - tget: the TGet to fetch
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tget', (TGet, TGet.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tget=None,):
        self.table = table
        self.tget = tget

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tget = TGet()
                    self.tget.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('get_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tget is not None:
            oprot.writeFieldBegin('tget', TType.STRUCT, 2)
            self.tget.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tget is None:
            raise TProtocolException(message='Required field tget is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class get_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.STRUCT, 'success', (TResult, TResult.thrift_spec), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TResult()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('get_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getMultiple_args(object):
    """
    Attributes:
     - table: the table to get from
     - tgets: a list of TGets to fetch, the Result list
    will have the Results at corresponding positions
    or null if there was an error
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.LIST, 'tgets', (TType.STRUCT, (TGet, TGet.thrift_spec), False), None, ),  # 2
    )

    def __init__(self, table=None, tgets=None,):
        self.table = table
        self.tgets = tgets

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.tgets = []
                    (_etype120, _size117) = iprot.readListBegin()
                    for _i121 in range(_size117):
                        _elem122 = TGet()
                        _elem122.read(iprot)
                        self.tgets.append(_elem122)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getMultiple_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tgets is not None:
            oprot.writeFieldBegin('tgets', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.tgets))
            for iter123 in self.tgets:
                iter123.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tgets is None:
            raise TProtocolException(message='Required field tgets is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getMultiple_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.LIST, 'success', (TType.STRUCT, (TResult, TResult.thrift_spec), False), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype127, _size124) = iprot.readListBegin()
                    for _i128 in range(_size124):
                        _elem129 = TResult()
                        _elem129.read(iprot)
                        self.success.append(_elem129)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getMultiple_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter130 in self.success:
                iter130.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class put_args(object):
    """
    Attributes:
     - table: the table to put data in
     - tput: the TPut to put
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tput', (TPut, TPut.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tput=None,):
        self.table = table
        self.tput = tput

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tput = TPut()
                    self.tput.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('put_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tput is not None:
            oprot.writeFieldBegin('tput', TType.STRUCT, 2)
            self.tput.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tput is None:
            raise TProtocolException(message='Required field tput is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class put_result(object):
    """
    Attributes:
     - io
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('put_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkAndPut_args(object):
    """
    Attributes:
     - table: to check in and put to
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - tput: the TPut to put if the check succeeds
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
        (3, TType.STRING, 'family', 'BINARY', None, ),  # 3
        (4, TType.STRING, 'qualifier', 'BINARY', None, ),  # 4
        (5, TType.STRING, 'value', 'BINARY', None, ),  # 5
        (6, TType.STRUCT, 'tput', (TPut, TPut.thrift_spec), None, ),  # 6
    )

    def __init__(self, table=None, row=None, family=None, qualifier=None, value=None, tput=None,):
        self.table = table
        self.row = row
        self.family = family
        self.qualifier = qualifier
        self.value = value
        self.tput = tput

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.family = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.qualifier = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.value = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRUCT:
                    self.tput = TPut()
                    self.tput.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('checkAndPut_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.family is not None:
            oprot.writeFieldBegin('family', TType.STRING, 3)
            oprot.writeBinary(self.family)
            oprot.writeFieldEnd()
        if self.qualifier is not None:
            oprot.writeFieldBegin('qualifier', TType.STRING, 4)
            oprot.writeBinary(self.qualifier)
            oprot.writeFieldEnd()
        if self.value is not None:
            oprot.writeFieldBegin('value', TType.STRING, 5)
            oprot.writeBinary(self.value)
            oprot.writeFieldEnd()
        if self.tput is not None:
            oprot.writeFieldBegin('tput', TType.STRUCT, 6)
            self.tput.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.row is None:
            raise TProtocolException(message='Required field row is unset!')
        if self.family is None:
            raise TProtocolException(message='Required field family is unset!')
        if self.qualifier is None:
            raise TProtocolException(message='Required field qualifier is unset!')
        if self.tput is None:
            raise TProtocolException(message='Required field tput is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkAndPut_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.BOOL, 'success', None, None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.BOOL:
                    self.success = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('checkAndPut_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.BOOL, 0)
            oprot.writeBool(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class putMultiple_args(object):
    """
    Attributes:
     - table: the table to put data in
     - tputs: a list of TPuts to commit
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.LIST, 'tputs', (TType.STRUCT, (TPut, TPut.thrift_spec), False), None, ),  # 2
    )

    def __init__(self, table=None, tputs=None,):
        self.table = table
        self.tputs = tputs

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.tputs = []
                    (_etype134, _size131) = iprot.readListBegin()
                    for _i135 in range(_size131):
                        _elem136 = TPut()
                        _elem136.read(iprot)
                        self.tputs.append(_elem136)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('putMultiple_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tputs is not None:
            oprot.writeFieldBegin('tputs', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.tputs))
            for iter137 in self.tputs:
                iter137.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tputs is None:
            raise TProtocolException(message='Required field tputs is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class putMultiple_result(object):
    """
    Attributes:
     - io
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('putMultiple_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class deleteSingle_args(object):
    """
    Attributes:
     - table: the table to delete from
     - tdelete: the TDelete to delete
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tdelete', (TDelete, TDelete.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tdelete=None,):
        self.table = table
        self.tdelete = tdelete

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tdelete = TDelete()
                    self.tdelete.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('deleteSingle_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tdelete is not None:
            oprot.writeFieldBegin('tdelete', TType.STRUCT, 2)
            self.tdelete.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tdelete is None:
            raise TProtocolException(message='Required field tdelete is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class deleteSingle_result(object):
    """
    Attributes:
     - io
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('deleteSingle_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class deleteMultiple_args(object):
    """
    Attributes:
     - table: the table to delete from
     - tdeletes: list of TDeletes to delete
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.LIST, 'tdeletes', (TType.STRUCT, (TDelete, TDelete.thrift_spec), False), None, ),  # 2
    )

    def __init__(self, table=None, tdeletes=None,):
        self.table = table
        self.tdeletes = tdeletes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.tdeletes = []
                    (_etype141, _size138) = iprot.readListBegin()
                    for _i142 in range(_size138):
                        _elem143 = TDelete()
                        _elem143.read(iprot)
                        self.tdeletes.append(_elem143)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('deleteMultiple_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tdeletes is not None:
            oprot.writeFieldBegin('tdeletes', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.tdeletes))
            for iter144 in self.tdeletes:
                iter144.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tdeletes is None:
            raise TProtocolException(message='Required field tdeletes is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class deleteMultiple_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.LIST, 'success', (TType.STRUCT, (TDelete, TDelete.thrift_spec), False), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype148, _size145) = iprot.readListBegin()
                    for _i149 in range(_size145):
                        _elem150 = TDelete()
                        _elem150.read(iprot)
                        self.success.append(_elem150)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('deleteMultiple_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter151 in self.success:
                iter151.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkAndDelete_args(object):
    """
    Attributes:
     - table: to check in and delete from
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - tdelete: the TDelete to execute if the check succeeds
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
        (3, TType.STRING, 'family', 'BINARY', None, ),  # 3
        (4, TType.STRING, 'qualifier', 'BINARY', None, ),  # 4
        (5, TType.STRING, 'value', 'BINARY', None, ),  # 5
        (6, TType.STRUCT, 'tdelete', (TDelete, TDelete.thrift_spec), None, ),  # 6
    )

    def __init__(self, table=None, row=None, family=None, qualifier=None, value=None, tdelete=None,):
        self.table = table
        self.row = row
        self.family = family
        self.qualifier = qualifier
        self.value = value
        self.tdelete = tdelete

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.family = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.qualifier = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.value = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRUCT:
                    self.tdelete = TDelete()
                    self.tdelete.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('checkAndDelete_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.family is not None:
            oprot.writeFieldBegin('family', TType.STRING, 3)
            oprot.writeBinary(self.family)
            oprot.writeFieldEnd()
        if self.qualifier is not None:
            oprot.writeFieldBegin('qualifier', TType.STRING, 4)
            oprot.writeBinary(self.qualifier)
            oprot.writeFieldEnd()
        if self.value is not None:
            oprot.writeFieldBegin('value', TType.STRING, 5)
            oprot.writeBinary(self.value)
            oprot.writeFieldEnd()
        if self.tdelete is not None:
            oprot.writeFieldBegin('tdelete', TType.STRUCT, 6)
            self.tdelete.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.row is None:
            raise TProtocolException(message='Required field row is unset!')
        if self.family is None:
            raise TProtocolException(message='Required field family is unset!')
        if self.qualifier is None:
            raise TProtocolException(message='Required field qualifier is unset!')
        if self.tdelete is None:
            raise TProtocolException(message='Required field tdelete is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class checkAndDelete_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.BOOL, 'success', None, None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.BOOL:
                    self.success = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('checkAndDelete_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.BOOL, 0)
            oprot.writeBool(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class increment_args(object):
    """
    Attributes:
     - table: the table to increment the value on
     - tincrement: the TIncrement to increment
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tincrement', (TIncrement, TIncrement.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tincrement=None,):
        self.table = table
        self.tincrement = tincrement

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tincrement = TIncrement()
                    self.tincrement.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('increment_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tincrement is not None:
            oprot.writeFieldBegin('tincrement', TType.STRUCT, 2)
            self.tincrement.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tincrement is None:
            raise TProtocolException(message='Required field tincrement is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class increment_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.STRUCT, 'success', (TResult, TResult.thrift_spec), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TResult()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('increment_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class append_args(object):
    """
    Attributes:
     - table: the table to append the value on
     - tappend: the TAppend to append
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tappend', (TAppend, TAppend.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tappend=None,):
        self.table = table
        self.tappend = tappend

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tappend = TAppend()
                    self.tappend.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('append_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tappend is not None:
            oprot.writeFieldBegin('tappend', TType.STRUCT, 2)
            self.tappend.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tappend is None:
            raise TProtocolException(message='Required field tappend is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class append_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.STRUCT, 'success', (TResult, TResult.thrift_spec), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TResult()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('append_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class openScanner_args(object):
    """
    Attributes:
     - table: the table to get the Scanner for
     - tscan: the scan object to get a Scanner for
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tscan', (TScan, TScan.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, tscan=None,):
        self.table = table
        self.tscan = tscan

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tscan = TScan()
                    self.tscan.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('openScanner_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tscan is not None:
            oprot.writeFieldBegin('tscan', TType.STRUCT, 2)
            self.tscan.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tscan is None:
            raise TProtocolException(message='Required field tscan is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class openScanner_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.I32, 'success', None, None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('openScanner_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getScannerRows_args(object):
    """
    Attributes:
     - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     - numRows: number of rows to return
    """

    thrift_spec = (
        None,  # 0
        (1, TType.I32, 'scannerId', None, None, ),  # 1
        (2, TType.I32, 'numRows', None, 1, ),  # 2
    )

    def __init__(self, scannerId=None, numRows=thrift_spec[2][4],):
        self.scannerId = scannerId
        self.numRows = numRows

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.scannerId = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.numRows = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getScannerRows_args')
        if self.scannerId is not None:
            oprot.writeFieldBegin('scannerId', TType.I32, 1)
            oprot.writeI32(self.scannerId)
            oprot.writeFieldEnd()
        if self.numRows is not None:
            oprot.writeFieldBegin('numRows', TType.I32, 2)
            oprot.writeI32(self.numRows)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.scannerId is None:
            raise TProtocolException(message='Required field scannerId is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getScannerRows_result(object):
    """
    Attributes:
     - success
     - io
     - ia: if the scannerId is invalid
    """

    thrift_spec = (
        (0, TType.LIST, 'success', (TType.STRUCT, (TResult, TResult.thrift_spec), False), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
        (2, TType.STRUCT, 'ia', (TIllegalArgument, TIllegalArgument.thrift_spec), None, ),  # 2
    )

    def __init__(self, success=None, io=None, ia=None,):
        self.success = success
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype155, _size152) = iprot.readListBegin()
                    for _i156 in range(_size152):
                        _elem157 = TResult()
                        _elem157.read(iprot)
                        self.success.append(_elem157)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = TIllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getScannerRows_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter158 in self.success:
                iter158.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class closeScanner_args(object):
    """
    Attributes:
     - scannerId: the Id of the Scanner to close *
    """

    thrift_spec = (
        None,  # 0
        (1, TType.I32, 'scannerId', None, None, ),  # 1
    )

    def __init__(self, scannerId=None,):
        self.scannerId = scannerId

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.scannerId = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('closeScanner_args')
        if self.scannerId is not None:
            oprot.writeFieldBegin('scannerId', TType.I32, 1)
            oprot.writeI32(self.scannerId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.scannerId is None:
            raise TProtocolException(message='Required field scannerId is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class closeScanner_result(object):
    """
    Attributes:
     - io
     - ia: if the scannerId is invalid
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
        (2, TType.STRUCT, 'ia', (TIllegalArgument, TIllegalArgument.thrift_spec), None, ),  # 2
    )

    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = TIllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('closeScanner_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class mutateRow_args(object):
    """
    Attributes:
     - table: table to apply the mutations
     - trowMutations: mutations to apply
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'trowMutations', (TRowMutations, TRowMutations.thrift_spec), None, ),  # 2
    )

    def __init__(self, table=None, trowMutations=None,):
        self.table = table
        self.trowMutations = trowMutations

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.trowMutations = TRowMutations()
                    self.trowMutations.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('mutateRow_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.trowMutations is not None:
            oprot.writeFieldBegin('trowMutations', TType.STRUCT, 2)
            self.trowMutations.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.trowMutations is None:
            raise TProtocolException(message='Required field trowMutations is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class mutateRow_result(object):
    """
    Attributes:
     - io
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('mutateRow_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getScannerResults_args(object):
    """
    Attributes:
     - table: the table to get the Scanner for
     - tscan: the scan object to get a Scanner for
     - numRows: number of rows to return
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRUCT, 'tscan', (TScan, TScan.thrift_spec), None, ),  # 2
        (3, TType.I32, 'numRows', None, 1, ),  # 3
    )

    def __init__(self, table=None, tscan=None, numRows=thrift_spec[3][4],):
        self.table = table
        self.tscan = tscan
        self.numRows = numRows

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.tscan = TScan()
                    self.tscan.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.numRows = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getScannerResults_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.tscan is not None:
            oprot.writeFieldBegin('tscan', TType.STRUCT, 2)
            self.tscan.write(oprot)
            oprot.writeFieldEnd()
        if self.numRows is not None:
            oprot.writeFieldBegin('numRows', TType.I32, 3)
            oprot.writeI32(self.numRows)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.tscan is None:
            raise TProtocolException(message='Required field tscan is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getScannerResults_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.LIST, 'success', (TType.STRUCT, (TResult, TResult.thrift_spec), False), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype162, _size159) = iprot.readListBegin()
                    for _i163 in range(_size159):
                        _elem164 = TResult()
                        _elem164.read(iprot)
                        self.success.append(_elem164)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getScannerResults_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter165 in self.success:
                iter165.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getRegionLocation_args(object):
    """
    Attributes:
     - table
     - row
     - reload
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
        (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
        (3, TType.BOOL, 'reload', None, None, ),  # 3
    )

    def __init__(self, table=None, row=None, reload=None,):
        self.table = table
        self.row = row
        self.reload = reload

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.BOOL:
                    self.reload = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getRegionLocation_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.reload is not None:
            oprot.writeFieldBegin('reload', TType.BOOL, 3)
            oprot.writeBool(self.reload)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        if self.row is None:
            raise TProtocolException(message='Required field row is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getRegionLocation_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.STRUCT, 'success', (THRegionLocation, THRegionLocation.thrift_spec), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = THRegionLocation()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getRegionLocation_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getAllRegionLocations_args(object):
    """
    Attributes:
     - table
    """

    thrift_spec = (
        None,  # 0
        (1, TType.STRING, 'table', 'BINARY', None, ),  # 1
    )

    def __init__(self, table=None,):
        self.table = table

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.table = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getAllRegionLocations_args')
        if self.table is not None:
            oprot.writeFieldBegin('table', TType.STRING, 1)
            oprot.writeBinary(self.table)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.table is None:
            raise TProtocolException(message='Required field table is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class getAllRegionLocations_result(object):
    """
    Attributes:
     - success
     - io
    """

    thrift_spec = (
        (0, TType.LIST, 'success', (TType.STRUCT, (THRegionLocation, THRegionLocation.thrift_spec), False), None, ),  # 0
        (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ),  # 1
    )

    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, (self.__class__, self.thrift_spec))
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype169, _size166) = iprot.readListBegin()
                    for _i170 in range(_size166):
                        _elem171 = THRegionLocation()
                        _elem171.read(iprot)
                        self.success.append(_elem171)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = TIOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, (self.__class__, self.thrift_spec)))
            return
        oprot.writeStructBegin('getAllRegionLocations_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter172 in self.success:
                iter172.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
