"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.ServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "ServiceProperty", { enumerable: true, get: function () { return fc_generated_1.RosService; } });
/**
 * A ROS resource type:  `ALIYUN::FC::Service`
 */
class Service extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::Service`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosService = new fc_generated_1.RosService(this, id, {
            role: props.role,
            internetAccess: props.internetAccess,
            description: props.description,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            tracingConfig: props.tracingConfig,
            vpcConfig: props.vpcConfig,
            serviceName: props.serviceName,
            vpcBindings: props.vpcBindings,
            tags: props.tags,
            nasConfig: props.nasConfig,
            logConfig: props.logConfig,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosService;
        this.attrInternetAccess = rosService.attrInternetAccess;
        this.attrLogProject = rosService.attrLogProject;
        this.attrLogstore = rosService.attrLogstore;
        this.attrRole = rosService.attrRole;
        this.attrServiceId = rosService.attrServiceId;
        this.attrServiceName = rosService.attrServiceName;
        this.attrTags = rosService.attrTags;
        this.attrVpcId = rosService.attrVpcId;
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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