from grep_ips.grep_ips import GrepIPs


def test_grep_ips() -> None:
    ip_test_strings = [
        '88.1.1.1',
        'IPs 88.1.1.2, 1.2.3.4, 9.9.9.9, etc.',
        '239.255.255.254',
        'fdsjaefwe--2.2.2.2--',
        '<123.123.123.123>, <11.11.11.11>',
        '7.8.9.10;11.12.13.14;15.16.17.19;20.21.22.23;',
        '7.8.9.10,11.12.13.14,15.16.17.19,20.21.22.23',
        'fdsjaefwe--::111,[::222]',
        '2604:ba90:111:83::2:5050',
        'abcd:a880::6:1000, ::8, 1::8, ::2:3:4:5:6:7:8, ',
        '[2:3:4:5:6:7:8:9],[10::11],[12:13:14:15::16],',
        '==9001:0db8:0000:0000:0000:ff00:0042:8329==',
        # begin invalid tests
        '888.1.1.1',
        '1234.23.53.53',
        '1.2.3.4.5',
        'aa2.2.2.2',
        '2.2..2.2',
        '127.0.0.1',
        '::1, ::',
        '<192.168.1.100>',
        '3.3.3',
        '4.4.4.4B',
        'fd18:a880:::6:1000',
        'fd18:a880::6::1000',
        'ffd18:a880::6:1000',
        'fd18:a880:1:6:100g',
        '1:2:3:4:5:6:7:8:9',
    ]
    expected_results = [
        ['88.1.1.1'],
        ['88.1.1.2', '1.2.3.4', '9.9.9.9'],
        ['239.255.255.254'],
        ['2.2.2.2'],
        ['123.123.123.123', '11.11.11.11'],
        ['7.8.9.10', '11.12.13.14', '15.16.17.19', '20.21.22.23'],
        ['7.8.9.10', '11.12.13.14', '15.16.17.19', '20.21.22.23'],
        ['::111', '::222'],
        ['2604:ba90:111:83::2:5050'],
        ['abcd:a880::6:1000', '::8', '1::8'],
        ['2:3:4:5:6:7:8:9', '10::11', '12:13:14:15::16'],
        ['9001:db8::ff00:42:8329'],
    ] + [[] for i in range(15)]
    ip_test_results = [
        [str(ip) for ip in GrepIPs.grep_ips(ips, global_ips_only=True)] for ips in ip_test_strings
    ]
    assert ip_test_results == expected_results, f"actual results: {ip_test_results}"
