NSPIN = 1
PRESSURE = -93.51
TOTAL_FORCE = 1e-06
FERMI_ENERGY = 3.209
TOTAL_ENERGY = -8.208

BASIS = {
    "units": "angstrom",
    "elements": [{"id": 0, "value": "Si"}, {"id": 1, "value": "Si"}],
    "coordinates": [{"id": 0, "value": [0.0, 0.0, 0.0]}, {"id": 1, "value": [1.1163067500000001, 0.789348, 1.9335]}],
}

LATTICE = {
    "vectors": {
        "a": [3.34892, 0.0, 1.9335],
        "units": "angstrom",
        "c": [0.0, 0.0, 3.867],
        "b": [1.116307, 3.157392, 1.9335],
        "alat": 1.0,
    }
}

CONVERGENCE_ELECTRONIC = [
    [
        4.29350000e02,
        -3.35170000e02,
        -8.83550000e01,
        -1.25260000e01,
        -1.80150000e00,
        1.94490000e-01,
        1.06520000e-01,
        -6.20760000e-03,
        -4.51130000e-04,
        -9.95120000e-05,
    ]
]

STRESS_TENSOR = [[-93.50828664, -9.87e-06, 0.0], [-9.87e-06, -93.50828335, 0.0], [-0.0, 0.0, -93.50829984]]

ATOMIC_FORCES = [[0.0, -0.0, -0.0], [-0.0, 0.0, 0.0]]

MAGNETIC_MOMENTS = [[0.002, -0.003, 0.0], [-0.002, 0.003, -0.0]]

TOTAL_ENERGY_CONTRIBUTION = {
    "hartree": {"name": "hartree", "value": 856.53054951796355},
    "ewald": {"name": "ewald", "value": 1179.2331674536013},
    "exchange_correlation": {"name": "exchange_correlation", "value": 273.95823951955998},
}

CONVERGENCE_IONIC = [
    {
        "energy": -8.20830744738,
        "electronic": {
            "units": "eV",
            "data": [
                429.35,
                -335.17,
                -88.355,
                -12.526,
                -1.8015,
                0.19449,
                0.10652,
                -0.0062076,
                -0.00045113,
                -9.9512e-05,
            ],
        },
        "structure": {
            "lattice": {
                "vectors": {
                    "a": [3.34892, 0.0, 1.9335],
                    "c": [0.0, 0.0, 3.867],
                    "b": [1.116307, 3.157392, 1.9335],
                    "alat": 1.0,
                }
            },
            "basis": {
                "units": "angstrom",
                "elements": [{"id": 0, "value": "Si"}, {"id": 1, "value": "Si"}],
                "coordinates": [{"id": 0, "value": [0.0, 0.0, 0.0]}, {"id": 1, "value": [1.11631, 0.78935, 1.9335]}],
            },
        },
    }
]

IBZ_KPOINTS = [
    [
        0,
        0,
        0,
    ],
    [
        0.5,
        0,
        0,
    ],
    [
        0.5,
        0.5,
        0,
    ],
]

EIGENVALUES_AT_KPOINTS_ZERO = {
    "kpoint": [0.0, 0.0, 0.0],
    "weight": 0.125,
    "eigenvalues": [
        {
            "energies": [
                -130.6782,
                -130.6481,
                -86.7506,
                -86.7506,
                -86.7506,
                -86.7379,
                -86.7379,
                -86.7379,
                -9.0026,
                2.8751,
                2.8751,
                2.8752,
                5.2991,
                5.2991,
                5.2992,
                6.0054,
            ],
            "spin": 0.5,
            "occupations": [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0],
        }
    ],
}

DOS = {
    "energy": [
        -137.8505,
        -137.3246,
        -136.7988,
        -136.273,
        -135.7471,
        -135.2213,
        -134.6955,
        -134.1697,
        -133.6438,
        -133.118,
        -132.5922,
        -132.0663,
        -131.5405,
        -131.0147,
        -130.4888,
        -129.963,
        -129.4372,
        -128.9114,
        -128.3855,
        -127.8597,
        -127.3339,
        -126.808,
        -126.2822,
        -125.7564,
        -125.2305,
        -124.7047,
        -124.1789,
        -123.6531,
        -123.1272,
        -122.6014,
        -122.0756,
        -121.5497,
        -121.0239,
        -120.4981,
        -119.9722,
        -119.4464,
        -118.9206,
        -118.3948,
        -117.8689,
        -117.3431,
        -116.8173,
        -116.2914,
        -115.7656,
        -115.2398,
        -114.7139,
        -114.1881,
        -113.6623,
        -113.1365,
        -112.6106,
        -112.0848,
        -111.559,
        -111.0331,
        -110.5073,
        -109.9815,
        -109.4556,
        -108.9298,
        -108.404,
        -107.8782,
        -107.3523,
        -106.8265,
        -106.3007,
        -105.7748,
        -105.249,
        -104.7232,
        -104.1973,
        -103.6715,
        -103.1457,
        -102.6199,
        -102.094,
        -101.5682,
        -101.0424,
        -100.5165,
        -99.9907,
        -99.4649,
        -98.939,
        -98.4132,
        -97.8874,
        -97.3616,
        -96.8357,
        -96.3099,
        -95.7841,
        -95.2582,
        -94.7324,
        -94.2066,
        -93.6807,
        -93.1549,
        -92.6291,
        -92.1033,
        -91.5774,
        -91.0516,
        -90.5258,
        -89.9999,
        -89.4741,
        -88.9483,
        -88.4224,
        -87.8966,
        -87.3708,
        -86.845,
        -86.3191,
        -85.7933,
        -85.2675,
        -84.7416,
        -84.2158,
        -83.69,
        -83.1641,
        -82.6383,
        -82.1125,
        -81.5867,
        -81.0608,
        -80.535,
        -80.0092,
        -79.4833,
        -78.9575,
        -78.4317,
        -77.9058,
        -77.38,
        -76.8542,
        -76.3284,
        -75.8025,
        -75.2767,
        -74.7509,
        -74.225,
        -73.6992,
        -73.1734,
        -72.6475,
        -72.1217,
        -71.5959,
        -71.0701,
        -70.5442,
        -70.0184,
        -69.4926,
        -68.9667,
        -68.4409,
        -67.9151,
        -67.3892,
        -66.8634,
        -66.3376,
        -65.8118,
        -65.2859,
        -64.7601,
        -64.2343,
        -63.7084,
        -63.1826,
        -62.6568,
        -62.1309,
        -61.6051,
        -61.0793,
        -60.5535,
        -60.0276,
        -59.5018,
        -58.976,
        -58.4501,
        -57.9243,
        -57.3985,
        -56.8726,
        -56.3468,
        -55.821,
        -55.2952,
        -54.7693,
        -54.2435,
        -53.7177,
        -53.1918,
        -52.666,
        -52.1402,
        -51.6143,
        -51.0885,
        -50.5627,
        -50.0369,
        -49.511,
        -48.9852,
        -48.4594,
        -47.9335,
        -47.4077,
        -46.8819,
        -46.356,
        -45.8302,
        -45.3044,
        -44.7786,
        -44.2527,
        -43.7269,
        -43.2011,
        -42.6752,
        -42.1494,
        -41.6236,
        -41.0977,
        -40.5719,
        -40.0461,
        -39.5203,
        -38.9944,
        -38.4686,
        -37.9428,
        -37.4169,
        -36.8911,
        -36.3653,
        -35.8395,
        -35.3136,
        -34.7878,
        -34.262,
        -33.7361,
        -33.2103,
        -32.6845,
        -32.1586,
        -31.6328,
        -31.107,
        -30.5812,
        -30.0553,
        -29.5295,
        -29.0037,
        -28.4778,
        -27.952,
        -27.4262,
        -26.9003,
        -26.3745,
        -25.8487,
        -25.3229,
        -24.797,
        -24.2712,
        -23.7454,
        -23.2195,
        -22.6937,
        -22.1679,
        -21.642,
        -21.1162,
        -20.5904,
        -20.0646,
        -19.5387,
        -19.0129,
        -18.4871,
        -17.9612,
        -17.4354,
        -16.9096,
        -16.3837,
        -15.8579,
        -15.3321,
        -14.8063,
        -14.2804,
        -13.7546,
        -13.2288,
        -12.7029,
        -12.1771,
        -11.6513,
        -11.1254,
        -10.5996,
        -10.0738,
        -9.548,
        -9.0221,
        -8.4963,
        -7.9705,
        -7.4446,
        -6.9188,
        -6.393,
        -5.8671,
        -5.3413,
        -4.8155,
        -4.2897,
        -3.7638,
        -3.238,
        -2.7122,
        -2.1863,
        -1.6605,
        -1.1347,
        -0.6088,
        -0.083,
        0.4428,
        0.9686,
        1.4945,
        2.0203,
        2.5461,
        3.072,
        3.5978,
        4.1236,
        4.6495,
        5.1753,
        5.7011,
        6.2269,
        6.7528,
        7.2786,
        7.8044,
        8.3303,
        8.8561,
        9.3819,
        9.9078,
        10.4336,
        10.9594,
        11.4852,
        12.0111,
        12.5369,
        13.0627,
        13.5886,
        14.1144,
        14.6402,
        15.1661,
        15.6919,
        16.2177,
        16.7435,
        17.2694,
        17.7952,
        18.321,
        18.8469,
        19.3727,
        19.8985,
    ],
    "partial": [],
    "partial_info": [],
    "total": [
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        7.6068,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0532,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.3654,
        0.0,
        0.0,
        0.0,
        0.0,
        1.2678,
        0.0,
        0.0,
        2.5285,
        0.0,
        1.2678,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0093,
        0.0,
        0.0,
        0.0,
        2.5357,
        0.0,
        3.8035,
        2.5165,
        0.0,
        1.2678,
        0.0013,
        0.0,
        3.8035,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0684,
        0.0,
        0.0,
        0.0,
        0.0,
        2.5357,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
    ],
}
