NSPIN = 1
PRESSURE = 17.84
TOTAL_FORCE = 1e-06
FERMI_ENERGY = 6.501
TOTAL_ENERGY = -260.5336665807204

LATTICE = {
    "units": "angstrom",
    "vectors": {
        "a": [3.348920530934846, 0.0, 1.9335001702807129],
        "b": [1.1163075183116746, 3.1573923180672185, 1.9335001702807129],
        "c": [0.0, 0.0, 3.8670003405614257],
        "alat": 3.8670003401852577,
    },
}

STRESS_TENSOR = [[17.83, -0.0, 0.0], [-0.0, 17.83, 0.0], [0.0, -0.0, 17.84]]

ATOMIC_FORCES = [
    [-1.0027306807212303e-05, -6.170650342899877e-06, 0.0],
    [1.0027306807212303e-05, 6.170650342899877e-06, 0.0],
]

TOTAL_ENERGY_CONTRIBUTION = {
    "ewald": {"name": "ewald", "value": -226.94126340710596},
    "one_electron": {"name": "one_electron", "value": 67.51131139381918},
    "hartree": {"name": "hartree", "value": 16.23523866536874},
    "exchange_correlation": {
        "name": "exchange_correlation",
        "value": -117.33895323280238,
    },
    "smearing": {"name": "smearing", "value": -0.0},
}

CONVERGENCE_ELECTRONIC = [
    [
        1.40182131e00,
        5.93994699e-01,
        7.00312479e-03,
        1.01988311e-03,
        4.20416063e-05,
        7.61919078e-06,
    ]
]

IBZ_KPOINTS = [
    [0.00000000e00, 0.00000000e00, 0.00000000e00],
    [2.77555756e-17, 2.77555756e-17, 3.33333333e-01],
    [0.00000000e00, 3.33333333e-01, 0.00000000e00],
    [2.77555756e-17, 3.33333333e-01, 3.33333333e-01],
    [-8.32667268e-17, 3.33333333e-01, -3.33333333e-01],
    [3.33333333e-01, -1.38777878e-17, 0.00000000e00],
    [3.33333333e-01, 2.77555756e-17, -3.33333333e-01],
    [3.33333333e-01, 3.33333333e-01, 0.00000000e00],
    [3.33333333e-01, 3.33333333e-01, -3.33333333e-01],
    [3.33333333e-01, -3.33333333e-01, 0.00000000e00],
]

CONVERGENCE_ELECTRONIC = [
    [
        0.959930554089618,
        0.4053863927153305,
        0.005113293357628257,
        9.020577659803987e-05,
        7.347076826989673e-06,
    ]
]

CONVERGENCE_IONIC = [
    {
        "energy": -260.5336665807204,
        "electronic": {
            "units": "eV",
            "data": [0.07055357, 0.02979534, 0.00037582, 6.63e-06, 5.4e-07],
        },
        "structure": {
            "lattice": {
                "vectors": {
                    "a": [3.348920530934846, 0.0, 1.9335001702807129],
                    "b": [1.1163075183116746, 3.1573923180672185, 1.9335001702807129],
                    "c": [0.0, 0.0, 3.8670003405614257],
                    "alat": 1,
                }
            },
            "basis": {
                "units": "angstrom",
                "elements": [{"id": 0, "value": "Si"}, {"id": 1, "value": "Si"}],
                "coordinates": [
                    {"id": 0, "value": [0.0, 0.0, 0.0]},
                    {
                        "id": 1,
                        "value": [
                            1.116311538382614,
                            0.7893511049510541,
                            1.9335078634787712,
                        ],
                    },
                ],
            },
        },
    }
]

FINAL_BASIS = {
    "units": "angstrom",
    "elements": [
        {"id": 1, "value": "Si"},
        {"id": 2, "value": "Si"},
    ],
    "coordinates": [
        {"id": 1, "value": [0.0, 0.0, 0.0]},
        {
            "id": 2,
            "value": [1.1163069009780884, 0.7893480658531189, 1.9335001707077026],
        },
    ],
}

DOS = {
    "energy": [
        -6.005000114440918,
        -5.954999923706055,
        -5.90500020980835,
        -5.855000019073486,
        -5.804999828338623,
        -5.755000114440918,
        -5.704999923706055,
        -5.65500020980835,
        -5.605000019073486,
        -5.554999828338623,
        -5.505000114440918,
        -5.454999923706055,
        -5.40500020980835,
        -5.355000019073486,
        -5.304999828338623,
        -5.255000114440918,
        -5.204999923706055,
        -5.15500020980835,
        -5.105000019073486,
        -5.054999828338623,
        -5.005000114440918,
        -4.954999923706055,
        -4.90500020980835,
        -4.855000019073486,
        -4.804999828338623,
        -4.755000114440918,
        -4.704999923706055,
        -4.65500020980835,
        -4.605000019073486,
        -4.554999828338623,
        -4.505000114440918,
        -4.454999923706055,
        -4.40500020980835,
        -4.355000019073486,
        -4.304999828338623,
        -4.255000114440918,
        -4.204999923706055,
        -4.15500020980835,
        -4.105000019073486,
        -4.054999828338623,
        -4.005000114440918,
        -3.9549999237060547,
        -3.9049999713897705,
        -3.8550000190734863,
        -3.805000066757202,
        -3.755000114440918,
        -3.7049999237060547,
        -3.6549999713897705,
        -3.6050000190734863,
        -3.555000066757202,
        -3.505000114440918,
        -3.4549999237060547,
        -3.4049999713897705,
        -3.3550000190734863,
        -3.305000066757202,
        -3.255000114440918,
        -3.2049999237060547,
        -3.1549999713897705,
        -3.1050000190734863,
        -3.055000066757202,
        -3.005000114440918,
        -2.9549999237060547,
        -2.9049999713897705,
        -2.8550000190734863,
        -2.805000066757202,
        -2.755000114440918,
        -2.7049999237060547,
        -2.6549999713897705,
        -2.6050000190734863,
        -2.555000066757202,
        -2.505000114440918,
        -2.4549999237060547,
        -2.4049999713897705,
        -2.3550000190734863,
        -2.305000066757202,
        -2.255000114440918,
        -2.2049999237060547,
        -2.1549999713897705,
        -2.1050000190734863,
        -2.055000066757202,
        -2.005000114440918,
        -1.9550000429153442,
        -1.9049999713897705,
        -1.8550000190734863,
        -1.8049999475479126,
        -1.7549999952316284,
        -1.7050000429153442,
        -1.6549999713897705,
        -1.6050000190734863,
        -1.5549999475479126,
        -1.5049999952316284,
        -1.4550000429153442,
        -1.4049999713897705,
        -1.3550000190734863,
        -1.3049999475479126,
        -1.2549999952316284,
        -1.2050000429153442,
        -1.1549999713897705,
        -1.1050000190734863,
        -1.0549999475479126,
        -1.0049999952316284,
        -0.9549999833106995,
        -0.9049999713897705,
        -0.8550000190734863,
        -0.8050000071525574,
        -0.7549999952316284,
        -0.7049999833106995,
        -0.6549999713897705,
        -0.6050000190734863,
        -0.5550000071525574,
        -0.5049999952316284,
        -0.45500001311302185,
        -0.4050000011920929,
        -0.35499998927116394,
        -0.3050000071525574,
        -0.2549999952316284,
        -0.20499999821186066,
        -0.1550000011920929,
        -0.10499999672174454,
        -0.054999999701976776,
        -0.004999999888241291,
        0.04500000178813934,
        0.0949999988079071,
        0.14499999582767487,
        0.19499999284744263,
        0.24500000476837158,
        0.29499998688697815,
        0.3449999988079071,
        0.39500001072883606,
        0.4449999928474426,
        0.4950000047683716,
        0.5450000166893005,
        0.5950000286102295,
        0.6449999809265137,
        0.6949999928474426,
        0.7450000047683716,
        0.7950000166893005,
        0.8450000286102295,
        0.8949999809265137,
        0.9449999928474426,
        0.9950000047683716,
        1.0449999570846558,
        1.0950000286102295,
        1.1449999809265137,
        1.1950000524520874,
        1.2450000047683716,
        1.2949999570846558,
        1.3450000286102295,
        1.3949999809265137,
        1.4450000524520874,
        1.4950000047683716,
        1.5449999570846558,
        1.5950000286102295,
        1.6449999809265137,
        1.6950000524520874,
        1.7450000047683716,
        1.7949999570846558,
        1.8450000286102295,
        1.8949999809265137,
        1.9450000524520874,
        1.9950000047683716,
        2.0450000762939453,
        2.0950000286102295,
        2.1449999809265137,
        2.194999933242798,
        2.244999885559082,
        2.2950000762939453,
        2.3450000286102295,
        2.3949999809265137,
        2.444999933242798,
        2.494999885559082,
        2.5450000762939453,
        2.5950000286102295,
        2.6449999809265137,
        2.694999933242798,
        2.744999885559082,
        2.7950000762939453,
        2.8450000286102295,
        2.8949999809265137,
        2.944999933242798,
        2.994999885559082,
        3.0450000762939453,
        3.0950000286102295,
        3.1449999809265137,
        3.194999933242798,
        3.244999885559082,
        3.2950000762939453,
        3.3450000286102295,
        3.3949999809265137,
        3.444999933242798,
        3.494999885559082,
        3.5450000762939453,
        3.5950000286102295,
        3.6449999809265137,
        3.694999933242798,
        3.744999885559082,
        3.7950000762939453,
        3.8450000286102295,
        3.8949999809265137,
        3.944999933242798,
        3.994999885559082,
        4.045000076293945,
        4.09499979019165,
        4.144999980926514,
        4.195000171661377,
        4.244999885559082,
        4.295000076293945,
        4.34499979019165,
        4.394999980926514,
        4.445000171661377,
        4.494999885559082,
        4.545000076293945,
        4.59499979019165,
        4.644999980926514,
        4.695000171661377,
        4.744999885559082,
        4.795000076293945,
        4.84499979019165,
        4.894999980926514,
        4.945000171661377,
        4.994999885559082,
        5.045000076293945,
        5.09499979019165,
        5.144999980926514,
        5.195000171661377,
        5.244999885559082,
        5.295000076293945,
        5.34499979019165,
        5.394999980926514,
        5.445000171661377,
        5.494999885559082,
        5.545000076293945,
        5.59499979019165,
        5.644999980926514,
        5.695000171661377,
        5.744999885559082,
        5.795000076293945,
        5.84499979019165,
        5.894999980926514,
        5.945000171661377,
        5.994999885559082,
        6.045000076293945,
        6.09499979019165,
        6.144999980926514,
        6.195000171661377,
        6.244999885559082,
        6.295000076293945,
        6.34499979019165,
        6.394999980926514,
        6.445000171661377,
        6.494999885559082,
        6.545000076293945,
        6.59499979019165,
        6.644999980926514,
        6.695000171661377,
        6.744999885559082,
        6.795000076293945,
        6.84499979019165,
        6.894999980926514,
        6.945000171661377,
        6.994999885559082,
        7.045000076293945,
        7.09499979019165,
        7.144999980926514,
        7.195000171661377,
        7.244999885559082,
        7.295000076293945,
        7.34499979019165,
        7.394999980926514,
        7.445000171661377,
        7.494999885559082,
        7.545000076293945,
        7.59499979019165,
        7.644999980926514,
        7.695000171661377,
        7.744999885559082,
        7.795000076293945,
        7.84499979019165,
        7.894999980926514,
        7.945000171661377,
        7.994999885559082,
        8.045000076293945,
        8.095000267028809,
        8.145000457763672,
        8.194999694824219,
        8.244999885559082,
        8.295000076293945,
        8.345000267028809,
        8.395000457763672,
        8.444999694824219,
        8.494999885559082,
        8.545000076293945,
        8.595000267028809,
        8.645000457763672,
        8.694999694824219,
        8.744999885559082,
        8.795000076293945,
        8.845000267028809,
        8.895000457763672,
        8.944999694824219,
        8.994999885559082,
        9.045000076293945,
        9.095000267028809,
        9.145000457763672,
        9.194999694824219,
        9.244999885559082,
        9.295000076293945,
        9.345000267028809,
        9.395000457763672,
        9.444999694824219,
        9.494999885559082,
        9.545000076293945,
        9.595000267028809,
        9.645000457763672,
        9.694999694824219,
        9.744999885559082,
        9.795000076293945,
        9.845000267028809,
        9.895000457763672,
        9.944999694824219,
        9.994999885559082,
        10.045000076293945,
        10.095000267028809,
        10.145000457763672,
        10.194999694824219,
        10.244999885559082,
        10.295000076293945,
        10.345000267028809,
        10.395000457763672,
        10.444999694824219,
        10.494999885559082,
        10.545000076293945,
        10.595000267028809,
        10.645000457763672,
        10.694999694824219,
        10.744999885559082,
        10.795000076293945,
        10.845000267028809,
        10.895000457763672,
        10.944999694824219,
        10.994999885559082,
        11.045000076293945,
        11.095000267028809,
        11.145000457763672,
        11.194999694824219,
        11.244999885559082,
        11.295000076293945,
        11.345000267028809,
        11.395000457763672,
        11.444999694824219,
        11.494999885559082,
        11.545000076293945,
        11.595000267028809,
        11.645000457763672,
        11.694999694824219,
        11.744999885559082,
        11.795000076293945,
        11.845000267028809,
        11.895000457763672,
        11.944999694824219,
        11.994999885559082,
        12.045000076293945,
        12.095000267028809,
        12.145000457763672,
        12.194999694824219,
        12.244999885559082,
        12.295000076293945,
        12.345000267028809,
        12.395000457763672,
        12.444999694824219,
        12.494999885559082,
        12.545000076293945,
        12.595000267028809,
        12.645000457763672,
        12.694999694824219,
        12.744999885559082,
        12.795000076293945,
        12.845000267028809,
        12.895000457763672,
        12.944999694824219,
        12.994999885559082,
        13.045000076293945,
        13.095000267028809,
        13.145000457763672,
        13.194999694824219,
        13.244999885559082,
        13.295000076293945,
        13.345000267028809,
        13.395000457763672,
        13.444999694824219,
        13.494999885559082,
        13.545000076293945,
        13.595000267028809,
        13.645000457763672,
        13.694999694824219,
        13.744999885559082,
        13.795000076293945,
        13.845000267028809,
        13.895000457763672,
        13.944999694824219,
        13.994999885559082,
        14.045000076293945,
        14.095000267028809,
        14.145000457763672,
        14.194999694824219,
        14.244999885559082,
        14.295000076293945,
        14.345000267028809,
        14.395000457763672,
        14.444999694824219,
        14.494999885559082,
        14.545000076293945,
        14.595000267028809,
        14.645000457763672,
        14.694999694824219,
        14.744999885559082,
        14.795000076293945,
        14.845000267028809,
        14.895000457763672,
        14.944999694824219,
        14.994999885559082,
        15.045000076293945,
        15.095000267028809,
        15.145000457763672,
        15.194999694824219,
        15.244999885559082,
        15.295000076293945,
        15.345000267028809,
        15.395000457763672,
        15.444999694824219,
        15.494999885559082,
        15.545000076293945,
        15.595000267028809,
        15.645000457763672,
        15.694999694824219,
        15.744999885559082,
        15.795000076293945,
        15.845000267028809,
        15.895000457763672,
        15.944999694824219,
        15.994999885559082,
        16.045000076293945,
        16.094999313354492,
        16.145000457763672,
        16.19499969482422,
        16.2450008392334,
        16.295000076293945,
        16.344999313354492,
        16.395000457763672,
        16.44499969482422,
        16.4950008392334,
        16.545000076293945,
        16.594999313354492,
    ],
    "total": [
        0.00012799999967683107,
        0.0010100000072270632,
        0.006130000110715628,
        0.028300000354647636,
        0.0997999981045723,
        0.2680000066757202,
        0.5509999990463257,
        0.8629999756813049,
        1.0299999713897705,
        0.9430000185966492,
        0.6570000052452087,
        0.3499999940395355,
        0.1420000046491623,
        0.04399999976158142,
        0.010400000028312206,
        0.001879999996162951,
        0.0002589999930933118,
        2.7300000510876998e-05,
        2.190000031987438e-06,
        1.3400000398178236e-07,
        6.28000007552032e-09,
        2.2399999910494017e-10,
        6.119999906156748e-12,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        9.089999586375797e-12,
        3.5799999076324696e-10,
        1.0800000005417587e-08,
        2.4700000267330324e-07,
        4.319999789004214e-06,
        5.779999992228113e-05,
        0.000590000010561198,
        0.0045900000259280205,
        0.027300000190734863,
        0.12399999797344208,
        0.42899999022483826,
        1.1299999952316284,
        2.2899999618530273,
        3.5199999809265137,
        4.139999866485596,
        3.7200000286102295,
        2.549999952316284,
        1.3300000429153442,
        0.531000018119812,
        0.16200000047683716,
        0.03759999945759773,
        0.006680000107735395,
        0.0009040000149980187,
        9.349999891128391e-05,
        7.380000170087442e-06,
        4.4500001195046934e-07,
        2.039999991154673e-08,
        7.179999927942049e-10,
        1.9199999229391196e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        2.589999915925123e-11,
        9.749999696495593e-10,
        2.800000054037355e-08,
        6.139999868537416e-07,
        1.0300000212737359e-05,
        0.00013099999341648072,
        0.0012799999676644802,
        0.009499999694526196,
        0.05389999970793724,
        0.23399999737739563,
        0.7730000019073486,
        1.9500000476837158,
        3.759999990463257,
        5.539999961853027,
        6.21999979019165,
        5.329999923706055,
        3.490000009536743,
        1.7400000095367432,
        0.6639999747276306,
        0.19300000369548798,
        0.042899999767541885,
        0.007280000019818544,
        0.0010499999625608325,
        0.0011099999537691474,
        0.007430000230669975,
        0.041200000792741776,
        0.17399999499320984,
        0.5640000104904175,
        1.3899999856948853,
        2.619999885559082,
        3.7699999809265137,
        4.130000114440918,
        3.4600000381469727,
        2.2100000381469727,
        1.0800000429153442,
        0.4020000100135803,
        0.11400000005960464,
        0.024800000712275505,
        0.004110000096261501,
        0.0005200000014156103,
        5.020000025979243e-05,
        3.6999999792897142e-06,
        2.0800000299914245e-07,
        8.91999984986569e-09,
        2.9200000750684296e-10,
        7.309999827675995e-12,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        5.160000031423362e-12,
        2.1800000693517063e-10,
        7.000000135093387e-09,
        1.720000000204891e-07,
        3.220000053261174e-06,
        4.610000178217888e-05,
        0.0005039999959990382,
        0.00419999985024333,
        0.02669999934732914,
        0.12999999523162842,
        0.4819999933242798,
        1.3600000143051147,
        2.950000047683716,
        4.860000133514404,
        6.119999885559082,
        5.880000114440918,
        4.309999942779541,
        2.4100000858306885,
        1.0299999713897705,
        0.335999995470047,
        0.08370000123977661,
        0.01590000092983246,
        0.002309999894350767,
        0.00025499999173916876,
        2.1600000764010474e-05,
        1.3899999657951412e-06,
        6.860000212327577e-08,
        2.5799999914255523e-09,
        7.389999723272922e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        6.679999869224629e-12,
        2.8200000667943925e-10,
        9.099999864758956e-09,
        2.240000043229884e-07,
        4.2100000428035855e-06,
        6.030000076862052e-05,
        0.000661000027321279,
        0.005520000122487545,
        0.03519999980926514,
        0.17100000381469727,
        0.6370000243186951,
        1.809999942779541,
        3.9100000858306885,
        6.460000038146973,
        8.149999618530273,
        7.849999904632568,
        5.769999980926514,
        3.2300000190734863,
        1.3899999856948853,
        0.453000009059906,
        0.11299999803304672,
        0.0215000007301569,
        0.0031300000846385956,
        0.00034699999378062785,
        2.9400000130408444e-05,
        1.9000000293090125e-06,
        9.549999901992123e-08,
        5.240000078288176e-08,
        9.619999445931171e-07,
        1.4500000361294951e-05,
        0.00016599999798927456,
        0.001449999981559813,
        0.009730000048875809,
        0.04969999939203262,
        0.19300000369548798,
        0.574999988079071,
        1.309999942779541,
        2.259999990463257,
        2.990000009536743,
        3.0199999809265137,
        2.3299999237060547,
        1.3700000047683716,
        0.6150000095367432,
        0.210999995470047,
        0.05790000036358833,
        0.03009999915957451,
        0.09960000216960907,
        0.382999986410141,
        1.1399999856948853,
        2.5899999141693115,
        4.510000228881836,
        5.980000019073486,
        6.050000190734863,
        4.670000076293945,
        2.759999990463257,
        1.2400000095367432,
        0.4259999990463257,
        0.1120000034570694,
        0.02239999920129776,
        0.0040699997916817665,
        0.005400000140070915,
        0.029400000348687172,
        0.13199999928474426,
        0.45100000500679016,
        1.1799999475479126,
        2.3499999046325684,
        3.569999933242798,
        4.150000095367432,
        3.6700000762939453,
        2.490000009536743,
        1.2799999713897705,
        0.5059999823570251,
        0.15199999511241913,
        0.03500000014901161,
        0.006140000186860561,
        0.0008210000232793391,
        8.399999933317304e-05,
        8.140000318235252e-06,
        2.3299999156733975e-05,
        0.0002500000118743628,
        0.002090000081807375,
        0.013299999758601189,
        0.06469999998807907,
        0.23999999463558197,
        0.6800000071525574,
        1.4700000286102295,
        2.430000066757202,
        3.059999942779541,
        2.940000057220459,
        2.1600000858306885,
        1.2100000381469727,
        0.5170000195503235,
        0.16899999976158142,
        0.042100001126527786,
        0.008700000122189522,
        0.006310000084340572,
        0.02979999966919422,
        0.13600000739097595,
        0.49399998784065247,
        1.4299999475479126,
        3.2699999809265137,
        5.880000114440918,
        8.279999732971191,
        9.050000190734863,
        7.650000095367432,
        4.980000019073486,
        2.490000009536743,
        0.9549999833106995,
        0.2800000011920929,
        0.06289999932050705,
        0.01080000028014183,
        0.0014199999859556556,
        0.00014200000441633165,
        1.0800000382005237e-05,
        6.32000023870205e-07,
        2.8200000556921623e-08,
        9.57000034773614e-10,
        2.490000046428964e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        8.83000009915813e-12,
        3.4799998993584325e-10,
        1.0499999980595476e-08,
        2.410000092822884e-07,
        4.229999831295572e-06,
        5.669999882229604e-05,
        0.0005789999850094318,
        0.004519999958574772,
        0.026900000870227814,
        0.12200000137090683,
        0.42500001192092896,
        1.1299999952316284,
        2.2799999713897705,
        3.509999990463257,
        4.139999866485596,
        3.7200000286102295,
        2.559999942779541,
        1.340000033378601,
        0.5350000262260437,
        0.16300000250339508,
        0.038100000470876694,
        0.006769999861717224,
        0.0009200000204145908,
        9.529999806545675e-05,
        7.539999842265388e-06,
        4.54999991461591e-07,
        2.099999996119095e-08,
        7.379999944490123e-10,
        1.9800000181091626e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.329999999022391e-11,
        5.229999766598326e-10,
        1.5799999530941022e-08,
        3.6200000863573223e-07,
        6.350000148813706e-06,
        8.510000043315813e-05,
        0.0008699999889358878,
        0.0067900000140070915,
        0.04039999842643738,
        0.18400000035762787,
        0.6380000114440918,
        1.690000057220459,
        3.4200000762939453,
        5.269999980926514,
        6.210000038146973,
        5.579999923706055,
        3.8299999237060547,
        2.009999990463257,
        0.8029999732971191,
        0.24500000476837158,
        0.057100001722574234,
        0.010200000368058681,
        0.0013800000306218863,
        0.0001429999974789098,
    ],
    "partial": [
        [
            0.00012759999663103372,
            0.0010100000072270632,
            0.006120000034570694,
            0.028200000524520874,
            0.09939999878406525,
            0.2680000066757202,
            0.550000011920929,
            0.8600000143051147,
            1.0299999713897705,
            0.9399999976158142,
            0.656000018119812,
            0.3479999899864197,
            0.14159999787807465,
            0.043800000101327896,
            0.010379999876022339,
            0.0018739999504759908,
            0.0002579999854788184,
            2.719999974942766e-05,
            2.179999910367769e-06,
            1.338000004125206e-07,
            6.260000073865513e-09,
            2.2399999910494017e-10,
            6.099999845521342e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            7.020000032664786e-12,
            2.760000006318819e-10,
            8.29999979856666e-09,
            1.9040000154291192e-07,
            3.3399999210814713e-06,
            4.4600001274375245e-05,
            0.00045399999362416565,
            0.003539999946951866,
            0.020999999716877937,
            0.09560000151395798,
            0.33000001311302185,
            0.8740000128746033,
            1.7640000581741333,
            2.7200000286102295,
            3.200000047683716,
            2.859999895095825,
            1.9639999866485596,
            1.0260000228881836,
            0.4099999964237213,
            0.12479999661445618,
            0.028999999165534973,
            0.005160000175237656,
            0.0006980000180192292,
            7.219999679364264e-05,
            5.700000201613875e-06,
            3.440000000409782e-07,
            1.5779999529286215e-08,
            5.540000125314748e-10,
            1.484000075602232e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.456000077448838e-11,
            5.479999787283418e-10,
            1.5719999524321793e-08,
            3.440000000409782e-07,
            5.760000021837186e-06,
            7.360000017797574e-05,
            0.0007159999804571271,
            0.0053400001488626,
            0.03020000085234642,
            0.13120000064373016,
            0.4339999854564667,
            1.0959999561309814,
            2.119999885559082,
            3.0999999046325684,
            3.5,
            3.0,
            1.9579999446868896,
            0.9779999852180481,
            0.3720000088214874,
            0.10840000212192535,
            0.024000000208616257,
            0.0040799998678267,
            0.0005540000274777412,
            0.00029399999766610563,
            0.0017679999582469463,
            0.00977999996393919,
            0.0414000004529953,
            0.1340000033378601,
            0.33000001311302185,
            0.621999979019165,
            0.8939999938011169,
            0.9819999933242798,
            0.8220000267028809,
            0.5260000228881836,
            0.25600001215934753,
            0.09560000151395798,
            0.0272000003606081,
            0.005900000222027302,
            0.0009759999811649323,
            0.0001235999952768907,
            1.1920000360987615e-05,
            8.779999802754901e-07,
            4.940000053466065e-08,
            2.1199999533649816e-09,
            6.939999963595511e-11,
            1.7360000156146915e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            7.720000288910895e-24,
            3.2599998763507643e-22,
            1.0460000152733506e-20,
            2.580000111995504e-19,
            4.820000040910275e-18,
            6.899999871504985e-17,
            7.539999834651307e-16,
            6.2800001032487906e-15,
            3.99999992980668e-14,
            1.9439999740175629e-13,
            7.200000144702567e-13,
            2.039999896438771e-12,
            4.399999895682294e-12,
            7.259999892927915e-12,
            9.140000388485614e-12,
            8.780000164410051e-12,
            6.4400000089614995e-12,
            3.6000000723512837e-12,
            1.5420000346044738e-12,
            5.020000257496826e-13,
            1.2519999414376676e-13,
            2.379999951458711e-14,
            3.459999993492887e-15,
            3.820000007504279e-16,
            3.220000050326408e-17,
            2.0800000373898635e-18,
            1.0259999997521688e-19,
            3.859999958284274e-21,
            1.1060000285154113e-22,
            0.0,
            0.0,
            0.0,
            0.0,
            8.5999998722339e-24,
            3.640000106629733e-22,
            1.1719999789630638e-20,
            2.879999908604705e-19,
            5.420000047718982e-18,
            7.780000267508709e-17,
            8.499999977894137e-16,
            7.119999712425565e-15,
            4.540000035527063e-14,
            2.20000002915631e-13,
            8.19999992386633e-13,
            2.320000094813146e-12,
            5.040000101291797e-12,
            8.32000007083833e-12,
            1.0500000174884505e-11,
            1.0120000323854406e-11,
            7.440000004965697e-12,
            4.160000035419165e-12,
            1.7840000310354043e-12,
            5.840000249883459e-13,
            1.456000034080751e-13,
            2.7800000799646507e-14,
            4.0200001564605434e-15,
            4.460000102999499e-16,
            3.7800000015358277e-17,
            2.4400000001160574e-18,
            1.2219999935322112e-19,
            4.339999862272368e-20,
            7.639999886795563e-19,
            1.1500000061568513e-17,
            1.3199999984355446e-16,
            1.1559999673474495e-15,
            7.739999877728453e-15,
            3.9399998427681535e-14,
            1.53800000621436e-13,
            4.580000116140293e-13,
            1.0379999811072071e-12,
            1.8000000361756419e-12,
            3.9400000623190934e-11,
            1.2580000374740052e-09,
            3.2599999144622416e-08,
            6.419999749596172e-07,
            9.68000040302286e-06,
            0.00011139999696752056,
            0.000977999996393919,
            0.006560000125318766,
            0.03359999880194664,
            0.13099999725818634,
            0.38999998569488525,
            0.8899999856948853,
            1.5460000038146973,
            2.0399999618530273,
            2.0799999237060547,
            1.6019999980926514,
            0.9440000057220459,
            0.4259999990463257,
            0.1459999978542328,
            0.03840000182390213,
            0.007720000110566616,
            0.0016159999649971724,
            0.0035600000992417336,
            0.02019999921321869,
            0.09019999951124191,
            0.30799999833106995,
            0.8059999942779541,
            1.6059999465942383,
            2.440000057220459,
            2.8399999141693115,
            2.5199999809265137,
            1.7020000219345093,
            0.878000020980835,
            0.34599998593330383,
            0.10419999808073044,
            0.024000000208616257,
            0.00419999985024333,
            0.0005619999719783664,
            5.740000051446259e-05,
            4.479999915929511e-06,
            2.660000006926566e-07,
            1.210000011298007e-08,
            4.200000069953802e-10,
            1.2279999933584307e-11,
            5.6799998732204315e-12,
            2.100000034976901e-11,
            5.979999828653604e-11,
            1.2900000512239274e-10,
            2.1399999827753646e-10,
            2.680000110721892e-10,
            2.8200000667943925e-10,
            9.659999467004354e-10,
            1.9799999861902506e-08,
            3.8199999607968493e-07,
            5.639999926643213e-06,
            6.359999679261819e-05,
            0.0005460000247694552,
            0.003599999938160181,
            0.01802000030875206,
            0.0689999982714653,
            0.20200000703334808,
            0.44999998807907104,
            0.765999972820282,
            0.9940000176429749,
            0.9860000014305115,
            0.7459999918937683,
            0.4320000112056732,
            0.19040000438690186,
            0.06419999897480011,
            0.01648000068962574,
            0.0032399999909102917,
            0.0004839999892283231,
            5.539999983739108e-05,
            4.819999958272092e-06,
            3.220000053261174e-07,
            1.6339999575620823e-08,
            6.340000191507045e-10,
            1.8780000124452023e-11,
            3.959999955110826e-21,
            1.0279999865620544e-22,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.339999988822423e-13,
            1.320000012072775e-11,
            3.979999940728618e-10,
            9.139999868068571e-09,
            1.6040000616612815e-07,
            2.1400001060101204e-06,
            2.2000000171829015e-05,
            0.00017139999545179307,
            0.0010219999821856618,
            0.004639999940991402,
            0.016119999811053276,
            0.04280000180006027,
            0.08640000224113464,
            0.133200004696846,
            0.15700000524520874,
            0.1412000060081482,
            0.09700000286102295,
            0.05079999938607216,
            0.020400000736117363,
            0.006200000178068876,
            0.0014440000522881746,
            0.00025599999935366213,
            3.479999941191636e-05,
            3.6199999158270657e-06,
            2.859999881366093e-07,
            1.7259999651741964e-08,
            7.959999881457236e-10,
            2.799999988811752e-11,
            7.499999970031479e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.5199998161704835e-22,
            1.786000072569194e-20,
            5.379999764645026e-19,
            1.2359999892105194e-17,
            2.1799999613211242e-16,
            2.9000000422834673e-15,
            2.9800001442176205e-14,
            2.31999993218282e-13,
            1.381999983202098e-12,
            6.279999957559124e-12,
            2.1799999305738282e-11,
            5.780000089661286e-11,
            1.165999935492934e-10,
            1.8019999381557739e-10,
            2.1200000088761328e-10,
            1.9080000079885195e-10,
            1.3100000251231592e-10,
            6.860000067998584e-11,
            2.7400000671140567e-11,
            8.379999819063677e-12,
            1.950000057260315e-12,
            3.460000027374205e-13,
            4.7000001546920744e-14,
            4.879999907587886e-15,
        ],
        [
            1.1699999925974646e-17,
            9.280000325889509e-17,
            5.620000077561239e-16,
            2.6000000306073074e-15,
            9.120000354955263e-15,
            2.460000011041217e-14,
            5.0399998573463084e-14,
            7.899999827486875e-14,
            9.460000057609497e-14,
            8.620000194322838e-14,
            6.020000036660589e-14,
            3.20000001160798e-14,
            1.29999999412783e-14,
            4.0200001564605434e-15,
            9.520000229351318e-16,
            1.7200000581200572e-16,
            2.379999958076156e-17,
            2.4999999594378976e-18,
            1.999999936531045e-19,
            1.228000025653547e-20,
            5.739999838038939e-22,
            2.0599999712301224e-23,
            5.599999813609456e-25,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-08,
            3.2599999144622416e-07,
            4.340000032243552e-06,
            4.439999975147657e-05,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.1720000058412552,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.002839999971911311,
            0.0005019999807700515,
            6.800000119255856e-05,
            7.040000127744861e-06,
            5.559999749493727e-07,
            3.339999921081471e-08,
            1.5379999496190067e-09,
            5.399999891686491e-11,
            1.4480000315106323e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.4039999718384877e-10,
            4.039999890181889e-09,
            8.840000020882144e-08,
            1.4779999446545844e-06,
            1.8880000425269827e-05,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010499999625608325,
            0.00016239999968092889,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006200000178068876,
            0.001028000027872622,
            0.00013000000035390258,
            1.2540000170702115e-05,
            9.240000053978292e-07,
            5.200000074978561e-08,
            2.239999963293826e-09,
            7.300000187671074e-11,
            1.827999990960949e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-09,
            5.700000116348747e-08,
            1.0700000530050602e-06,
            1.531999987491872e-05,
            0.00016739999409765005,
            0.0013960000360384583,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            8.479999814881012e-05,
            7.160000222938834e-06,
            4.620000026989146e-07,
            2.280000011012362e-08,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-09,
            7.38000025535257e-08,
            1.3879999869459425e-06,
            1.990000055229757e-05,
            0.00021800000104121864,
            0.001820000004954636,
            0.011599999852478504,
            0.05660000070929527,
            0.20999999344348907,
            0.5960000157356262,
            1.2899999618530273,
            2.140000104904175,
            2.680000066757202,
            2.5799999237060547,
            1.899999976158142,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.007079999893903732,
            0.0010300000431016088,
            0.00011419999646022916,
            9.68000040302286e-06,
            6.259999736357713e-07,
            3.139999904533397e-08,
            1.6839999616991008e-08,
            3.0800001127317955e-07,
            4.640000042854808e-06,
            5.32000012753997e-05,
            0.0004659999976865947,
            0.003120000008493662,
            0.01592000015079975,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            6.55999974696897e-05,
            6.719999873894267e-06,
            1.035999957821332e-06,
            7.3999999585794285e-06,
            8.060000254772604e-05,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.38999998569488525,
            0.1664000004529953,
            0.05420000106096268,
            0.013539999723434448,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016820000484585762,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.8420000076293945,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            3.600000127335079e-05,
            2.7599999157246202e-06,
            1.6120000623232045e-07,
            7.180000149986654e-09,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.593999932048007e-11,
            4.799999842042268e-10,
            1.1040000025275276e-08,
            1.936000018076811e-07,
            2.6000000161729986e-06,
            2.660000063769985e-05,
            0.00020599999697878957,
            0.0012339999666437507,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.061400000005960464,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            4.220000118948519e-05,
            4.359999820735538e-06,
            3.460000073118863e-07,
            2.0799999944642877e-08,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.059999929103557e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6119999779462546e-10,
            4.859999958028993e-09,
            1.1160000212839805e-07,
            1.959999963219161e-06,
            2.6199999410891905e-05,
            0.0002680000034160912,
            0.002099999925121665,
            0.01245999988168478,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.00042600001324899495,
            4.400000034365803e-05,
        ],
        [
            2.579999888656739e-16,
            2.0400000793978877e-15,
            1.2359999634024843e-14,
            5.719999940281134e-14,
            2.019999971328637e-13,
            5.419999843901679e-13,
            1.1120000319858603e-12,
            1.7419999904372263e-12,
            2.0800000177095823e-12,
            1.902000041839602e-12,
            1.3259999652112664e-12,
            7.059999828674945e-13,
            2.8600001056658386e-13,
            8.880000006801156e-14,
            2.099999997029825e-14,
            3.79999986555371e-15,
            5.219999885527828e-16,
            5.499999993481436e-17,
            4.419999898507701e-18,
            2.699999978940396e-19,
            1.268000024384168e-20,
            4.5199998161704835e-22,
            1.2339999679078485e-23,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-08,
            3.2599999144622416e-07,
            4.340000032243552e-06,
            4.439999975147657e-05,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.17219999432563782,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.0028200000524520874,
            0.0005019999807700515,
            6.800000119255856e-05,
            7.040000127744861e-06,
            5.559999749493727e-07,
            3.339999921081471e-08,
            1.5379999496190067e-09,
            5.399999891686491e-11,
            1.4460000037630483e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.4039999718384877e-10,
            4.039999890181889e-09,
            8.840000020882144e-08,
            1.4779999446545844e-06,
            1.8880000425269827e-05,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010499999625608325,
            0.0001621999981580302,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006219999864697456,
            0.001028000027872622,
            0.00013000000035390258,
            1.2559999959194101e-05,
            9.259999842470279e-07,
            5.200000074978561e-08,
            2.239999963293826e-09,
            7.320000161570306e-11,
            1.8299999102883158e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-09,
            5.700000116348747e-08,
            1.0700000530050602e-06,
            1.531999987491872e-05,
            0.0001672000071266666,
            0.0013940000208094716,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            8.479999814881012e-05,
            7.160000222938834e-06,
            4.620000026989146e-07,
            2.280000011012362e-08,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-09,
            7.38000025535257e-08,
            1.3860000080967438e-06,
            1.9880000763805583e-05,
            0.00021800000104121864,
            0.0018179999897256494,
            0.011599999852478504,
            0.05640000104904175,
            0.20999999344348907,
            0.5960000157356262,
            1.2879999876022339,
            2.119999885559082,
            2.680000066757202,
            2.5799999237060547,
            1.9019999504089355,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.0071000000461936,
            0.0010300000431016088,
            0.00011439999798312783,
            9.68000040302286e-06,
            6.259999736357713e-07,
            3.139999904533397e-08,
            1.6799999613681393e-08,
            3.0800001127317955e-07,
            4.640000042854808e-06,
            5.32000012753997e-05,
            0.0004659999976865947,
            0.003120000008493662,
            0.01590000092983246,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            6.540000322274864e-05,
            6.719999873894267e-06,
            1.035999957821332e-06,
            7.3999999585794285e-06,
            8.060000254772604e-05,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.3880000114440918,
            0.1664000004529953,
            0.05420000106096268,
            0.01351999957114458,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016839999705553055,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.840000033378601,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            3.600000127335079e-05,
            2.7599999157246202e-06,
            1.6120000623232045e-07,
            7.180000149986654e-09,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.593999932048007e-11,
            4.799999842042268e-10,
            1.1040000025275276e-08,
            1.9380000537694286e-07,
            2.6000000161729986e-06,
            2.660000063769985e-05,
            0.00020799999765586108,
            0.0012339999666437507,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.06120000034570694,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            4.199999966658652e-05,
            4.359999820735538e-06,
            3.440000000409782e-07,
            2.0799999944642877e-08,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.059999929103557e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6140000447251168e-10,
            4.859999958028993e-09,
            1.1160000212839805e-07,
            1.959999963219161e-06,
            2.6199999410891905e-05,
            0.0002680000034160912,
            0.002099999925121665,
            0.01245999988168478,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.00042600001324899495,
            4.400000034365803e-05,
        ],
        [
            5.4399999514415345e-17,
            4.320000115197144e-16,
            2.6000000306073074e-15,
            1.2039999903914588e-14,
            4.239999939147608e-14,
            1.1420000416238058e-13,
            2.339999938608117e-13,
            3.6800000980524716e-13,
            4.40000005831262e-13,
            4.019999936231977e-13,
            2.8000000863899477e-13,
            1.4879999901511176e-13,
            6.040000178611157e-14,
            1.8739999176477055e-14,
            4.440000172807167e-15,
            8.000000134899068e-16,
            1.1039999794407976e-16,
            1.1600000407361886e-17,
            9.320000091975582e-19,
            5.719999818478789e-20,
            2.6799999553412788e-21,
            9.560000206538085e-23,
            2.5999999522002384e-24,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-08,
            3.2599999144622416e-07,
            4.340000032243552e-06,
            4.439999975147657e-05,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.17219999432563782,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.002839999971911311,
            0.0005019999807700515,
            6.800000119255856e-05,
            7.040000127744861e-06,
            5.559999749493727e-07,
            3.339999921081471e-08,
            1.5379999496190067e-09,
            5.399999891686491e-11,
            1.4460000037630483e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.4039999718384877e-10,
            4.039999890181889e-09,
            8.840000020882144e-08,
            1.4779999446545844e-06,
            1.8880000425269827e-05,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010499999625608325,
            0.0001621999981580302,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006200000178068876,
            0.001028000027872622,
            0.00013000000035390258,
            1.2540000170702115e-05,
            9.240000053978292e-07,
            5.200000074978561e-08,
            2.239999963293826e-09,
            7.320000161570306e-11,
            1.827999990960949e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-09,
            5.700000116348747e-08,
            1.0700000530050602e-06,
            1.531999987491872e-05,
            0.0001672000071266666,
            0.0013940000208094716,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            8.479999814881012e-05,
            7.160000222938834e-06,
            4.620000026989146e-07,
            2.280000011012362e-08,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-09,
            7.38000025535257e-08,
            1.3879999869459425e-06,
            1.990000055229757e-05,
            0.00021800000104121864,
            0.001820000004954636,
            0.011599999852478504,
            0.05640000104904175,
            0.20999999344348907,
            0.5960000157356262,
            1.2879999876022339,
            2.119999885559082,
            2.680000066757202,
            2.5799999237060547,
            1.899999976158142,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.007079999893903732,
            0.0010300000431016088,
            0.00011439999798312783,
            9.68000040302286e-06,
            6.259999736357713e-07,
            3.139999904533397e-08,
            1.68199996153362e-08,
            3.0800001127317955e-07,
            4.640000042854808e-06,
            5.32000012753997e-05,
            0.0004659999976865947,
            0.003120000008493662,
            0.01592000015079975,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            6.540000322274864e-05,
            6.719999873894267e-06,
            1.035999957821332e-06,
            7.3999999585794285e-06,
            8.060000254772604e-05,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.38999998569488525,
            0.1664000004529953,
            0.05420000106096268,
            0.013539999723434448,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016820000484585762,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.8420000076293945,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            3.600000127335079e-05,
            2.7599999157246202e-06,
            1.6120000623232045e-07,
            7.180000149986654e-09,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.593999932048007e-11,
            4.799999842042268e-10,
            1.1040000025275276e-08,
            1.9380000537694286e-07,
            2.6000000161729986e-06,
            2.660000063769985e-05,
            0.00020799999765586108,
            0.0012339999666437507,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.061400000005960464,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            4.199999966658652e-05,
            4.359999820735538e-06,
            3.460000073118863e-07,
            2.0799999944642877e-08,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.059999929103557e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6140000447251168e-10,
            4.859999958028993e-09,
            1.1160000212839805e-07,
            1.959999963219161e-06,
            2.6199999410891905e-05,
            0.0002680000034160912,
            0.002099999925121665,
            0.01245999988168478,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.00042600001324899495,
            4.400000034365803e-05,
        ],
    ],
    "partial_info": [
        {"element": "Si", "electronicState": "1s"},
        {"element": "Si", "electronicState": "2pz"},
        {"element": "Si", "electronicState": "2px"},
        {"element": "Si", "electronicState": "2py"},
    ],
}

EIGENVALUES_AT_KPOINTS_ZERO = {
    "kpoint": [0.0, 0.0, 0.0],
    "weight": 0.07407407407407,
    "eigenvalues": [
        {
            "energies": [
                -5.755130154647047,
                6.079920476989152,
                6.079955739419986,
                6.079983425646829,
                8.59513328467922,
                8.595141153449124,
                8.595162534020126,
                9.210425415905707,
            ],
            "spin": 0.5,
            "occupations": [1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0],
        }
    ],
}

EIGENVALUES_AT_KPOINTS_ZERO_LSDA = {
    "kpoint": [0.0, 0.0, 0.0],
    "weight": 0.125,
    "eigenvalues": [
        {
            "energies": [
                -5.598699756698316,
                6.269448317677476,
                6.269570020864095,
                6.269730039158121,
                8.71144079555922,
                8.711548811463148,
                8.711754881511222,
                9.415548203479169,
            ],
            "occupations": [
                1.0,
                0.9999999999696675,
                0.99999999996915,
                0.9999999999684563,
                0.0,
                0.0,
                0.0,
                0.0,
            ],
            "spin": 0.5,
        },
        {
            "energies": [
                -5.598387780884313,
                6.270041226346397,
                6.270043273131237,
                6.2700879133902365,
                8.711681702709278,
                8.711832776510018,
                8.711902491582105,
                9.41660371431505,
            ],
            "occupations": [
                1.0,
                0.9999999999670633,
                0.9999999999670541,
                0.9999999999668493,
                0.0,
                0.0,
                0.0,
                0.0,
            ],
            "spin": -0.5,
        },
    ],
}
