NSPIN = 1
PRESSURE = 73.72
TOTAL_FORCE = 1e-06
FERMI_ENERGY = 6.607
TOTAL_ENERGY = -258.629

BASIS = {
    "units": "angstrom",
    "elements": [{"id": 1, "value": "Si"}, {"id": 2, "value": "Si"}],
    "coordinates": [
        {"id": 1, "value": [0.0, 0.0, 0.0]},
        {"id": 2, "value": [1.1159329259917776, 0.789083666533198, 1.9328525178272928]},
    ],
}

LATTICE = {
    "units": "angstrom",
    "vectors": {
        "a": [3.3477985280590525, 0.0, 1.9328525178272928],
        "c": [0.0, 0.0, 3.8657050356545857],
        "b": [1.1159331759080586, 3.1563346661327913, 1.9328525178272928],
        "alat": 1.0,
    },
}

CONVERGENCE_ELECTRONIC = [
    [1.40182131e00, 5.93994699e-01, 7.00312479e-03, 1.01988311e-03, 4.20416063e-05, 7.61919078e-06]
]

STRESS_TENSOR = [[73.72, -0.0, 0.0], [-0.0, 73.71, 0.0], [0.0, -0.0, 73.72]]

ATOMIC_FORCES = [
    [-1.0027306807212303e-05, -6.170650342899877e-06, 0.0],
    [1.0027306807212303e-05, 6.170650342899877e-06, 0.0],
]

TOTAL_ENERGY_CONTRIBUTION = {
    "harris_foulkes": {"name": "harris_foulkes", "value": -258.6293887585482},
    "ewald": {"name": "ewald", "value": -226.94126871332813},
    "one_electron": {"name": "one_electron", "value": 68.65366986552296},
    "hartree": {"name": "hartree", "value": 17.72349166363712},
    "exchange_correlation": {"name": "exchange_correlation", "value": -118.06528742483022},
    "smearing": {"name": "smearing", "value": -0.0},
}

CONVERGENCE_IONIC = [
    {
        "energy": -258.62939460899827,
        "electronic": {"units": "eV", "data": [0.10303193, 0.04365779, 0.00051472, 7.496e-05, 3.09e-06, 5.6e-07]},
        "structure": {
            "lattice": {
                "vectors": {
                    "a": [3.348932294938406, 0.0, 1.9335078634787712],
                    "c": [0.0, 0.0, 3.8670157269575425],
                    "b": [1.1163107649794686, 3.157406740013653, 1.9335078634787712],
                    "alat": 1,
                }
            },
            "basis": {
                "units": "angstrom",
                "elements": [{"id": 0, "value": "Si"}, {"id": 1, "value": "Si"}],
                "coordinates": [
                    {"id": 0, "value": [0.0, 0.0, 0.0]},
                    {"id": 1, "value": [1.116311538382614, 0.7893511049510541, 1.9335078634787712]},
                ],
            },
        },
    }
]

IBZ_KPOINTS = [
    [0.0, 0.0, 0.0],
    [-4.8471013318887174e-17, -4.8471013318887174e-17, -0.5000000000000001],
    [0.0, -0.4999999999999998, 0.0],
    [-4.8471013318887174e-17, -0.4999999999999998, -0.5000000000000001],
    [-0.4999999999999998, 6.584042720160102e-17, 0.0],
    [-0.4999999999999998, -0.4999999999999998, 0.0],
]

EIGENVALUES_AT_KPOINTS_ZERO = {
    "kpoint": [0.0, 0.0, 0.0],
    "weight": 0.25,
    "eigenvalues": [
        {
            "energies": [
                -5.5990059,
                6.26931638,
                6.26931998,
                6.26934533,
                8.71135349,
                8.71135587,
                8.71135838,
                9.41550185,
            ],
            "spin": 0.5,
            "occupations": [1.0, 0.9999999999990231, 0.9999999999990226, 0.9999999999990189, 0.0, 0.0, 0.0, 0.0],
        }
    ],
}

DOS = {
    "energy": [
        -6.005000114440918,
        -5.954999923706055,
        -5.90500020980835,
        -5.855000019073486,
        -5.804999828338623,
        -5.755000114440918,
        -5.704999923706055,
        -5.65500020980835,
        -5.605000019073486,
        -5.554999828338623,
        -5.505000114440918,
        -5.454999923706055,
        -5.40500020980835,
        -5.355000019073486,
        -5.304999828338623,
        -5.255000114440918,
        -5.204999923706055,
        -5.15500020980835,
        -5.105000019073486,
        -5.054999828338623,
        -5.005000114440918,
        -4.954999923706055,
        -4.90500020980835,
        -4.855000019073486,
        -4.804999828338623,
        -4.755000114440918,
        -4.704999923706055,
        -4.65500020980835,
        -4.605000019073486,
        -4.554999828338623,
        -4.505000114440918,
        -4.454999923706055,
        -4.40500020980835,
        -4.355000019073486,
        -4.304999828338623,
        -4.255000114440918,
        -4.204999923706055,
        -4.15500020980835,
        -4.105000019073486,
        -4.054999828338623,
        -4.005000114440918,
        -3.9549999237060547,
        -3.9049999713897705,
        -3.8550000190734863,
        -3.805000066757202,
        -3.755000114440918,
        -3.7049999237060547,
        -3.6549999713897705,
        -3.6050000190734863,
        -3.555000066757202,
        -3.505000114440918,
        -3.4549999237060547,
        -3.4049999713897705,
        -3.3550000190734863,
        -3.305000066757202,
        -3.255000114440918,
        -3.2049999237060547,
        -3.1549999713897705,
        -3.1050000190734863,
        -3.055000066757202,
        -3.005000114440918,
        -2.9549999237060547,
        -2.9049999713897705,
        -2.8550000190734863,
        -2.805000066757202,
        -2.755000114440918,
        -2.7049999237060547,
        -2.6549999713897705,
        -2.6050000190734863,
        -2.555000066757202,
        -2.505000114440918,
        -2.4549999237060547,
        -2.4049999713897705,
        -2.3550000190734863,
        -2.305000066757202,
        -2.255000114440918,
        -2.2049999237060547,
        -2.1549999713897705,
        -2.1050000190734863,
        -2.055000066757202,
        -2.005000114440918,
        -1.9550000429153442,
        -1.9049999713897705,
        -1.8550000190734863,
        -1.8049999475479126,
        -1.7549999952316284,
        -1.7050000429153442,
        -1.6549999713897705,
        -1.6050000190734863,
        -1.5549999475479126,
        -1.5049999952316284,
        -1.4550000429153442,
        -1.4049999713897705,
        -1.3550000190734863,
        -1.3049999475479126,
        -1.2549999952316284,
        -1.2050000429153442,
        -1.1549999713897705,
        -1.1050000190734863,
        -1.0549999475479126,
        -1.0049999952316284,
        -0.9549999833106995,
        -0.9049999713897705,
        -0.8550000190734863,
        -0.8050000071525574,
        -0.7549999952316284,
        -0.7049999833106995,
        -0.6549999713897705,
        -0.6050000190734863,
        -0.5550000071525574,
        -0.5049999952316284,
        -0.45500001311302185,
        -0.4050000011920929,
        -0.35499998927116394,
        -0.3050000071525574,
        -0.2549999952316284,
        -0.20499999821186066,
        -0.1550000011920929,
        -0.10499999672174454,
        -0.054999999701976776,
        -0.004999999888241291,
        0.04500000178813934,
        0.0949999988079071,
        0.14499999582767487,
        0.19499999284744263,
        0.24500000476837158,
        0.29499998688697815,
        0.3449999988079071,
        0.39500001072883606,
        0.4449999928474426,
        0.4950000047683716,
        0.5450000166893005,
        0.5950000286102295,
        0.6449999809265137,
        0.6949999928474426,
        0.7450000047683716,
        0.7950000166893005,
        0.8450000286102295,
        0.8949999809265137,
        0.9449999928474426,
        0.9950000047683716,
        1.0449999570846558,
        1.0950000286102295,
        1.1449999809265137,
        1.1950000524520874,
        1.2450000047683716,
        1.2949999570846558,
        1.3450000286102295,
        1.3949999809265137,
        1.4450000524520874,
        1.4950000047683716,
        1.5449999570846558,
        1.5950000286102295,
        1.6449999809265137,
        1.6950000524520874,
        1.7450000047683716,
        1.7949999570846558,
        1.8450000286102295,
        1.8949999809265137,
        1.9450000524520874,
        1.9950000047683716,
        2.0450000762939453,
        2.0950000286102295,
        2.1449999809265137,
        2.194999933242798,
        2.244999885559082,
        2.2950000762939453,
        2.3450000286102295,
        2.3949999809265137,
        2.444999933242798,
        2.494999885559082,
        2.5450000762939453,
        2.5950000286102295,
        2.6449999809265137,
        2.694999933242798,
        2.744999885559082,
        2.7950000762939453,
        2.8450000286102295,
        2.8949999809265137,
        2.944999933242798,
        2.994999885559082,
        3.0450000762939453,
        3.0950000286102295,
        3.1449999809265137,
        3.194999933242798,
        3.244999885559082,
        3.2950000762939453,
        3.3450000286102295,
        3.3949999809265137,
        3.444999933242798,
        3.494999885559082,
        3.5450000762939453,
        3.5950000286102295,
        3.6449999809265137,
        3.694999933242798,
        3.744999885559082,
        3.7950000762939453,
        3.8450000286102295,
        3.8949999809265137,
        3.944999933242798,
        3.994999885559082,
        4.045000076293945,
        4.09499979019165,
        4.144999980926514,
        4.195000171661377,
        4.244999885559082,
        4.295000076293945,
        4.34499979019165,
        4.394999980926514,
        4.445000171661377,
        4.494999885559082,
        4.545000076293945,
        4.59499979019165,
        4.644999980926514,
        4.695000171661377,
        4.744999885559082,
        4.795000076293945,
        4.84499979019165,
        4.894999980926514,
        4.945000171661377,
        4.994999885559082,
        5.045000076293945,
        5.09499979019165,
        5.144999980926514,
        5.195000171661377,
        5.244999885559082,
        5.295000076293945,
        5.34499979019165,
        5.394999980926514,
        5.445000171661377,
        5.494999885559082,
        5.545000076293945,
        5.59499979019165,
        5.644999980926514,
        5.695000171661377,
        5.744999885559082,
        5.795000076293945,
        5.84499979019165,
        5.894999980926514,
        5.945000171661377,
        5.994999885559082,
        6.045000076293945,
        6.09499979019165,
        6.144999980926514,
        6.195000171661377,
        6.244999885559082,
        6.295000076293945,
        6.34499979019165,
        6.394999980926514,
        6.445000171661377,
        6.494999885559082,
        6.545000076293945,
        6.59499979019165,
        6.644999980926514,
        6.695000171661377,
        6.744999885559082,
        6.795000076293945,
        6.84499979019165,
        6.894999980926514,
        6.945000171661377,
        6.994999885559082,
        7.045000076293945,
        7.09499979019165,
        7.144999980926514,
        7.195000171661377,
        7.244999885559082,
        7.295000076293945,
        7.34499979019165,
        7.394999980926514,
        7.445000171661377,
        7.494999885559082,
        7.545000076293945,
        7.59499979019165,
        7.644999980926514,
        7.695000171661377,
        7.744999885559082,
        7.795000076293945,
        7.84499979019165,
        7.894999980926514,
        7.945000171661377,
        7.994999885559082,
        8.045000076293945,
        8.095000267028809,
        8.145000457763672,
        8.194999694824219,
        8.244999885559082,
        8.295000076293945,
        8.345000267028809,
        8.395000457763672,
        8.444999694824219,
        8.494999885559082,
        8.545000076293945,
        8.595000267028809,
        8.645000457763672,
        8.694999694824219,
        8.744999885559082,
        8.795000076293945,
        8.845000267028809,
        8.895000457763672,
        8.944999694824219,
        8.994999885559082,
        9.045000076293945,
        9.095000267028809,
        9.145000457763672,
        9.194999694824219,
        9.244999885559082,
        9.295000076293945,
        9.345000267028809,
        9.395000457763672,
        9.444999694824219,
        9.494999885559082,
        9.545000076293945,
        9.595000267028809,
        9.645000457763672,
        9.694999694824219,
        9.744999885559082,
        9.795000076293945,
        9.845000267028809,
        9.895000457763672,
        9.944999694824219,
        9.994999885559082,
        10.045000076293945,
        10.095000267028809,
        10.145000457763672,
        10.194999694824219,
        10.244999885559082,
        10.295000076293945,
        10.345000267028809,
        10.395000457763672,
        10.444999694824219,
        10.494999885559082,
        10.545000076293945,
        10.595000267028809,
        10.645000457763672,
        10.694999694824219,
        10.744999885559082,
        10.795000076293945,
        10.845000267028809,
        10.895000457763672,
        10.944999694824219,
        10.994999885559082,
        11.045000076293945,
        11.095000267028809,
        11.145000457763672,
        11.194999694824219,
        11.244999885559082,
        11.295000076293945,
        11.345000267028809,
        11.395000457763672,
        11.444999694824219,
        11.494999885559082,
        11.545000076293945,
        11.595000267028809,
        11.645000457763672,
        11.694999694824219,
        11.744999885559082,
        11.795000076293945,
        11.845000267028809,
        11.895000457763672,
        11.944999694824219,
        11.994999885559082,
        12.045000076293945,
        12.095000267028809,
        12.145000457763672,
        12.194999694824219,
        12.244999885559082,
        12.295000076293945,
        12.345000267028809,
        12.395000457763672,
        12.444999694824219,
        12.494999885559082,
        12.545000076293945,
        12.595000267028809,
        12.645000457763672,
        12.694999694824219,
        12.744999885559082,
        12.795000076293945,
        12.845000267028809,
        12.895000457763672,
        12.944999694824219,
        12.994999885559082,
        13.045000076293945,
        13.095000267028809,
        13.145000457763672,
        13.194999694824219,
        13.244999885559082,
        13.295000076293945,
        13.345000267028809,
        13.395000457763672,
        13.444999694824219,
        13.494999885559082,
        13.545000076293945,
        13.595000267028809,
        13.645000457763672,
        13.694999694824219,
        13.744999885559082,
        13.795000076293945,
        13.845000267028809,
        13.895000457763672,
        13.944999694824219,
        13.994999885559082,
        14.045000076293945,
        14.095000267028809,
        14.145000457763672,
        14.194999694824219,
        14.244999885559082,
        14.295000076293945,
        14.345000267028809,
        14.395000457763672,
        14.444999694824219,
        14.494999885559082,
        14.545000076293945,
        14.595000267028809,
        14.645000457763672,
        14.694999694824219,
        14.744999885559082,
        14.795000076293945,
        14.845000267028809,
        14.895000457763672,
        14.944999694824219,
        14.994999885559082,
        15.045000076293945,
        15.095000267028809,
        15.145000457763672,
        15.194999694824219,
        15.244999885559082,
        15.295000076293945,
        15.345000267028809,
        15.395000457763672,
        15.444999694824219,
        15.494999885559082,
        15.545000076293945,
        15.595000267028809,
        15.645000457763672,
        15.694999694824219,
        15.744999885559082,
        15.795000076293945,
        15.845000267028809,
        15.895000457763672,
        15.944999694824219,
        15.994999885559082,
        16.045000076293945,
        16.094999313354492,
        16.145000457763672,
        16.19499969482422,
        16.2450008392334,
        16.295000076293945,
        16.344999313354492,
        16.395000457763672,
        16.44499969482422,
        16.4950008392334,
        16.545000076293945,
        16.594999313354492,
    ],
    "partial": [
        [
            0.00012759999663103372,
            0.0010100000072270632,
            0.006120000034570694,
            0.028200000524520874,
            0.09939999878406525,
            0.2680000066757202,
            0.550000011920929,
            0.8600000143051147,
            1.0299999713897705,
            0.9399999976158142,
            0.656000018119812,
            0.3479999899864197,
            0.14159999787807465,
            0.043800000101327896,
            0.010379999876022339,
            0.0018739999504759908,
            0.0002579999854788184,
            0.00002719999974942766,
            0.000002179999910367769,
            1.338000004125206e-7,
            6.260000073865513e-9,
            2.2399999910494017e-10,
            6.099999845521342e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            7.020000032664786e-12,
            2.760000006318819e-10,
            8.29999979856666e-9,
            1.9060000511217368e-7,
            0.0000033399999210814713,
            0.000044600001274375245,
            0.00045399999362416565,
            0.003539999946951866,
            0.020999999716877937,
            0.09560000151395798,
            0.33000001311302185,
            0.8740000128746033,
            1.7640000581741333,
            2.7200000286102295,
            3.200000047683716,
            2.859999895095825,
            1.9639999866485596,
            1.0260000228881836,
            0.4099999964237213,
            0.12479999661445618,
            0.028999999165534973,
            0.005160000175237656,
            0.0006980000180192292,
            0.00007219999679364264,
            0.000005700000201613875,
            3.419999927700701e-7,
            1.5779999529286215e-8,
            5.540000125314748e-10,
            1.484000075602232e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.456000077448838e-11,
            5.479999787283418e-10,
            1.5719999524321793e-8,
            3.440000000409782e-7,
            0.000005760000021837186,
            0.00007360000017797574,
            0.0007179999956861138,
            0.0053400001488626,
            0.03020000085234642,
            0.13120000064373016,
            0.4339999854564667,
            1.0959999561309814,
            2.119999885559082,
            3.0999999046325684,
            3.5,
            3.0,
            1.9579999446868896,
            0.9779999852180481,
            0.3720000088214874,
            0.10840000212192535,
            0.024000000208616257,
            0.0040799998678267,
            0.0005540000274777412,
            0.00029399999766610563,
            0.0017679999582469463,
            0.00977999996393919,
            0.0414000004529953,
            0.1340000033378601,
            0.33000001311302185,
            0.621999979019165,
            0.8939999938011169,
            0.9819999933242798,
            0.8220000267028809,
            0.5260000228881836,
            0.25600001215934753,
            0.09560000151395798,
            0.0272000003606081,
            0.005900000222027302,
            0.0009759999811649323,
            0.0001235999952768907,
            0.000011920000360987615,
            8.779999802754901e-7,
            4.940000053466065e-8,
            2.1199999533649816e-9,
            6.939999963595511e-11,
            1.7360000156146915e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            2.4600000184897602e-24,
            1.0380000291587429e-22,
            3.3400000151758803e-21,
            8.199999739777285e-20,
            1.5379999705794193e-18,
            2.1999999973925744e-17,
            2.4000000934092797e-16,
            2.0000000072549875e-15,
            1.2759999931937372e-14,
            6.19999995896299e-14,
            2.299999925757523e-13,
            6.500000190867716e-13,
            1.4059999909124543e-12,
            2.320000094813146e-12,
            2.9199999623114037e-12,
            2.800000032179839e-12,
            2.0599999570741767e-12,
            1.1520000448364542e-12,
            4.919999954319798e-13,
            1.6040000003127858e-13,
            3.99999992980668e-14,
            7.579999589156852e-15,
            1.0999999722265076e-15,
            1.2180000262293857e-16,
            1.0300000047951097e-17,
            6.640000047777011e-19,
            3.279999895910914e-20,
            1.230000001356271e-21,
            3.5199999110138334e-23,
            0.0,
            0.0,
            0.0,
            0.0,
            3.379999977303355e-24,
            1.4320000161504878e-22,
            4.6200000149454275e-21,
            1.1359999639496336e-19,
            2.1399999967117036e-18,
            3.060000158801501e-17,
            3.359999971954314e-16,
            2.799999967805335e-15,
            1.7859999706915618e-14,
            8.700000084498755e-14,
            3.239999956695938e-13,
            9.160000232280585e-13,
            1.983999986868157e-12,
            3.279999969546532e-12,
            4.139999974783759e-12,
            3.979999923381383e-12,
            2.9199999623114037e-12,
            1.639999984773266e-12,
            7.019999815824352e-13,
            2.299999925757523e-13,
            5.719999940281134e-14,
            1.0900000283061654e-14,
            1.5859999487902393e-15,
            1.7579999413673553e-16,
            1.4899999410834012e-17,
            9.619999888584783e-19,
            4.779999848309198e-20,
            8.240000061625332e-21,
            1.2699999920089563e-19,
            1.9080000299234965e-18,
            2.1799999282338997e-17,
            1.9179999652411603e-16,
            1.2820000357789078e-15,
            6.5399998310238135e-15,
            2.5600000431677018e-14,
            7.58000026678321e-14,
            1.721999956906875e-13,
            2.9799998731670774e-13,
            3.73999997638208e-11,
            1.255999970695143e-9,
            3.239999912807434e-8,
            6.419999749596172e-7,
            0.00000968000040302286,
            0.00011139999696752056,
            0.000977999996393919,
            0.006560000125318766,
            0.03359999880194664,
            0.13099999725818634,
            0.38999998569488525,
            0.8899999856948853,
            1.5460000038146973,
            2.0399999618530273,
            2.0799999237060547,
            1.6019999980926514,
            0.9440000057220459,
            0.4259999990463257,
            0.1459999978542328,
            0.03840000182390213,
            0.007720000110566616,
            0.001617999980226159,
            0.0035600000992417336,
            0.02019999921321869,
            0.09019999951124191,
            0.30799999833106995,
            0.8059999942779541,
            1.6059999465942383,
            2.440000057220459,
            2.8399999141693115,
            2.5199999809265137,
            1.7020000219345093,
            0.878000020980835,
            0.34599998593330383,
            0.10419999808073044,
            0.024000000208616257,
            0.00419999985024333,
            0.0005619999719783664,
            0.00005740000051446259,
            0.000004479999915929511,
            2.660000006926566e-7,
            1.210000011298007e-8,
            4.200000069953802e-10,
            1.1219999755673893e-11,
            5.720000211331677e-13,
            2.119999922139959e-12,
            5.999999976025183e-12,
            1.2979999887419158e-11,
            2.1399999827753646e-11,
            2.7600000410132886e-11,
            4.9400001450594644e-11,
            7.959999881457236e-10,
            1.969999985362847e-8,
            3.8199999607968493e-7,
            0.000005639999926643213,
            0.00006359999679261819,
            0.0005460000247694552,
            0.003599999938160181,
            0.01802000030875206,
            0.0689999982714653,
            0.20200000703334808,
            0.44999998807907104,
            0.765999972820282,
            0.9940000176429749,
            0.9860000014305115,
            0.7459999918937683,
            0.4320000112056732,
            0.19040000438690186,
            0.06419999897480011,
            0.01648000068962574,
            0.0032399999909102917,
            0.0004839999892283231,
            0.00005539999983739108,
            0.000004819999958272092,
            3.220000053261174e-7,
            1.6339999575620823e-8,
            6.340000191507045e-10,
            1.8780000124452023e-11,
            7.959999828172916e-22,
            2.0599999712301224e-23,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.339999988822423e-13,
            1.320000012072775e-11,
            3.979999940728618e-10,
            9.139999868068571e-9,
            1.6040000616612815e-7,
            0.0000021400001060101204,
            0.000022000000171829015,
            0.00017139999545179307,
            0.0010219999821856618,
            0.004639999940991402,
            0.016119999811053276,
            0.04259999841451645,
            0.08640000224113464,
            0.133200004696846,
            0.15700000524520874,
            0.1412000060081482,
            0.09700000286102295,
            0.05079999938607216,
            0.020400000736117363,
            0.006200000178068876,
            0.0014440000522881746,
            0.00025599999935366213,
            0.00003479999941191636,
            0.0000036199999158270657,
            2.859999881366093e-7,
            1.7259999651741964e-8,
            7.959999881457236e-10,
            2.799999988811752e-11,
            7.520000247507319e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            2.759999892218003e-22,
            1.0860000140039715e-20,
            3.279999895910914e-19,
            7.519999864754306e-18,
            1.3179999418888404e-16,
            1.7659999557959353e-15,
            1.805999943235541e-14,
            1.4100000464076223e-13,
            8.3999999881193e-13,
            3.819999871979007e-12,
            1.3240000241998562e-11,
            3.499999942646603e-11,
            7.099999754789366e-11,
            1.0940000294556995e-10,
            1.2900000512239274e-10,
            1.1600000127121035e-10,
            7.960000020235114e-11,
            4.1600001221553384e-11,
            1.6659999768631195e-11,
            5.0799997888817394e-12,
            1.1839999466967122e-12,
            2.099999997029825e-13,
            2.859999970140567e-14,
            2.9600000446186993e-15,
        ],
        [
            1.0599999927278359e-16,
            8.399999797536887e-16,
            5.080000056544151e-15,
            2.340000006370753e-14,
            8.259999672091678e-14,
            2.2200000355816069e-13,
            4.559999838664452e-13,
            7.160000131851973e-13,
            8.560000039521676e-13,
            7.820000072836231e-13,
            5.44000012137752e-13,
            2.9000001185164326e-13,
            1.1759999441265934e-13,
            3.6400000852018777e-14,
            8.620000194322838e-15,
            1.5580000041693276e-15,
            2.140000021527122e-16,
            2.2600000394324757e-17,
            1.814000052293583e-18,
            1.111999964711261e-19,
            5.199999834980717e-21,
            1.8599999712661307e-22,
            5.059999970689999e-24,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-8,
            3.2599999144622416e-7,
            0.000004340000032243552,
            0.00004439999975147657,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.17219999432563782,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.0028200000524520874,
            0.0005019999807700515,
            0.00006800000119255856,
            0.000007040000127744861,
            5.559999749493727e-7,
            3.339999921081471e-8,
            1.5379999496190067e-9,
            5.399999891686491e-11,
            1.4460000037630483e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.40600003861735e-10,
            4.039999890181889e-9,
            8.840000020882144e-8,
            0.0000014779999446545844,
            0.000018880000425269827,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010479999473318458,
            0.0001621999981580302,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006200000178068876,
            0.001028000027872622,
            0.00013000000035390258,
            0.000012559999959194101,
            9.240000053978292e-7,
            5.200000074978561e-8,
            2.239999963293826e-9,
            7.320000161570306e-11,
            1.827999990960949e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-9,
            5.700000116348747e-8,
            0.0000010700000530050602,
            0.00001531999987491872,
            0.0001672000071266666,
            0.0013940000208094716,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            0.00008479999814881012,
            0.000007160000222938834,
            4.620000026989146e-7,
            2.280000011012362e-8,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-9,
            7.38000025535257e-8,
            0.0000013879999869459425,
            0.00001990000055229757,
            0.00021800000104121864,
            0.001820000004954636,
            0.011599999852478504,
            0.05640000104904175,
            0.20999999344348907,
            0.5960000157356262,
            1.2879999876022339,
            2.140000104904175,
            2.680000066757202,
            2.5799999237060547,
            1.899999976158142,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.007079999893903732,
            0.0010300000431016088,
            0.00011439999798312783,
            0.00000968000040302286,
            6.259999736357713e-7,
            3.139999904533397e-8,
            1.68199996153362e-8,
            3.0800001127317955e-7,
            0.000004640000042854808,
            0.0000532000012753997,
            0.0004659999976865947,
            0.003120000008493662,
            0.01592000015079975,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            0.00006540000322274864,
            0.000006719999873894267,
            0.000001035999957821332,
            0.0000073999999585794285,
            0.00008060000254772604,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.3880000114440918,
            0.1664000004529953,
            0.05420000106096268,
            0.01351999957114458,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016820000484585762,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.8420000076293945,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            0.00003600000127335079,
            0.0000027599999157246202,
            1.6120000623232045e-7,
            7.180000149986654e-9,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.593999932048007e-11,
            4.799999842042268e-10,
            1.1040000025275276e-8,
            1.936000018076811e-7,
            0.0000026000000161729986,
            0.00002660000063769985,
            0.00020599999697878957,
            0.001231999951414764,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.061400000005960464,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            0.00004220000118948519,
            0.000004359999820735538,
            3.460000073118863e-7,
            2.0799999944642877e-8,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.080000206579397e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6140000447251168e-10,
            4.859999958028993e-9,
            1.1160000212839805e-7,
            0.000001959999963219161,
            0.000026199999410891905,
            0.0002680000034160912,
            0.002099999925121665,
            0.012480000033974648,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.0004239999980200082,
            0.00004400000034365803,
        ],
        [
            5.40000014399643e-17,
            4.280000043054244e-16,
            2.5800001004149756e-15,
            1.1940000041194693e-14,
            4.19999999405965e-14,
            1.1319999706485215e-13,
            2.31999993218282e-13,
            3.6400000852018777e-13,
            4.360000045462026e-13,
            3.979999923381383e-13,
            2.7800000799646507e-13,
            1.4739999585483554e-13,
            5.979999752759452e-14,
            1.8559999592987833e-14,
            4.380000170471935e-15,
            7.919999990613268e-16,
            1.0919999710328173e-16,
            1.1500000061568513e-17,
            9.240000353008282e-19,
            5.660000143500284e-20,
            2.6400000373900145e-21,
            9.4599997805712e-23,
            2.57999996167017e-24,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-8,
            3.2599999144622416e-7,
            0.000004340000032243552,
            0.00004439999975147657,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.17219999432563782,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.002839999971911311,
            0.0005019999807700515,
            0.00006800000119255856,
            0.000007040000127744861,
            5.559999749493727e-7,
            3.339999921081471e-8,
            1.5379999496190067e-9,
            5.399999891686491e-11,
            1.4460000037630483e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.40600003861735e-10,
            4.039999890181889e-9,
            8.840000020882144e-8,
            0.0000014779999446545844,
            0.000018880000425269827,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010479999473318458,
            0.0001621999981580302,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006200000178068876,
            0.001028000027872622,
            0.00013000000035390258,
            0.000012540000170702115,
            9.240000053978292e-7,
            5.200000074978561e-8,
            2.239999963293826e-9,
            7.300000187671074e-11,
            1.827999990960949e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-9,
            5.700000116348747e-8,
            0.0000010700000530050602,
            0.00001531999987491872,
            0.00016739999409765005,
            0.0013940000208094716,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            0.00008479999814881012,
            0.000007160000222938834,
            4.620000026989146e-7,
            2.280000011012362e-8,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-9,
            7.38000025535257e-8,
            0.0000013879999869459425,
            0.00001990000055229757,
            0.00021800000104121864,
            0.001820000004954636,
            0.011599999852478504,
            0.05660000070929527,
            0.20999999344348907,
            0.5960000157356262,
            1.2899999618530273,
            2.140000104904175,
            2.680000066757202,
            2.5799999237060547,
            1.899999976158142,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.007079999893903732,
            0.0010300000431016088,
            0.00011419999646022916,
            0.00000968000040302286,
            6.259999736357713e-7,
            3.139999904533397e-8,
            1.68199996153362e-8,
            3.0800001127317955e-7,
            0.000004640000042854808,
            0.0000532000012753997,
            0.0004659999976865947,
            0.003120000008493662,
            0.01592000015079975,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            0.00006540000322274864,
            0.000006719999873894267,
            0.000001035999957821332,
            0.0000073999999585794285,
            0.00008060000254772604,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.38999998569488525,
            0.1664000004529953,
            0.05420000106096268,
            0.013539999723434448,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016820000484585762,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.8420000076293945,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            0.00003600000127335079,
            0.0000027599999157246202,
            1.6120000623232045e-7,
            7.180000149986654e-9,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.5919999693525533e-11,
            4.799999842042268e-10,
            1.1040000025275276e-8,
            1.936000018076811e-7,
            0.0000026000000161729986,
            0.00002660000063769985,
            0.00020599999697878957,
            0.001231999951414764,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.061400000005960464,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            0.00004220000118948519,
            0.000004359999820735538,
            3.460000073118863e-7,
            2.0799999944642877e-8,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.080000206579397e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6140000447251168e-10,
            4.859999958028993e-9,
            1.1160000212839805e-7,
            0.000001959999963219161,
            0.000026199999410891905,
            0.0002680000034160912,
            0.002099999925121665,
            0.012480000033974648,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.00042600001324899495,
            0.00004400000034365803,
        ],
        [
            1.6499999980444308e-17,
            1.3080000562020133e-16,
            7.899999954541818e-16,
            3.6600001424491515e-15,
            1.2859999794657268e-14,
            3.4600001628994764e-14,
            7.100000248101354e-14,
            1.1139999784182814e-13,
            1.3319999671388555e-13,
            1.2159999569771873e-13,
            8.479999878295216e-14,
            4.5000000904391046e-14,
            1.8319999583646905e-14,
            5.680000079896471e-15,
            1.3420000381141398e-15,
            2.42000012948073e-16,
            3.340000134406211e-17,
            3.5200000950897925e-18,
            2.8200001043792296e-19,
            1.732000041971113e-20,
            8.10000004587332e-22,
            2.9000000468095347e-23,
            7.9000002036815095e-25,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            6.840000029047222e-13,
            2.6999999458432455e-11,
            8.100000115085493e-10,
            1.8579999760959254e-8,
            3.2599999144622416e-7,
            0.000004340000032243552,
            0.00004439999975147657,
            0.0003459999861661345,
            0.0020600000862032175,
            0.009320000186562538,
            0.03220000118017197,
            0.0851999968290329,
            0.17219999432563782,
            0.26600000262260437,
            0.31200000643730164,
            0.2800000011920929,
            0.1915999948978424,
            0.10019999742507935,
            0.03999999910593033,
            0.012179999612271786,
            0.0028200000524520874,
            0.0005019999807700515,
            0.00006800000119255856,
            0.000007040000127744861,
            5.559999749493727e-7,
            3.339999921081471e-8,
            1.5379999496190067e-9,
            5.399999891686491e-11,
            1.4460000037630483e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            3.740000063118254e-12,
            1.40600003861735e-10,
            4.039999890181889e-9,
            8.840000020882144e-8,
            0.0000014779999446545844,
            0.000018880000425269827,
            0.00018400000408291817,
            0.0013680000556632876,
            0.0077599999494850636,
            0.03359999880194664,
            0.11140000075101852,
            0.28200000524520874,
            0.5419999957084656,
            0.7979999780654907,
            0.8960000276565552,
            0.7680000066757202,
            0.5019999742507935,
            0.25,
            0.09560000151395798,
            0.027799999341368675,
            0.006180000025779009,
            0.0010479999473318458,
            0.0001621999981580302,
            0.0002680000034160912,
            0.0018579999450594187,
            0.010300000198185444,
            0.04360000044107437,
            0.14100000262260437,
            0.3479999899864197,
            0.656000018119812,
            0.9419999718666077,
            1.034000039100647,
            0.8659999966621399,
            0.5540000200271606,
            0.27000001072883606,
            0.1005999967455864,
            0.028599999845027924,
            0.006200000178068876,
            0.001028000027872622,
            0.00013000000035390258,
            0.000012559999959194101,
            9.240000053978292e-7,
            5.200000074978561e-8,
            2.239999963293826e-9,
            7.320000161570306e-11,
            1.827999990960949e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            1.7120000079043352e-12,
            7.220000292074147e-11,
            2.3199999699130558e-9,
            5.700000116348747e-8,
            0.0000010700000530050602,
            0.00001531999987491872,
            0.0001672000071266666,
            0.0013940000208094716,
            0.00887999963015318,
            0.04320000112056732,
            0.1599999964237213,
            0.4519999921321869,
            0.9779999852180481,
            1.6119999885559082,
            2.0399999618530273,
            1.9500000476837158,
            1.4299999475479126,
            0.800000011920929,
            0.34200000762939453,
            0.11159999668598175,
            0.027799999341368675,
            0.005280000157654285,
            0.0007660000119358301,
            0.00008479999814881012,
            0.000007160000222938834,
            4.620000026989146e-7,
            2.280000011012362e-8,
            8.559999931101459e-10,
            2.4600000855801163e-11,
            0.0,
            0.0,
            0.0,
            0.0,
            2.199999947841147e-12,
            9.299999659262426e-11,
            3.000000026176508e-9,
            7.38000025535257e-8,
            0.0000013879999869459425,
            0.00001990000055229757,
            0.00021800000104121864,
            0.001820000004954636,
            0.011599999852478504,
            0.05640000104904175,
            0.20999999344348907,
            0.5960000157356262,
            1.2879999876022339,
            2.119999885559082,
            2.680000066757202,
            2.5799999237060547,
            1.9019999504089355,
            1.065999984741211,
            0.4560000002384186,
            0.14920000731945038,
            0.03720000013709068,
            0.007079999893903732,
            0.0010300000431016088,
            0.00011439999798312783,
            0.00000968000040302286,
            6.259999736357713e-7,
            3.139999904533397e-8,
            1.68199996153362e-8,
            3.0800001127317955e-7,
            0.000004640000042854808,
            0.0000532000012753997,
            0.0004659999976865947,
            0.003120000008493662,
            0.01592000015079975,
            0.06199999898672104,
            0.18440000712871552,
            0.4180000126361847,
            0.7260000109672546,
            0.9599999785423279,
            0.9679999947547913,
            0.7459999918937683,
            0.43799999356269836,
            0.19699999690055847,
            0.06759999692440033,
            0.018120000138878822,
            0.006659999955445528,
            0.016580000519752502,
            0.06279999762773514,
            0.18700000643730164,
            0.4259999990463257,
            0.7379999756813049,
            0.9800000190734863,
            0.9919999837875366,
            0.765999972820282,
            0.4519999921321869,
            0.20399999618530273,
            0.0697999969124794,
            0.018319999799132347,
            0.0036800000816583633,
            0.0006120000034570694,
            0.00046400001156143844,
            0.0023399998899549246,
            0.010499999858438969,
            0.035999998450279236,
            0.09380000084638596,
            0.18719999492168427,
            0.2840000092983246,
            0.33000001311302185,
            0.2939999997615814,
            0.19840000569820404,
            0.10239999741315842,
            0.04039999842643738,
            0.012160000391304493,
            0.00279999990016222,
            0.0004900000058114529,
            0.00006540000322274864,
            0.000006719999873894267,
            0.000001035999957821332,
            0.0000073999999585794285,
            0.00008060000254772604,
            0.0006719999946653843,
            0.004279999993741512,
            0.020800000056624413,
            0.07720000296831131,
            0.21799999475479126,
            0.4740000069141388,
            0.7820000052452087,
            0.984000027179718,
            0.9459999799728394,
            0.6940000057220459,
            0.3880000114440918,
            0.1664000004529953,
            0.05420000106096268,
            0.01351999957114458,
            0.0026199999265372753,
            0.0007600000244565308,
            0.002959999954327941,
            0.016820000484585762,
            0.07400000095367432,
            0.24799999594688416,
            0.6359999775886536,
            1.24399995803833,
            1.8580000400543213,
            2.119999885559082,
            1.8420000076293945,
            1.222000002861023,
            0.6200000047683716,
            0.23999999463558197,
            0.07079999893903732,
            0.015939999371767044,
            0.002739999908953905,
            0.0003600000054575503,
            0.00003600000127335079,
            0.0000027599999157246202,
            1.6120000623232045e-7,
            7.180000149986654e-9,
            2.439999868819598e-10,
            6.3400001394653405e-12,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.039999942657274e-13,
            1.593999932048007e-11,
            4.799999842042268e-10,
            1.1040000025275276e-8,
            1.936000018076811e-7,
            0.0000026000000161729986,
            0.00002660000063769985,
            0.00020599999697878957,
            0.001231999951414764,
            0.00559999980032444,
            0.019460000097751617,
            0.051600001752376556,
            0.10419999808073044,
            0.1607999950647354,
            0.18960000574588776,
            0.1703999936580658,
            0.11699999868869781,
            0.061400000005960464,
            0.02459999918937683,
            0.0074800001457333565,
            0.001744000008329749,
            0.0003100000030826777,
            0.00004220000118948519,
            0.000004359999820735538,
            3.460000073118863e-7,
            2.0799999944642877e-8,
            9.599999684084537e-10,
            3.3800000992512125e-11,
            9.080000206579397e-13,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            4.079999792877542e-12,
            1.6140000447251168e-10,
            4.859999958028993e-9,
            1.1160000212839805e-7,
            0.000001959999963219161,
            0.000026199999410891905,
            0.0002680000034160912,
            0.002099999925121665,
            0.012480000033974648,
            0.05660000070929527,
            0.19679999351501465,
            0.5220000147819519,
            1.0540000200271606,
            1.6260000467300415,
            1.9160000085830688,
            1.722000002861023,
            1.1820000410079956,
            0.6200000047683716,
            0.24799999594688416,
            0.07559999823570251,
            0.01759999990463257,
            0.0031399999279528856,
            0.00042600001324899495,
            0.00004400000034365803,
        ],
    ],
    "partial_info": [
        {"electronicState": "1s", "element": "Si"},
        {"electronicState": "2pz", "element": "Si"},
        {"electronicState": "2px", "element": "Si"},
        {"electronicState": "2py", "element": "Si"},
    ],
    "total": [
        0.00012799999967683107,
        0.0010100000072270632,
        0.006130000110715628,
        0.028300000354647636,
        0.0997999981045723,
        0.2680000066757202,
        0.5509999990463257,
        0.8629999756813049,
        1.0299999713897705,
        0.9430000185966492,
        0.6570000052452087,
        0.3499999940395355,
        0.1420000046491623,
        0.04399999976158142,
        0.010400000028312206,
        0.001879999996162951,
        0.0002589999930933118,
        0.000027300000510876998,
        0.000002190000031987438,
        1.3400000398178236e-7,
        6.28000007552032e-9,
        2.2399999910494017e-10,
        6.119999906156748e-12,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        9.100000267214803e-12,
        3.5799999076324696e-10,
        1.0800000005417587e-8,
        2.4700000267330324e-7,
        0.000004319999789004214,
        0.00005779999992228113,
        0.000590000010561198,
        0.0045900000259280205,
        0.027300000190734863,
        0.12399999797344208,
        0.42899999022483826,
        1.1299999952316284,
        2.2899999618530273,
        3.5199999809265137,
        4.139999866485596,
        3.7200000286102295,
        2.549999952316284,
        1.3300000429153442,
        0.531000018119812,
        0.16200000047683716,
        0.03759999945759773,
        0.006670000031590462,
        0.0009040000149980187,
        0.00009349999891128391,
        0.000007380000170087442,
        4.4500001195046934e-7,
        2.039999991154673e-8,
        7.17000014915925e-10,
        1.9199999229391196e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        2.589999915925123e-11,
        9.759999475278391e-10,
        2.800000054037355e-8,
        6.139999868537416e-7,
        0.000010300000212737359,
        0.00013099999341648072,
        0.0012799999676644802,
        0.009499999694526196,
        0.05389999970793724,
        0.23399999737739563,
        0.7730000019073486,
        1.9500000476837158,
        3.759999990463257,
        5.539999961853027,
        6.21999979019165,
        5.329999923706055,
        3.490000009536743,
        1.7400000095367432,
        0.6639999747276306,
        0.19300000369548798,
        0.042899999767541885,
        0.007280000019818544,
        0.0010499999625608325,
        0.0011099999537691474,
        0.007430000230669975,
        0.041200000792741776,
        0.17399999499320984,
        0.5640000104904175,
        1.3899999856948853,
        2.619999885559082,
        3.7699999809265137,
        4.130000114440918,
        3.4600000381469727,
        2.2100000381469727,
        1.0800000429153442,
        0.4020000100135803,
        0.11400000005960464,
        0.024800000712275505,
        0.004110000096261501,
        0.0005200000014156103,
        0.00005020000025979243,
        0.0000036999999792897142,
        2.0800000299914245e-7,
        8.91999984986569e-9,
        2.9200000750684296e-10,
        7.309999827675995e-12,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        5.160000031423362e-12,
        2.1800000693517063e-10,
        7.000000135093387e-9,
        1.720000000204891e-7,
        0.000003220000053261174,
        0.00004610000178217888,
        0.0005039999959990382,
        0.00419999985024333,
        0.02669999934732914,
        0.12999999523162842,
        0.4819999933242798,
        1.3600000143051147,
        2.950000047683716,
        4.860000133514404,
        6.119999885559082,
        5.880000114440918,
        4.309999942779541,
        2.4100000858306885,
        1.0299999713897705,
        0.335999995470047,
        0.08370000123977661,
        0.01590000092983246,
        0.002309999894350767,
        0.00025499999173916876,
        0.000021600000764010474,
        0.0000013899999657951412,
        6.860000212327577e-8,
        2.5799999914255523e-9,
        7.389999723272922e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        6.679999869224629e-12,
        2.8200000667943925e-10,
        9.099999864758956e-9,
        2.240000043229884e-7,
        0.0000042100000428035855,
        0.00006040000153006986,
        0.000661000027321279,
        0.005520000122487545,
        0.03519999980926514,
        0.17100000381469727,
        0.6370000243186951,
        1.809999942779541,
        3.9100000858306885,
        6.460000038146973,
        8.149999618530273,
        7.849999904632568,
        5.769999980926514,
        3.2300000190734863,
        1.3799999952316284,
        0.453000009059906,
        0.11299999803304672,
        0.0215000007301569,
        0.0031300000846385956,
        0.00034699999378062785,
        0.000029400000130408444,
        0.0000019000000293090125,
        9.549999901992123e-8,
        5.240000078288176e-8,
        9.630000477045542e-7,
        0.000014500000361294951,
        0.00016599999798927456,
        0.001449999981559813,
        0.009730000048875809,
        0.04969999939203262,
        0.19300000369548798,
        0.574999988079071,
        1.309999942779541,
        2.259999990463257,
        2.990000009536743,
        3.0199999809265137,
        2.3299999237060547,
        1.3700000047683716,
        0.6150000095367432,
        0.210999995470047,
        0.05790000036358833,
        0.03009999915957451,
        0.09950000047683716,
        0.382999986410141,
        1.1399999856948853,
        2.5899999141693115,
        4.510000228881836,
        5.980000019073486,
        6.050000190734863,
        4.670000076293945,
        2.759999990463257,
        1.2400000095367432,
        0.4259999990463257,
        0.1120000034570694,
        0.02239999920129776,
        0.0040699997916817665,
        0.005400000140070915,
        0.029400000348687172,
        0.13199999928474426,
        0.45100000500679016,
        1.1799999475479126,
        2.3499999046325684,
        3.569999933242798,
        4.150000095367432,
        3.6700000762939453,
        2.490000009536743,
        1.2799999713897705,
        0.5059999823570251,
        0.15199999511241913,
        0.03500000014901161,
        0.006140000186860561,
        0.0008210000232793391,
        0.00008399999933317304,
        0.000008140000318235252,
        0.000023299999156733975,
        0.0002500000118743628,
        0.002090000081807375,
        0.013299999758601189,
        0.06469999998807907,
        0.23999999463558197,
        0.6800000071525574,
        1.4700000286102295,
        2.430000066757202,
        3.059999942779541,
        2.940000057220459,
        2.1600000858306885,
        1.2100000381469727,
        0.5170000195503235,
        0.16899999976158142,
        0.042100001126527786,
        0.008700000122189522,
        0.006310000084340572,
        0.02979999966919422,
        0.13600000739097595,
        0.49399998784065247,
        1.4299999475479126,
        3.2699999809265137,
        5.880000114440918,
        8.279999732971191,
        9.050000190734863,
        7.650000095367432,
        4.980000019073486,
        2.490000009536743,
        0.9549999833106995,
        0.2800000011920929,
        0.06289999932050705,
        0.01080000028014183,
        0.0014199999859556556,
        0.00014200000441633165,
        0.000010800000382005237,
        6.32000023870205e-7,
        2.8200000556921623e-8,
        9.58000012651894e-10,
        2.490000046428964e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        8.820000285680862e-12,
        3.4799998993584325e-10,
        1.0499999980595476e-8,
        2.410000092822884e-7,
        0.000004229999831295572,
        0.00005660000169882551,
        0.0005789999850094318,
        0.004519999958574772,
        0.026900000870227814,
        0.12200000137090683,
        0.42500001192092896,
        1.1299999952316284,
        2.2799999713897705,
        3.509999990463257,
        4.139999866485596,
        3.7200000286102295,
        2.559999942779541,
        1.340000033378601,
        0.5360000133514404,
        0.164000004529953,
        0.038100000470876694,
        0.006779999937862158,
        0.0009200000204145908,
        0.00009529999806545675,
        0.000007539999842265388,
        4.54999991461591e-7,
        2.099999996119095e-8,
        7.379999944490123e-10,
        1.9800000181091626e-11,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.329999999022391e-11,
        5.229999766598326e-10,
        1.5799999530941022e-8,
        3.6200000863573223e-7,
        0.000006350000148813706,
        0.00008510000043315813,
        0.0008699999889358878,
        0.0067900000140070915,
        0.04039999842643738,
        0.18400000035762787,
        0.6380000114440918,
        1.690000057220459,
        3.4200000762939453,
        5.269999980926514,
        6.210000038146973,
        5.579999923706055,
        3.8299999237060547,
        2.009999990463257,
        0.8029999732971191,
        0.24500000476837158,
        0.057100001722574234,
        0.010200000368058681,
        0.0013800000306218863,
        0.0001429999974789098,
    ],
}

PHONON_DOS = {
    "total": [
        0.0,
        1.7269000451847205e-08,
        6.90749999421314e-08,
        1.554199968722969e-07,
        2.762999997685256e-07,
        4.317199966408225e-07,
        6.216799874891876e-07,
        8.461699962936109e-07,
        1.1051999990741024e-06,
        1.3988000091558206e-06,
        1.726899995446729e-06,
        2.0894999579468276e-06,
        2.4866999410733115e-06,
        2.9184000140958233e-06,
        3.3846999940578826e-06,
        3.88550006391597e-06,
        4.4207999962964095e-06,
        4.990699835616397e-06,
        5.595099992206087e-06,
        6.23400001131813e-06,
        6.907499937369721e-06,
        7.615500180691015e-06,
        8.358099876204506e-06,
        9.13520034373505e-06,
        9.946799764293246e-06,
        1.079300000128569e-05,
        1.1674000234052073e-05,
        1.2589000107254833e-05,
        1.353900006506592e-05,
        1.4522999663313385e-05,
        1.554200025566388e-05,
        1.659500048845075e-05,
        1.7682999896351248e-05,
        1.8806000298354775e-05,
        1.9962999431299977e-05,
        2.115399911417626e-05,
        2.237999979115557e-05,
        2.3640999643248506e-05,
        2.493600004527252e-05,
        2.6265999622410163e-05,
        2.7629999749478884e-05,
        2.9029000870650634e-05,
        3.046200072276406e-05,
        3.1930001568980515e-05,
        3.343199932714924e-05,
        3.4969001717399806e-05,
        3.654100146377459e-05,
        3.814700176008046e-05,
        3.9786998968338594e-05,
        4.146200080867857e-05,
        4.317200000514276e-05,
        4.491599975153804e-05,
        4.669500049203634e-05,
        4.8508001782465726e-05,
        5.035600042901933e-05,
        5.223799962550402e-05,
        5.415499981609173e-05,
        5.6106000556610525e-05,
        5.809199865325354e-05,
        6.011300138197839e-05,
        6.216800102265552e-05,
        6.425700121326372e-05,
        6.638099875999615e-05,
        6.854000093881041e-05,
        7.073299639159814e-05,
        7.29609964764677e-05,
        7.522299711126834e-05,
        7.751899829600006e-05,
        7.985100091900676e-05,
        8.221699681598693e-05,
        8.461700053885579e-05,
        8.705200161784887e-05,
        8.952100324677303e-05,
        9.202500223182142e-05,
        9.456399857299402e-05,
        9.713700274005532e-05,
        9.974400018109009e-05,
        0.00010238999675493687,
        0.00010505999671295285,
        0.00010776999988593161,
        0.00011051999899791554,
        0.00011329999688314274,
        0.00011611999798333272,
        0.0001189600006910041,
        0.00012184999650344253,
        0.00012476999836508185,
        0.00012772000627592206,
        0.00013071000284980983,
        0.00013373000547289848,
        0.0001367899967590347,
        0.0001398799940943718,
        0.0001429999974789098,
        0.00014616000407841057,
        0.0001493599993409589,
        0.0001525900006527081,
        0.000155849993461743,
        0.0001591500040376559,
        0.00016248000611085445,
        0.00016584999684710056,
        0.00016924999363254756,
        0.00017268999363295734,
        0.00017615999968256801,
        0.00017965999722946435,
        0.00018319999799132347,
        0.00018678000196814537,
        0.00019038999744225293,
        0.0001940299989655614,
        0.00019771000370383263,
        0.00020141999993938953,
        0.0002051699993899092,
        0.00020895000488962978,
        0.0002127699990523979,
        0.00021661999926436692,
        0.00022050000552553684,
        0.0002244200004497543,
        0.00022837999858893454,
        0.00023237000277731568,
        0.00023638999846298248,
        0.00024044999736361206,
        0.0002445399877615273,
        0.00024866999592632055,
        0.0002528300101403147,
        0.0002570300130173564,
        0.00026125999283976853,
        0.000265520007815212,
        0.00026982001145370305,
        0.00027416000375524163,
        0.0002785300021059811,
        0.0002829300065059215,
        0.0002873699995689094,
        0.0002918399986810982,
        0.0002963499864563346,
        0.0003008900093846023,
        0.0003054699918720871,
        0.0003100800095126033,
        0.0003147200040984899,
        0.00031939998734742403,
        0.0003241199883632362,
        0.00032886999542824924,
        0.0003336500085424632,
        0.0003384700103197247,
        0.0003433199890423566,
        0.00034820998553186655,
        0.0003531299880705774,
        0.0003580799966584891,
        0.0003630800056271255,
        0.00036810000892728567,
        0.0003731600008904934,
        0.000378249998902902,
        0.0003833799855783582,
        0.00038854999002069235,
        0.0003937399887945503,
        0.0003989799879491329,
        0.00040424001053906977,
        0.00040955000440590084,
        0.0004148799926042557,
        0.0004202499985694885,
        0.0004256599931977689,
        0.0004310999938752502,
        0.0004365700006019324,
        0.00044207999599166214,
        0.0004476199974305928,
        0.00045319998753257096,
        0.0004588100127875805,
        0.0004644599976018071,
        0.00047013998846523464,
        0.00047585999709554017,
        0.0004816100117750466,
        0.00048739000339992344,
        0.0004932099836878479,
        0.0004990699817426503,
        0.000504960014950484,
        0.0005108800251036882,
        0.00051684002391994,
        0.0005228299996815622,
        0.0005288600223138928,
        0.0005349200218915939,
        0.0005410099984146655,
        0.0005471400218084455,
        0.0005533099756576121,
        0.000559510022867471,
        0.0005657399888150394,
        0.0005720100016333163,
        0.0005783099913969636,
        0.0005846500280313194,
        0.0005910199834033847,
        0.0005974299856461585,
        0.0006038700230419636,
        0.0006103499908931553,
        0.0006168599938973784,
        0.000623399973846972,
        0.000629980000667274,
        0.0006366000161506236,
        0.0006432399968616664,
        0.000649929977953434,
        0.0006566399824805558,
        0.0006633999873884022,
        0.0006701800157316029,
        0.0006769999745301902,
        0.000683859980199486,
        0.0006907500210218132,
        0.0006976799922995269,
        0.0007046299870125949,
        0.0007116299821063876,
        0.0007186600123532116,
        0.0007257200195454061,
        0.0007328200154006481,
        0.0007399499882012606,
        0.0007471200078725815,
        0.0007543200044892728,
        0.0007615499780513346,
        0.0007688199984841049,
        0.0007761300075799227,
        0.0007834699936211109,
        0.0007908400148153305,
        0.0007982500246725976,
        0.0008056900114752352,
        0.0008131699869409204,
        0.0008206799975596368,
        0.0008282299968414009,
        0.0008358099730685353,
        0.0008434199844487011,
        0.0008510699844919145,
        0.0008587599731981754,
        0.0008664799970574677,
        0.0008742299978621304,
        0.0008820199873298407,
        0.0008898400119505823,
        0.0008977000252343714,
        0.000905590015463531,
        0.0009135199943557382,
        0.0009214800084009767,
        0.0009294699993915856,
        0.0009374999790452421,
        0.000945570005569607,
        0.0009536700090393424,
        0.0009617999894544482,
        0.0009699700167402625,
        0.0009781699627637863,
        0.0009864099556580186,
        0.0009946799837052822,
        0.0010029999539256096,
        0.0010113000171259046,
        0.001019699964672327,
        0.0010281000286340714,
        0.0010365999769419432,
        0.0010450000409036875,
        0.0010534999892115593,
        0.0010621000546962023,
        0.0010707000037655234,
        0.0010792999528348446,
        0.0010879000183194876,
        0.001096599968150258,
        0.0011054000351577997,
        0.0011140999849885702,
        0.0011229000519961119,
        0.0011317000025883317,
        0.0011405999539420009,
        0.0011495000217109919,
        0.001158399973064661,
        0.0011674000415951014,
        0.0011763999937102199,
        0.0011853999458253384,
        0.001194500015117228,
        0.0012035999679937959,
        0.0012127000372856855,
        0.0012218999909237027,
        0.00123109994456172,
        0.001240300014615059,
        0.0012495999690145254,
        0.0012589000398293138,
        0.0012681999942287803,
        0.0012775999493896961,
        0.0012870000209659338,
        0.001296499976888299,
        0.0013059000484645367,
        0.0013155000051483512,
        0.0013249999610707164,
        0.0013346000341698527,
        0.0013441999908536673,
        0.0013538999482989311,
        0.0013636000221595168,
        0.0013732999796047807,
        0.0013830000534653664,
        0.0013928000116720796,
        0.001402699970640242,
        0.0014125000452622771,
        0.0014224000042304397,
        0.0014322999631986022,
        0.001442300039343536,
        0.0014522999990731478,
        0.0014622999588027596,
        0.0014724000357091427,
        0.001482499996200204,
        0.001492599956691265,
        0.0015028000343590975,
        0.001512999995611608,
        0.001523299957625568,
        0.0015335000352934003,
        0.0015437999973073602,
        0.0015541999600827694,
        0.0015646000392735004,
        0.0015750000020489097,
        0.0015853999648243189,
        0.0015959000447764993,
        0.0016064000083133578,
        0.0016169999726116657,
        0.0016276000533252954,
        0.0016382000176236033,
        0.0016487999819219112,
        0.0016594999469816685,
        0.0016703000292181969,
        0.001680999994277954,
        0.0016917999600991607,
        0.001702600042335689,
        0.001713500008918345,
        0.0017244999762624502,
        0.0017355999443680048,
        0.0017468000296503305,
        0.0017580999992787838,
        0.0017694999696686864,
        0.0017811000579968095,
        0.0017927000299096107,
        0.0018044000025838614,
        0.0018161999760195613,
        0.0018280999502167106,
        0.001840100041590631,
        0.001852200017310679,
        0.0018643999937921762,
        0.0018766999710351229,
        0.0018890999490395188,
        0.001901600044220686,
        0.00191430002450943,
        0.001927000004798174,
        0.0019397999858483672,
        0.0019526999676600099,
        0.001965699950233102,
        0.001978799933567643,
        0.0019920000340789557,
        0.0020053000189363956,
        0.0020188000053167343,
        0.002032299991697073,
        0.002045900095254183,
        0.00205960008315742,
        0.002073399955406785,
        0.002087400062009692,
        0.0021013999357819557,
        0.0021154999267309904,
        0.0021297000348567963,
        0.0021440000273287296,
        0.0021585000213235617,
        0.0021730000153183937,
        0.0021875998936593533,
        0.002202299889177084,
        0.0022171998862177134,
        0.0022321001160889864,
        0.0022470999974757433,
        0.0022621999960392714,
        0.002277499996125698,
        0.002292799996212125,
        0.0023082001134753227,
        0.002323700115084648,
        0.0023393998853862286,
        0.0023550998885184526,
        0.002370900008827448,
        0.002386899897828698,
        0.002402900019660592,
        0.0024190000258386135,
        0.0024353000335395336,
        0.0024516000412404537,
        0.0024679999332875013,
        0.0024846000596880913,
        0.0025011999532580376,
        0.002517899964004755,
        0.002534799976274371,
        0.0025516999885439873,
        0.002568699885159731,
        0.002585900016129017,
        0.002603099914267659,
        0.002620500046759844,
        0.002637899946421385,
        0.002655399963259697,
        0.002673099981620908,
        0.0026907999999821186,
        0.002708700019866228,
        0.0027266000397503376,
        0.0027445999439805746,
        0.002762800082564354,
        0.0027809999883174896,
        0.002799399895593524,
        0.002817800035700202,
        0.002836399944499135,
        0.0028550000861287117,
        0.0028737999964505434,
        0.002892599906772375,
        0.002911600051447749,
        0.0029305999632924795,
        0.0029498001094907522,
        0.0029690000228583813,
        0.002988399937748909,
        0.0030078000854700804,
        0.0030274000018835068,
        0.003046999918296933,
        0.003066800069063902,
        0.003086599987000227,
        0.0031065999064594507,
        0.003126600058749318,
        0.0031467999797314405,
        0.003166999900713563,
        0.0031874000560492277,
        0.00320790009573102,
        0.0032283999025821686,
        0.0032490999437868595,
        0.0032697999849915504,
        0.00329070002771914,
        0.0033116000704467297,
        0.003332700114697218,
        0.0033539000432938337,
        0.0033750999718904495,
        0.003396499902009964,
        0.0034179999493062496,
        0.0034394999966025352,
        0.0034612000454217196,
        0.003482900094240904,
        0.003504799911752343,
        0.0035268000792711973,
        0.003548800013959408,
        0.003570999950170517,
        0.0035933000035583973,
        0.0036156000569462776,
        0.0036381001118570566,
        0.003660700051113963,
        0.003683400107547641,
        0.003706099931150675,
        0.003728999989107251,
        0.003751999931409955,
        0.0037750001065433025,
        0.003798200050368905,
        0.0038215001113712788,
        0.00384490005671978,
        0.003868300002068281,
        0.003891899948939681,
        0.003915600012987852,
        0.003939399961382151,
        0.003963199909776449,
        0.00398720009252429,
        0.004011299926787615,
        0.004035499878227711,
        0.004059799946844578,
        0.004084100015461445,
        0.004108599852770567,
        0.00413319980725646,
        0.004157899878919125,
        0.00418270006775856,
        0.0042074997909367085,
        0.004232500214129686,
        0.004257599823176861,
        0.004282800015062094,
        0.0043080998584628105,
        0.0043334998190402985,
        0.004358899779617786,
        0.004384499974548817,
        0.004410199820995331,
        0.004435999784618616,
        0.0044618998654186726,
        0.0044879000633955,
        0.004513999912887812,
        0.004540199879556894,
        0.004566499963402748,
        0.004592900164425373,
        0.004619299899786711,
        0.004645899869501591,
        0.004672599956393242,
        0.004699400160461664,
        0.00472630001604557,
        0.004753299988806248,
        0.004780400078743696,
        0.004807599820196629,
        0.004834900144487619,
        0.004862300120294094,
        0.00488980021327734,
        0.00491739995777607,
        0.0049450998194515705,
        0.0049728997983038425,
        0.005000799894332886,
        0.0050288001075387,
        0.005056899972259998,
        0.005085099954158068,
        0.005113400053232908,
        0.005141799803823233,
        0.0051703001372516155,
        0.005198900122195482,
        0.00522760022431612,
        0.005256399977952242,
        0.005285299848765135,
        0.005314299836754799,
        0.005343399941921234,
        0.0053726001642644405,
        0.005402000155299902,
        0.005431400146335363,
        0.005460899788886309,
        0.005490500014275312,
        0.0055201998911798,
        0.005549999885261059,
        0.005579899996519089,
        0.00560990022495389,
        0.005640000104904175,
        0.005670300219208002,
        0.005700599867850542,
        0.0057310000993311405,
        0.005761499982327223,
        0.005792099982500076,
        0.005822800099849701,
        0.005853699985891581,
        0.00588459987193346,
        0.005915599875152111,
        0.005946699995547533,
        0.005977899767458439,
        0.006009200122207403,
        0.006040699779987335,
        0.0060721999034285545,
        0.006103800144046545,
        0.006135500036180019,
        0.006167400162667036,
        0.006199299823492765,
        0.006231300067156553,
        0.006263399962335825,
        0.006295700091868639,
        0.006328000221401453,
        0.006360400002449751,
        0.00639289990067482,
        0.006425600033253431,
        0.006458300165832043,
        0.006491099949926138,
        0.006523999851197004,
        0.006557099986821413,
        0.006590200122445822,
        0.006623399909585714,
        0.006656799931079149,
        0.006690199952572584,
        0.00672370009124279,
        0.006757399998605251,
        0.006791099905967712,
        0.006824899930506945,
        0.006858900189399719,
        0.0068928999826312065,
        0.006926999893039465,
        0.006961300037801266,
        0.0069956001825630665,
        0.007030100096017122,
        0.007064600009471178,
        0.007099200040102005,
        0.007133999839425087,
        0.007168800104409456,
        0.0072038001380860806,
        0.007238800171762705,
        0.007273899856954813,
        0.0073091997765004635,
        0.007344500161707401,
        0.007379999849945307,
        0.0074155000038445,
        0.007451199926435947,
        0.007486899849027395,
        0.007522800005972385,
        0.0075587001629173756,
        0.00759469997137785,
        0.007630900014191866,
        0.007667100057005882,
        0.007703499868512154,
        0.007739900145679712,
        0.007776500191539526,
        0.007813099771738052,
        0.007849900051951408,
        0.007886700332164764,
        0.007923699915409088,
        0.00796080008149147,
        0.007997900247573853,
        0.008035199716687202,
        0.008072500117123127,
        0.00810999982059002,
        0.008147500455379486,
        0.00818520039319992,
        0.008222900331020355,
        0.008260799571871758,
        0.008298800326883793,
        0.008336800150573254,
        0.008375000208616257,
        0.00841320026665926,
        0.00845159962773323,
        0.00849009957164526,
        0.008528600446879864,
        0.008585699833929539,
        0.008934300392866135,
        0.009270300157368183,
        0.009593700058758259,
        0.00990429986268282,
        0.010201999917626381,
        0.010487999767065048,
        0.010759999975562096,
        0.01102100033313036,
        0.01126800011843443,
        0.011502999812364578,
        0.011725000105798244,
        0.011934000067412853,
        0.012130999937653542,
        0.012315000407397747,
        0.012486999854445457,
        0.012644999660551548,
        0.012791999615728855,
        0.012924999929964542,
        0.01304600015282631,
        0.013154000043869019,
        0.013249999843537807,
        0.013333000242710114,
        0.013403000310063362,
        0.013460000045597553,
        0.013504999689757824,
        0.013538000173866749,
        0.01355700008571148,
        0.013563999906182289,
        0.013558999635279179,
        0.013539999723434448,
        0.013508999720215797,
        0.013465999625623226,
        0.013408999890089035,
        0.013341999612748623,
        0.013264999724924564,
        0.01317800022661686,
        0.013082999736070633,
        0.01297799963504076,
        0.012864000163972378,
        0.012741000391542912,
        0.012609000317752361,
        0.012467999942600727,
        0.012316999956965446,
        0.012156999669969082,
        0.011988000012934208,
        0.011808999814093113,
        0.011621999554336071,
        0.011424999684095383,
        0.011219000443816185,
        0.011003999970853329,
        0.010778999887406826,
        0.010545000433921814,
        0.01030299998819828,
        0.010049999691545963,
        0.009789000265300274,
        0.009518399834632874,
        0.009238599799573421,
        0.008949600160121918,
        0.008651300333440304,
        0.008343899622559547,
        0.009083200246095657,
        0.012295999564230442,
        0.015174999833106995,
        0.01772099919617176,
        0.019933000206947327,
        0.02181199938058853,
        0.023358000442385674,
        0.024569999426603317,
        0.025449000298976898,
        0.02599399909377098,
        0.026205999776721,
        0.02608500048518181,
        0.025629999116063118,
        0.024840999394655228,
        0.023719999939203262,
        0.02226400002837181,
        0.020476000383496284,
        0.01835400052368641,
        0.015898000448942184,
        0.013109000399708748,
        0.009987100027501583,
        0.008791600354015827,
        0.010122999548912048,
        0.011353000067174435,
        0.012481999583542347,
        0.013511000201106071,
        0.014437999576330185,
        0.01526500005275011,
        0.015990000218153,
        0.016614999622106552,
        0.017138000577688217,
        0.01756099984049797,
        0.017882000654935837,
        0.01810299977660179,
        0.018223000690340996,
        0.018240999430418015,
        0.01815900020301342,
        0.017976000905036926,
        0.017691999673843384,
        0.017305999994277954,
        0.016820000484585762,
        0.01623300090432167,
        0.015545000322163105,
        0.01475599966943264,
        0.01386599987745285,
        0.012875000014901161,
        0.011783000081777573,
        0.010590000078082085,
        0.009296299889683723,
        0.007901499979197979,
        0.006405699998140335,
        0.004808899946510792,
        0.0031111999414861202,
        0.001312499982304871,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        2.739400088103139e-06,
        6.88579966663383e-05,
        0.00022324000019580126,
        0.0004658699908759445,
        0.0007967699784785509,
        0.0012158999452367425,
        0.0017232999671250582,
        0.0023189999628812075,
        0.003002899931743741,
        0.00377509999088943,
        0.004635599907487631,
        0.00558430003002286,
        0.006621200125664473,
        0.007746399845927954,
        0.00864730030298233,
        0.008746299892663956,
        0.008841600269079208,
        0.008933099918067455,
        0.009020799770951271,
        0.009104699827730656,
        0.009184800088405609,
        0.009261200204491615,
        0.009333799593150616,
        0.00940260011702776,
        0.009467599913477898,
        0.009528899565339088,
        0.009586299769580364,
        0.009639999829232693,
        0.010389000177383423,
        0.011195999570190907,
        0.011982000432908535,
        0.012748000212013721,
        0.01349399983882904,
        0.01421900000423193,
        0.014924000017344952,
        0.015610000118613243,
        0.016273999586701393,
        0.016919000074267387,
        0.017542999237775803,
        0.018147999420762062,
        0.01873200014233589,
        0.01929599978029728,
        0.019838999956846237,
        0.020362000912427902,
        0.020865999162197113,
        0.021348999813199043,
        0.021810999140143394,
        0.02225399948656559,
        0.022676000371575356,
        0.02307800017297268,
        0.02346000075340271,
        0.0238220002502203,
        0.024163000285625458,
        0.024483999237418175,
        0.024785000830888748,
        0.02506599947810173,
        0.02532700076699257,
        0.02556700073182583,
        0.025786999613046646,
        0.02598699927330017,
        0.026166999712586403,
        0.026326000690460205,
        0.026465000584721565,
        0.026583999395370483,
        0.026683000847697258,
        0.02676199935376644,
        0.026820000261068344,
        0.026858000084757805,
        0.026876000687479973,
        0.0268740002065897,
        0.026852000504732132,
        0.026808999478816986,
        0.026745999231934547,
        0.026662999764084816,
        0.026559999212622643,
        0.02643599919974804,
        0.026291999965906143,
        0.026127999648451805,
        0.025944000110030174,
        0.0257399994879961,
        0.0255149994045496,
        0.025270000100135803,
        0.025004999712109566,
        0.024720000103116035,
        0.024413999170064926,
        0.02408899925649166,
        0.023742999881505966,
        0.02337699942290783,
        0.022989999502897263,
        0.02258400060236454,
        0.02215700037777424,
        0.021709999069571495,
        0.021402999758720398,
        0.02128100022673607,
        0.021157000213861465,
        0.021030999720096588,
        0.020903000608086586,
        0.020773999392986298,
        0.020641999319195747,
        0.02050900086760521,
        0.020374000072479248,
        0.0202380008995533,
        0.02009899914264679,
        0.01995900087058544,
        0.01981700025498867,
        0.019673999398946762,
        0.019527999684214592,
        0.019380999729037285,
        0.019231999292969704,
        0.019081000238656998,
        0.018928000703454018,
        0.0187740009278059,
        0.01861800067126751,
        0.018459999933838844,
        0.018300000578165054,
        0.01813800074160099,
        0.01797500066459179,
        0.017810000106692314,
        0.017643000930547714,
        0.017474999651312828,
        0.01730399951338768,
        0.017131999135017395,
        0.016958000138401985,
        0.0167820006608963,
        0.01660499908030033,
        0.016426000744104385,
        0.016245000064373016,
        0.016062000766396523,
        0.015876999124884605,
        0.0156909991055727,
        0.015502000227570534,
        0.015313000418245792,
        0.01512099988758564,
        0.014926999807357788,
        0.014732000418007374,
        0.014534999616444111,
        0.014336000196635723,
        0.014135999605059624,
        0.013933000154793262,
        0.013729000464081764,
        0.013523000292479992,
        0.013314999639987946,
        0.013105999678373337,
        0.012893999926745892,
        0.01268099993467331,
        0.012466000393033028,
        0.012245000340044498,
        0.012020000256597996,
        0.011796999722719193,
        0.011575999669730663,
        0.011357000097632408,
        0.011140000075101852,
        0.010925999842584133,
        0.010712999850511551,
        0.010502999648451805,
        0.010293999686837196,
        0.010088000446557999,
        0.009883900173008442,
        0.00968180038034916,
        0.00948179978877306,
        0.009283900260925293,
        0.00908809993416071,
        0.008894399739801884,
        0.008702700026333332,
        0.008513100445270538,
        0.008325699716806412,
        0.008140300400555134,
        0.00795700028538704,
        0.007775799836963415,
        0.007596599869430065,
        0.007419600151479244,
        0.007244700100272894,
        0.00707180006429553,
        0.006901000160723925,
        0.0067322999238967896,
        0.006565699819475412,
        0.006401199847459793,
        0.006238800007849932,
        0.006078400183469057,
        0.005920200143009424,
        0.005764000117778778,
        0.005609999876469374,
        0.005458000116050243,
        0.005308100022375584,
        0.005160199943929911,
        0.005014500115066767,
        0.004870899952948093,
        0.004729299806058407,
        0.004589899908751249,
        0.0044525000266730785,
        0.004317199811339378,
        0.004184000194072723,
        0.004052899777889252,
        0.003923799842596054,
        0.003796899924054742,
        0.0036720000207424164,
        0.0035492999013513327,
        0.0034286000300198793,
        0.0033100000582635403,
        0.0031934999860823154,
        0.0030791000463068485,
        0.0029666998889297247,
        0.00285649998113513,
        0.002748300088569522,
        0.0026422999799251556,
        0.002538299886509776,
        0.0024363999255001545,
        0.0023366000968962908,
        0.0022388999350368977,
        0.002143200021237135,
        0.002049699891358614,
        0.0019582000095397234,
        0.001868800027295947,
        0.0017815999453887343,
        0.0016963999951258302,
        0.0016132999444380403,
        0.001532200025394559,
        0.0014533000066876411,
        0.0013765000039711595,
        0.0013017000164836645,
        0.0012290000449866056,
        0.001158399973064661,
        0.0010899000335484743,
        0.0010234999936074018,
        0.0009592099813744426,
        0.0008969699847511947,
        0.0008368199924007058,
        0.0007787600043229759,
        0.0007227900205180049,
        0.0006688999710604548,
        0.0006170999840833247,
        0.0005673900013789535,
        0.0005197600112296641,
        0.00047423000796698034,
        0.00043077999725937843,
        0.00038941000821068883,
        0.00035014000604860485,
        0.0003129499964416027,
        0.00027784999110735953,
        0.0002448399900458753,
        0.00021390999609138817,
        0.00018507000640965998,
        0.00015832000644877553,
        0.0001336599962087348,
        0.00011108000035164878,
        9.059000149136409e-05,
        7.218700193334371e-05,
        5.587199848378077e-05,
        4.1644998418632895e-05,
        2.9504000849556178e-05,
        1.9450999388936907e-05,
        1.1486000403237995e-05,
        5.607399998552864e-06,
        1.816300027712714e-06,
        1.1261000310014424e-07,
        0.0,
    ],
    "frequency": [
        -313.8999938964844,
        -312.8999938964844,
        -311.8999938964844,
        -310.8999938964844,
        -309.8999938964844,
        -308.8999938964844,
        -307.8999938964844,
        -306.8999938964844,
        -305.8999938964844,
        -304.8999938964844,
        -303.8999938964844,
        -302.8999938964844,
        -301.8999938964844,
        -300.8999938964844,
        -299.8999938964844,
        -298.8999938964844,
        -297.8999938964844,
        -296.8999938964844,
        -295.8999938964844,
        -294.8999938964844,
        -293.8999938964844,
        -292.8999938964844,
        -291.8999938964844,
        -290.8999938964844,
        -289.8999938964844,
        -288.8999938964844,
        -287.8999938964844,
        -286.8999938964844,
        -285.8999938964844,
        -284.8999938964844,
        -283.8999938964844,
        -282.8999938964844,
        -281.8999938964844,
        -280.8999938964844,
        -279.8999938964844,
        -278.8999938964844,
        -277.8999938964844,
        -276.8999938964844,
        -275.8999938964844,
        -274.8999938964844,
        -273.8999938964844,
        -272.8999938964844,
        -271.8999938964844,
        -270.8999938964844,
        -269.8999938964844,
        -268.8999938964844,
        -267.8999938964844,
        -266.8999938964844,
        -265.8999938964844,
        -264.8999938964844,
        -263.8999938964844,
        -262.8999938964844,
        -261.8999938964844,
        -260.8999938964844,
        -259.8999938964844,
        -258.8999938964844,
        -257.8999938964844,
        -256.8999938964844,
        -255.89999389648438,
        -254.89999389648438,
        -253.89999389648438,
        -252.89999389648438,
        -251.89999389648438,
        -250.89999389648438,
        -249.89999389648438,
        -248.89999389648438,
        -247.89999389648438,
        -246.89999389648438,
        -245.89999389648438,
        -244.89999389648438,
        -243.89999389648438,
        -242.89999389648438,
        -241.89999389648438,
        -240.89999389648438,
        -239.89999389648438,
        -238.89999389648438,
        -237.89999389648438,
        -236.89999389648438,
        -235.89999389648438,
        -234.89999389648438,
        -233.89999389648438,
        -232.89999389648438,
        -231.89999389648438,
        -230.89999389648438,
        -229.89999389648438,
        -228.89999389648438,
        -227.89999389648438,
        -226.89999389648438,
        -225.89999389648438,
        -224.89999389648438,
        -223.89999389648438,
        -222.89999389648438,
        -221.89999389648438,
        -220.89999389648438,
        -219.89999389648438,
        -218.89999389648438,
        -217.89999389648438,
        -216.89999389648438,
        -215.89999389648438,
        -214.89999389648438,
        -213.89999389648438,
        -212.89999389648438,
        -211.89999389648438,
        -210.89999389648438,
        -209.89999389648438,
        -208.89999389648438,
        -207.89999389648438,
        -206.89999389648438,
        -205.89999389648438,
        -204.89999389648438,
        -203.89999389648438,
        -202.89999389648438,
        -201.89999389648438,
        -200.89999389648438,
        -199.89999389648438,
        -198.89999389648438,
        -197.89999389648438,
        -196.89999389648438,
        -195.89999389648438,
        -194.89999389648438,
        -193.89999389648438,
        -192.89999389648438,
        -191.89999389648438,
        -190.89999389648438,
        -189.89999389648438,
        -188.89999389648438,
        -187.89999389648438,
        -186.89999389648438,
        -185.89999389648438,
        -184.89999389648438,
        -183.89999389648438,
        -182.89999389648438,
        -181.89999389648438,
        -180.89999389648438,
        -179.89999389648438,
        -178.89999389648438,
        -177.89999389648438,
        -176.89999389648438,
        -175.89999389648438,
        -174.89999389648438,
        -173.89999389648438,
        -172.89999389648438,
        -171.89999389648438,
        -170.89999389648438,
        -169.89999389648438,
        -168.89999389648438,
        -167.89999389648438,
        -166.89999389648438,
        -165.89999389648438,
        -164.89999389648438,
        -163.89999389648438,
        -162.89999389648438,
        -161.89999389648438,
        -160.89999389648438,
        -159.89999389648438,
        -158.89999389648438,
        -157.89999389648438,
        -156.89999389648438,
        -155.89999389648438,
        -154.89999389648438,
        -153.89999389648438,
        -152.89999389648438,
        -151.89999389648438,
        -150.89999389648438,
        -149.89999389648438,
        -148.89999389648438,
        -147.89999389648438,
        -146.89999389648438,
        -145.89999389648438,
        -144.89999389648438,
        -143.89999389648438,
        -142.89999389648438,
        -141.89999389648438,
        -140.89999389648438,
        -139.89999389648438,
        -138.89999389648438,
        -137.89999389648438,
        -136.89999389648438,
        -135.89999389648438,
        -134.89999389648438,
        -133.89999389648438,
        -132.89999389648438,
        -131.89999389648438,
        -130.89999389648438,
        -129.89999389648438,
        -128.89999389648438,
        -127.9000015258789,
        -126.9000015258789,
        -125.9000015258789,
        -124.9000015258789,
        -123.9000015258789,
        -122.9000015258789,
        -121.9000015258789,
        -120.9000015258789,
        -119.9000015258789,
        -118.9000015258789,
        -117.9000015258789,
        -116.9000015258789,
        -115.9000015258789,
        -114.9000015258789,
        -113.9000015258789,
        -112.9000015258789,
        -111.9000015258789,
        -110.9000015258789,
        -109.9000015258789,
        -108.9000015258789,
        -107.9000015258789,
        -106.9000015258789,
        -105.9000015258789,
        -104.9000015258789,
        -103.9000015258789,
        -102.9000015258789,
        -101.9000015258789,
        -100.9000015258789,
        -99.9000015258789,
        -98.9000015258789,
        -97.9000015258789,
        -96.9000015258789,
        -95.9000015258789,
        -94.9000015258789,
        -93.9000015258789,
        -92.9000015258789,
        -91.9000015258789,
        -90.9000015258789,
        -89.9000015258789,
        -88.9000015258789,
        -87.9000015258789,
        -86.9000015258789,
        -85.9000015258789,
        -84.9000015258789,
        -83.9000015258789,
        -82.9000015258789,
        -81.9000015258789,
        -80.9000015258789,
        -79.9000015258789,
        -78.9000015258789,
        -77.9000015258789,
        -76.9000015258789,
        -75.9000015258789,
        -74.9000015258789,
        -73.9000015258789,
        -72.9000015258789,
        -71.9000015258789,
        -70.9000015258789,
        -69.9000015258789,
        -68.9000015258789,
        -67.9000015258789,
        -66.9000015258789,
        -65.9000015258789,
        -64.9000015258789,
        -63.900001525878906,
        -62.900001525878906,
        -61.900001525878906,
        -60.900001525878906,
        -59.900001525878906,
        -58.900001525878906,
        -57.900001525878906,
        -56.900001525878906,
        -55.900001525878906,
        -54.900001525878906,
        -53.900001525878906,
        -52.900001525878906,
        -51.900001525878906,
        -50.900001525878906,
        -49.900001525878906,
        -48.900001525878906,
        -47.900001525878906,
        -46.900001525878906,
        -45.900001525878906,
        -44.900001525878906,
        -43.900001525878906,
        -42.900001525878906,
        -41.900001525878906,
        -40.900001525878906,
        -39.900001525878906,
        -38.900001525878906,
        -37.900001525878906,
        -36.900001525878906,
        -35.900001525878906,
        -34.900001525878906,
        -33.900001525878906,
        -32.900001525878906,
        -31.899999618530273,
        -30.899999618530273,
        -29.899999618530273,
        -28.899999618530273,
        -27.899999618530273,
        -26.899999618530273,
        -25.899999618530273,
        -24.899999618530273,
        -23.899999618530273,
        -22.899999618530273,
        -21.899999618530273,
        -20.899999618530273,
        -19.899999618530273,
        -18.899999618530273,
        -17.899999618530273,
        -16.899999618530273,
        -15.899999618530273,
        -14.899999618530273,
        -13.899999618530273,
        -12.899999618530273,
        -11.899999618530273,
        -10.899999618530273,
        -9.899700164794922,
        -8.899700164794922,
        -7.899700164794922,
        -6.899700164794922,
        -5.899700164794922,
        -4.899700164794922,
        -3.8996999263763428,
        -2.8996999263763428,
        -1.8997000455856323,
        -0.8997099995613098,
        0.10029000043869019,
        1.1002999544143677,
        2.1003000736236572,
        3.1003000736236572,
        4.100299835205078,
        5.100299835205078,
        6.100299835205078,
        7.100299835205078,
        8.100299835205078,
        9.100299835205078,
        10.100000381469727,
        11.100000381469727,
        12.100000381469727,
        13.100000381469727,
        14.100000381469727,
        15.100000381469727,
        16.100000381469727,
        17.100000381469727,
        18.100000381469727,
        19.100000381469727,
        20.100000381469727,
        21.100000381469727,
        22.100000381469727,
        23.100000381469727,
        24.100000381469727,
        25.100000381469727,
        26.100000381469727,
        27.100000381469727,
        28.100000381469727,
        29.100000381469727,
        30.100000381469727,
        31.100000381469727,
        32.099998474121094,
        33.099998474121094,
        34.099998474121094,
        35.099998474121094,
        36.099998474121094,
        37.099998474121094,
        38.099998474121094,
        39.099998474121094,
        40.099998474121094,
        41.099998474121094,
        42.099998474121094,
        43.099998474121094,
        44.099998474121094,
        45.099998474121094,
        46.099998474121094,
        47.099998474121094,
        48.099998474121094,
        49.099998474121094,
        50.099998474121094,
        51.099998474121094,
        52.099998474121094,
        53.099998474121094,
        54.099998474121094,
        55.099998474121094,
        56.099998474121094,
        57.099998474121094,
        58.099998474121094,
        59.099998474121094,
        60.099998474121094,
        61.099998474121094,
        62.099998474121094,
        63.099998474121094,
        64.0999984741211,
        65.0999984741211,
        66.0999984741211,
        67.0999984741211,
        68.0999984741211,
        69.0999984741211,
        70.0999984741211,
        71.0999984741211,
        72.0999984741211,
        73.0999984741211,
        74.0999984741211,
        75.0999984741211,
        76.0999984741211,
        77.0999984741211,
        78.0999984741211,
        79.0999984741211,
        80.0999984741211,
        81.0999984741211,
        82.0999984741211,
        83.0999984741211,
        84.0999984741211,
        85.0999984741211,
        86.0999984741211,
        87.0999984741211,
        88.0999984741211,
        89.0999984741211,
        90.0999984741211,
        91.0999984741211,
        92.0999984741211,
        93.0999984741211,
        94.0999984741211,
        95.0999984741211,
        96.0999984741211,
        97.0999984741211,
        98.0999984741211,
        99.0999984741211,
        100.0999984741211,
        101.0999984741211,
        102.0999984741211,
        103.0999984741211,
        104.0999984741211,
        105.0999984741211,
        106.0999984741211,
        107.0999984741211,
        108.0999984741211,
        109.0999984741211,
        110.0999984741211,
        111.0999984741211,
        112.0999984741211,
        113.0999984741211,
        114.0999984741211,
        115.0999984741211,
        116.0999984741211,
        117.0999984741211,
        118.0999984741211,
        119.0999984741211,
        120.0999984741211,
        121.0999984741211,
        122.0999984741211,
        123.0999984741211,
        124.0999984741211,
        125.0999984741211,
        126.0999984741211,
        127.0999984741211,
        128.10000610351562,
        129.10000610351562,
        130.10000610351562,
        131.10000610351562,
        132.10000610351562,
        133.10000610351562,
        134.10000610351562,
        135.10000610351562,
        136.10000610351562,
        137.10000610351562,
        138.10000610351562,
        139.10000610351562,
        140.10000610351562,
        141.10000610351562,
        142.10000610351562,
        143.10000610351562,
        144.10000610351562,
        145.10000610351562,
        146.10000610351562,
        147.10000610351562,
        148.10000610351562,
        149.10000610351562,
        150.10000610351562,
        151.10000610351562,
        152.10000610351562,
        153.10000610351562,
        154.10000610351562,
        155.10000610351562,
        156.10000610351562,
        157.10000610351562,
        158.10000610351562,
        159.10000610351562,
        160.10000610351562,
        161.10000610351562,
        162.10000610351562,
        163.10000610351562,
        164.10000610351562,
        165.10000610351562,
        166.10000610351562,
        167.10000610351562,
        168.10000610351562,
        169.10000610351562,
        170.10000610351562,
        171.10000610351562,
        172.10000610351562,
        173.10000610351562,
        174.10000610351562,
        175.10000610351562,
        176.10000610351562,
        177.10000610351562,
        178.10000610351562,
        179.10000610351562,
        180.10000610351562,
        181.10000610351562,
        182.10000610351562,
        183.10000610351562,
        184.10000610351562,
        185.10000610351562,
        186.10000610351562,
        187.10000610351562,
        188.10000610351562,
        189.10000610351562,
        190.10000610351562,
        191.10000610351562,
        192.10000610351562,
        193.10000610351562,
        194.10000610351562,
        195.10000610351562,
        196.10000610351562,
        197.10000610351562,
        198.10000610351562,
        199.10000610351562,
        200.10000610351562,
        201.10000610351562,
        202.10000610351562,
        203.10000610351562,
        204.10000610351562,
        205.10000610351562,
        206.10000610351562,
        207.10000610351562,
        208.10000610351562,
        209.10000610351562,
        210.10000610351562,
        211.10000610351562,
        212.10000610351562,
        213.10000610351562,
        214.10000610351562,
        215.10000610351562,
        216.10000610351562,
        217.10000610351562,
        218.10000610351562,
        219.10000610351562,
        220.10000610351562,
        221.10000610351562,
        222.10000610351562,
        223.10000610351562,
        224.10000610351562,
        225.10000610351562,
        226.10000610351562,
        227.10000610351562,
        228.10000610351562,
        229.10000610351562,
        230.10000610351562,
        231.10000610351562,
        232.10000610351562,
        233.10000610351562,
        234.10000610351562,
        235.10000610351562,
        236.10000610351562,
        237.10000610351562,
        238.10000610351562,
        239.10000610351562,
        240.10000610351562,
        241.10000610351562,
        242.10000610351562,
        243.10000610351562,
        244.10000610351562,
        245.10000610351562,
        246.10000610351562,
        247.10000610351562,
        248.10000610351562,
        249.10000610351562,
        250.10000610351562,
        251.10000610351562,
        252.10000610351562,
        253.10000610351562,
        254.10000610351562,
        255.10000610351562,
        256.1000061035156,
        257.1000061035156,
        258.1000061035156,
        259.1000061035156,
        260.1000061035156,
        261.1000061035156,
        262.1000061035156,
        263.1000061035156,
        264.1000061035156,
        265.1000061035156,
        266.1000061035156,
        267.1000061035156,
        268.1000061035156,
        269.1000061035156,
        270.1000061035156,
        271.1000061035156,
        272.1000061035156,
        273.1000061035156,
        274.1000061035156,
        275.1000061035156,
        276.1000061035156,
        277.1000061035156,
        278.1000061035156,
        279.1000061035156,
        280.1000061035156,
        281.1000061035156,
        282.1000061035156,
        283.1000061035156,
        284.1000061035156,
        285.1000061035156,
        286.1000061035156,
        287.1000061035156,
        288.1000061035156,
        289.1000061035156,
        290.1000061035156,
        291.1000061035156,
        292.1000061035156,
        293.1000061035156,
        294.1000061035156,
        295.1000061035156,
        296.1000061035156,
        297.1000061035156,
        298.1000061035156,
        299.1000061035156,
        300.1000061035156,
        301.1000061035156,
        302.1000061035156,
        303.1000061035156,
        304.1000061035156,
        305.1000061035156,
        306.1000061035156,
        307.1000061035156,
        308.1000061035156,
        309.1000061035156,
        310.1000061035156,
        311.1000061035156,
        312.1000061035156,
        313.1000061035156,
        314.1000061035156,
        315.1000061035156,
        316.1000061035156,
        317.1000061035156,
        318.1000061035156,
        319.1000061035156,
        320.1000061035156,
        321.1000061035156,
        322.1000061035156,
        323.1000061035156,
        324.1000061035156,
        325.1000061035156,
        326.1000061035156,
        327.1000061035156,
        328.1000061035156,
        329.1000061035156,
        330.1000061035156,
        331.1000061035156,
        332.1000061035156,
        333.1000061035156,
        334.1000061035156,
        335.1000061035156,
        336.1000061035156,
        337.1000061035156,
        338.1000061035156,
        339.1000061035156,
        340.1000061035156,
        341.1000061035156,
        342.1000061035156,
        343.1000061035156,
        344.1000061035156,
        345.1000061035156,
        346.1000061035156,
        347.1000061035156,
        348.1000061035156,
        349.1000061035156,
        350.1000061035156,
        351.1000061035156,
        352.1000061035156,
        353.1000061035156,
        354.1000061035156,
        355.1000061035156,
        356.1000061035156,
        357.1000061035156,
        358.1000061035156,
        359.1000061035156,
        360.1000061035156,
        361.1000061035156,
        362.1000061035156,
        363.1000061035156,
        364.1000061035156,
        365.1000061035156,
        366.1000061035156,
        367.1000061035156,
        368.1000061035156,
        369.1000061035156,
        370.1000061035156,
        371.1000061035156,
        372.1000061035156,
        373.1000061035156,
        374.1000061035156,
        375.1000061035156,
        376.1000061035156,
        377.1000061035156,
        378.1000061035156,
        379.1000061035156,
        380.1000061035156,
        381.1000061035156,
        382.1000061035156,
        383.1000061035156,
        384.1000061035156,
        385.1000061035156,
        386.1000061035156,
        387.1000061035156,
        388.1000061035156,
        389.1000061035156,
        390.1000061035156,
        391.1000061035156,
        392.1000061035156,
        393.1000061035156,
        394.1000061035156,
        395.1000061035156,
        396.1000061035156,
        397.1000061035156,
        398.1000061035156,
        399.1000061035156,
        400.1000061035156,
        401.1000061035156,
        402.1000061035156,
        403.1000061035156,
        404.1000061035156,
        405.1000061035156,
        406.1000061035156,
        407.1000061035156,
        408.1000061035156,
        409.1000061035156,
        410.1000061035156,
        411.1000061035156,
        412.1000061035156,
        413.1000061035156,
        414.1000061035156,
        415.1000061035156,
        416.1000061035156,
        417.1000061035156,
        418.1000061035156,
        419.1000061035156,
        420.1000061035156,
        421.1000061035156,
        422.1000061035156,
        423.1000061035156,
        424.1000061035156,
        425.1000061035156,
        426.1000061035156,
        427.1000061035156,
        428.1000061035156,
        429.1000061035156,
        430.1000061035156,
        431.1000061035156,
        432.1000061035156,
        433.1000061035156,
        434.1000061035156,
        435.1000061035156,
        436.1000061035156,
        437.1000061035156,
        438.1000061035156,
        439.1000061035156,
        440.1000061035156,
        441.1000061035156,
        442.1000061035156,
        443.1000061035156,
        444.1000061035156,
        445.1000061035156,
        446.1000061035156,
        447.1000061035156,
        448.1000061035156,
        449.1000061035156,
        450.1000061035156,
        451.1000061035156,
        452.1000061035156,
        453.1000061035156,
        454.1000061035156,
        455.1000061035156,
        456.1000061035156,
        457.1000061035156,
        458.1000061035156,
        459.1000061035156,
        460.1000061035156,
        461.1000061035156,
        462.1000061035156,
        463.1000061035156,
        464.1000061035156,
        465.1000061035156,
        466.1000061035156,
        467.1000061035156,
        468.1000061035156,
        469.1000061035156,
        470.1000061035156,
        471.1000061035156,
        472.1000061035156,
        473.1000061035156,
        474.1000061035156,
        475.1000061035156,
        476.1000061035156,
        477.1000061035156,
        478.1000061035156,
        479.1000061035156,
        480.1000061035156,
        481.1000061035156,
        482.1000061035156,
        483.1000061035156,
        484.1000061035156,
        485.1000061035156,
        486.1000061035156,
        487.1000061035156,
        488.1000061035156,
        489.1000061035156,
        490.1000061035156,
        491.1000061035156,
        492.1000061035156,
        493.1000061035156,
        494.1000061035156,
        495.1000061035156,
        496.1000061035156,
        497.1000061035156,
        498.1000061035156,
        499.1000061035156,
        500.1000061035156,
        501.1000061035156,
        502.1000061035156,
        503.1000061035156,
        504.1000061035156,
        505.1000061035156,
        506.1000061035156,
        507.1000061035156,
        508.1000061035156,
        509.1000061035156,
        510.1000061035156,
        511.1000061035156,
        512.0999755859375,
        513.0999755859375,
        514.0999755859375,
        515.0999755859375,
        516.0999755859375,
        517.0999755859375,
        518.0999755859375,
        519.0999755859375,
        520.0999755859375,
        521.0999755859375,
        522.0999755859375,
        523.0999755859375,
        524.0999755859375,
        525.0999755859375,
        526.0999755859375,
        527.0999755859375,
        528.0999755859375,
        529.0999755859375,
        530.0999755859375,
        531.0999755859375,
        532.0999755859375,
        533.0999755859375,
        534.0999755859375,
        535.0999755859375,
        536.0999755859375,
        537.0999755859375,
        538.0999755859375,
        539.0999755859375,
        540.0999755859375,
        541.0999755859375,
        542.0999755859375,
        543.0999755859375,
        544.0999755859375,
        545.0999755859375,
        546.0999755859375,
        547.0999755859375,
        548.0999755859375,
        549.0999755859375,
        550.0999755859375,
        551.0999755859375,
        552.0999755859375,
        553.0999755859375,
        554.0999755859375,
        555.0999755859375,
        556.0999755859375,
        557.0999755859375,
        558.0999755859375,
        559.0999755859375,
        560.0999755859375,
        561.0999755859375,
        562.0999755859375,
        563.0999755859375,
        564.0999755859375,
        565.0999755859375,
        566.0999755859375,
        567.0999755859375,
        568.0999755859375,
        569.0999755859375,
        570.0999755859375,
        571.0999755859375,
        572.0999755859375,
        573.0999755859375,
        574.0999755859375,
        575.0999755859375,
        576.0999755859375,
        577.0999755859375,
        578.0999755859375,
        579.0999755859375,
        580.0999755859375,
        581.0999755859375,
        582.0999755859375,
        583.0999755859375,
        584.0999755859375,
        585.0999755859375,
        586.0999755859375,
        587.0999755859375,
        588.0999755859375,
        589.0999755859375,
        590.0999755859375,
        591.0999755859375,
        592.0999755859375,
        593.0999755859375,
        594.0999755859375,
        595.0999755859375,
        596.0999755859375,
        597.0999755859375,
        598.0999755859375,
        599.0999755859375,
        600.0999755859375,
        601.0999755859375,
        602.0999755859375,
        603.0999755859375,
        604.0999755859375,
        605.0999755859375,
        606.0999755859375,
        607.0999755859375,
        608.0999755859375,
        609.0999755859375,
        610.0999755859375,
        611.0999755859375,
        612.0999755859375,
        613.0999755859375,
        614.0999755859375,
        615.0999755859375,
        616.0999755859375,
        617.0999755859375,
        618.0999755859375,
        619.0999755859375,
        620.0999755859375,
        621.0999755859375,
        622.0999755859375,
        623.0999755859375,
        624.0999755859375,
        625.0999755859375,
        626.0999755859375,
        627.0999755859375,
        628.0999755859375,
        629.0999755859375,
        630.0999755859375,
        631.0999755859375,
        632.0999755859375,
        633.0999755859375,
        634.0999755859375,
        635.0999755859375,
        636.0999755859375,
        637.0999755859375,
        638.0999755859375,
        639.0999755859375,
        640.0999755859375,
        641.0999755859375,
        642.0999755859375,
        643.0999755859375,
        644.0999755859375,
        645.0999755859375,
        646.0999755859375,
        647.0999755859375,
        648.0999755859375,
        649.0999755859375,
        650.0999755859375,
        651.0999755859375,
        652.0999755859375,
        653.0999755859375,
        654.0999755859375,
        655.0999755859375,
        656.0999755859375,
        657.0999755859375,
        658.0999755859375,
        659.0999755859375,
        660.0999755859375,
        661.0999755859375,
        662.0999755859375,
        663.0999755859375,
        664.0999755859375,
        665.0999755859375,
        666.0999755859375,
        667.0999755859375,
        668.0999755859375,
        669.0999755859375,
        670.0999755859375,
        671.0999755859375,
        672.0999755859375,
        673.0999755859375,
        674.0999755859375,
        675.0999755859375,
        676.0999755859375,
        677.0999755859375,
        678.0999755859375,
        679.0999755859375,
        680.0999755859375,
        681.0999755859375,
        682.0999755859375,
        683.0999755859375,
        684.0999755859375,
        685.0999755859375,
        686.0999755859375,
        687.0999755859375,
        688.0999755859375,
        689.0999755859375,
        690.0999755859375,
        691.0999755859375,
        692.0999755859375,
        693.0999755859375,
        694.0999755859375,
        695.0999755859375,
        696.0999755859375,
        697.0999755859375,
        698.0999755859375,
        699.0999755859375,
        700.0999755859375,
        701.0999755859375,
        702.0999755859375,
        703.0999755859375,
        704.0999755859375,
        705.0999755859375,
        706.0999755859375,
        707.0999755859375,
        708.0999755859375,
        709.0999755859375,
        710.0999755859375,
        711.0999755859375,
        712.0999755859375,
        713.0999755859375,
        714.0999755859375,
        715.0999755859375,
        716.0999755859375,
        717.0999755859375,
        718.0999755859375,
        719.0999755859375,
        720.0999755859375,
        721.0999755859375,
        722.0999755859375,
        723.0999755859375,
        724.0999755859375,
        725.0999755859375,
        726.0999755859375,
        727.0999755859375,
        728.0999755859375,
        729.0999755859375,
        730.0999755859375,
        731.0999755859375,
        732.0999755859375,
        733.0999755859375,
        734.0999755859375,
        735.0999755859375,
    ],
}

PHONON_DISPERSIONS = {
    "frequencies": [
        [
            -6e-06,
            -6.859784,
            6.606517,
            30.51273,
            59.951283,
            95.726503,
            136.747972,
            181.440527,
            227.681725,
            272.391329,
            310.598611,
            325.699742,
            337.815289,
            346.308831,
            350.855553,
            351.644616,
            348.89038,
            338.866147,
            329.182463,
            320.04531,
            311.649123,
            315.069463,
            318.14294,
            320.835036,
            323.117969,
            324.971932,
            326.38604,
            327.35882,
            327.898186,
            328.020873,
            327.751396,
            345.659305,
            351.881253,
            337.424765,
            304.718673,
            261.190594,
            212.055173,
            160.183107,
            107.110338,
            53.608484,
            -6e-06,
        ],
        [
            -6e-06,
            -6.859784,
            6.606517,
            30.51273,
            59.951283,
            95.726503,
            136.747972,
            181.440527,
            227.681725,
            272.391329,
            310.598611,
            325.699742,
            337.815289,
            346.308831,
            350.855553,
            351.644616,
            349.353447,
            344.905283,
            339.223739,
            333.111973,
            327.231633,
            331.913449,
            336.637754,
            341.337701,
            345.940155,
            350.36598,
            354.530756,
            358.346148,
            361.72218,
            364.570553,
            366.808938,
            401.739276,
            443.340892,
            404.054177,
            351.67074,
            295.742725,
            237.693296,
            178.566132,
            119.04941,
            59.497162,
            -6e-06,
        ],
        [
            -5e-06,
            36.443014,
            73.874394,
            113.115005,
            154.686195,
            198.728443,
            244.954258,
            292.568344,
            339.902039,
            382.246638,
            399.959807,
            394.739094,
            387.370468,
            378.621245,
            369.043816,
            359.032996,
            349.353447,
            344.905283,
            339.223739,
            333.111973,
            327.231633,
            331.913449,
            336.637754,
            341.337701,
            345.940155,
            350.36598,
            354.530756,
            358.346148,
            361.72218,
            364.570553,
            366.808938,
            401.739276,
            443.340892,
            404.054177,
            351.67074,
            295.742725,
            237.693296,
            178.566132,
            119.04941,
            59.497162,
            -5e-06,
        ],
        [
            734.596987,
            730.782803,
            719.463766,
            701.008049,
            676.022465,
            645.347403,
            610.067067,
            571.586348,
            532.009034,
            496.318491,
            484.277839,
            491.954545,
            501.416486,
            507.64632,
            509.359547,
            513.777816,
            520.325824,
            528.211543,
            536.667877,
            545.068135,
            552.939299,
            548.942413,
            545.105641,
            541.469875,
            538.079557,
            534.982714,
            532.230555,
            529.876386,
            527.973605,
            526.572629,
            525.716828,
            493.253362,
            455.617773,
            497.814987,
            549.712197,
            599.782565,
            644.934889,
            682.67788,
            711.056553,
            728.656295,
            734.596987,
        ],
        [
            734.618837,
            731.143013,
            720.870426,
            704.263416,
            682.08567,
            655.395594,
            625.547821,
            594.225673,
            563.565411,
            536.52595,
            517.742506,
            512.333112,
            508.757312,
            507.64632,
            509.359547,
            513.777816,
            520.325824,
            528.211543,
            536.667877,
            545.068135,
            552.939299,
            548.942413,
            545.105641,
            541.469875,
            538.079557,
            534.982714,
            532.230555,
            529.876386,
            527.973605,
            526.572629,
            525.716828,
            493.253362,
            455.617773,
            497.814987,
            549.712197,
            599.782565,
            644.934889,
            682.67788,
            711.056553,
            728.656295,
            734.618837,
        ],
        [
            734.618837,
            731.143013,
            720.870426,
            704.263416,
            682.08567,
            655.395594,
            625.547821,
            594.225673,
            563.565411,
            536.52595,
            517.742506,
            512.333112,
            508.757312,
            511.8593,
            522.715506,
            533.597018,
            544.230211,
            554.413024,
            563.98976,
            572.836536,
            580.852726,
            578.06051,
            575.627135,
            573.579281,
            571.936479,
            570.709879,
            569.901318,
            569.502844,
            569.49677,
            569.856273,
            570.546487,
            555.245821,
            550.906734,
            564.991353,
            593.685705,
            628.320416,
            662.535739,
            692.380999,
            715.315455,
            729.699923,
            734.618837,
        ],
    ],
    "qpoints": [
        [0.0, 0.0, 0.0],
        [0.0, 0.05, 0.05],
        [0.0, 0.1, 0.1],
        [0.0, 0.15, 0.15],
        [0.0, 0.2, 0.2],
        [0.0, 0.25, 0.25],
        [0.0, 0.3, 0.3],
        [0.0, 0.35, 0.35],
        [0.0, 0.4, 0.4],
        [0.0, 0.45, 0.45],
        [0.0, 0.5, 0.5],
        [0.025, 0.525, 0.5],
        [0.05, 0.55, 0.5],
        [0.075, 0.575, 0.5],
        [0.1, 0.6, 0.5],
        [0.125, 0.625, 0.5],
        [0.15, 0.65, 0.5],
        [0.175, 0.675, 0.5],
        [0.2, 0.7, 0.5],
        [0.225, 0.725, 0.5],
        [0.25, 0.75, 0.5],
        [0.2625, 0.75, 0.4875],
        [0.275, 0.75, 0.475],
        [0.2875, 0.75, 0.4625],
        [0.3, 0.75, 0.45],
        [0.3125, 0.75, 0.4375],
        [0.325, 0.75, 0.425],
        [0.3375, 0.75, 0.4125],
        [0.35, 0.75, 0.4],
        [0.3625, 0.75, 0.3875],
        [0.375, 0.75, 0.375],
        [0.3375, 0.675, 0.3375],
        [0.3, 0.6, 0.3],
        [0.2625, 0.525, 0.2625],
        [0.225, 0.45, 0.225],
        [0.1875, 0.375, 0.1875],
        [0.15, 0.3, 0.15],
        [0.1125, 0.225, 0.1125],
        [0.075, 0.15, 0.075],
        [0.0375, 0.075, 0.0375],
        [0.0, 0.0, 0.0],
    ],
}
