import imageio
import numpy as np
import os


class Gif(object):
    def __init__(self, storage):
        self.storage = storage

    def get(self, raw: []) -> []:
        self.storage.download_file(raw[0], 'temp.gif')
        reader = imageio.get_reader('temp.gif')
        out = np.array([frame for frame in reader])
        reader.close()
        os.remove('temp.gif')
        return out

    def put(self, val: []) -> []:
        imageio.mimsave('temp.gif', val, fps=60)
        key = self.storage.upload_file('temp.gif')
        os.remove('temp.gif')
        return [key]
