# -*- coding: utf-8 -*-

from .pool import Pool
from .storage import Storage
from .api import Api, WebSocket
from .authentication import Auth
__version__ = "0.0.5"

# Used with pypi checks and other messages related to pip
_garner_module = "garner"


auth = Auth()
api = Api()
storage = Storage()
websocket = WebSocket()

pool = Pool()


def login(username, password=None, pool_name=None, pool_key=None):
    auth.authenticate(username, password)

    storage.attach_auth(auth)
    api.attach_auth(auth)
    websocket.attach_auth(auth)

    pool.attach(auth, api, storage, websocket)

    if pool_name or pool_key:
        pool.select_pool(pool_name, pool_key)


select_pool = pool.select_pool
get_backlog = pool.get_backlog
connect = pool.connect
disconnect = pool.disconnect
query = pool.query
put = pool.put
