"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    userInvitation: {
        emailSubject: 'invitation email subject from the integ test',
        emailBody: 'invitation email body from the integ test for {username}. Temp password is {####}.',
        smsMessage: 'invitation sms message from the integ test for {username}. Temp password is {####}.',
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailBody: 'verification email body from the integ test. Code is {####}.',
        emailSubject: 'verification email subject from the integ test',
        smsMessage: 'verification sms message from the integ test. Code is {####}.',
    },
    signInAliases: {
        username: true,
        email: true,
    },
    autoVerify: {
        email: true,
        phone: true,
    },
    requiredAttributes: {
        fullname: true,
        email: true,
    },
    customAttributes: {
        'some-string-attr': new lib_1.StringAttribute(),
        'another-string-attr': new lib_1.StringAttribute({ minLen: 4, maxLen: 100 }),
        'some-number-attr': new lib_1.NumberAttribute(),
        'another-number-attr': new lib_1.NumberAttribute({ min: 10, max: 50 }),
        'some-boolean-attr': new lib_1.BooleanAttribute(),
        'some-datetime-attr': new lib_1.DateTimeAttribute(),
    },
    mfa: lib_1.Mfa.REQUIRED,
    mfaSecondFactor: {
        sms: true,
        otp: true,
    },
    passwordPolicy: {
        tempPasswordValidity: core_1.Duration.days(10),
        minLength: 12,
        requireDigits: true,
        requireLowercase: true,
        requireUppercase: true,
        requireSymbols: true,
    },
    emailSettings: {
        from: 'noreply@myawesomeapp.com',
        replyTo: 'support@myawesomeapp.com',
    },
    lambdaTriggers: {
        createAuthChallenge: dummyTrigger('createAuthChallenge'),
        customMessage: dummyTrigger('customMessage'),
        defineAuthChallenge: dummyTrigger('defineAuthChallenge'),
        postAuthentication: dummyTrigger('postAuthentication'),
        postConfirmation: dummyTrigger('postConfirmation'),
        preAuthentication: dummyTrigger('preAuthentication'),
        preSignUp: dummyTrigger('preSignUp'),
        preTokenGeneration: dummyTrigger('preTokenGeneration'),
        userMigration: dummyTrigger('userMigration'),
        verifyAuthChallengeResponse: dummyTrigger('verifyAuthChallengeResponse'),
    },
});
new core_1.CfnOutput(stack, 'userpoolId', {
    value: userpool.userPoolId,
});
function dummyTrigger(name) {
    return new aws_lambda_1.Function(stack, name, {
        functionName: name,
        handler: 'index.handler',
        runtime: aws_lambda_1.Runtime.NODEJS_12_X,
        code: aws_lambda_1.Code.fromInline('foo'),
    });
}
//# sourceMappingURL=data:application/json;base64,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