## Welcome

[![PyPI Latest Release](https://img.shields.io/pypi/v/resistics.svg)](https://pypi.org/project/resistics/)
[![Documentation Status](https://readthedocs.org/projects/resistics/badge/?version=latest)](https://resistics.readthedocs.io/en/latest/?badge=latest)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/resistics/resistics.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/resistics/resistics/context:python)
[![codecov](https://codecov.io/gh/resistics/resistics/branch/master/graph/badge.svg?token=CXLJC9J7AW)](https://codecov.io/gh/resistics/resistics)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

Resistics is a native Python 3.8+ package for the processing of magnetotelluric
(MT) data. It incorporates robust processing methods and adopts a modular
approach to processing which allows for customisation and future improvements
to be quickly adopted.

## Latest news

Resistics is moving to version 1.0.0 which will be a breaking change versus
the current stable version of 0.0.6. Currently, version 1.0.0 is available as a
pre-release on PYPI.

- Documentation for 1.0.0: https://resistics.readthedocs.io/
- Documentation for 0.0.6: https://resistics.io/

When version 1.0.0 reaches a stable releases the documentation will move to the
main resistics.io site.

## Audience

Resistics is intended for people who use magnetotelluric methods to estimate the
subsurface resistivity. This may be for furthering geological understanding, for
geothermal prospecting or for other purposes.

The package may have utility for the wider electromagnetic geophysics community.

## Getting started

To install the pre-release of version 1.0.0

python -m pip install resistics==1.0.0a0

For the stable 0.0.6 version

python -m pip install resistics

## Support and feature requests

Feel free to submit issues, feature requests or ideas for improvements in the
Github issues section.
