from setuptools import find_packages, setup

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name="cligon",
    version="1.0.0",
    author="Roger Yu",
    author_email="rogeryu27@gmail.com",
    description="A small program to check the status of URLs",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/rogercyyu/cligon-url-checker",
    install_requires=[
        "appdirs==1.4.4",
        "attrs==20.3.0",
        "black==20.8b1",
        "certifi==2020.6.20",
        "cfgv==3.2.0",
        "chardet==3.0.4",
        "click==7.1.2",
        "coverage==5.3",
        "distlib==0.3.1",
        "filelock==3.0.12",
        "flake8==3.8.4",
        "identify==1.5.9",
        "idna==2.10",
        "iniconfig==1.1.1",
        "mccabe==0.6.1",
        "mypy-extensions==0.4.3",
        "nodeenv==1.5.0",
        "packaging==20.4",
        "pathspec==0.8.0",
        "pluggy==0.13.1",
        "pre-commit==2.8.2",
        "py==1.9.0",
        "pycodestyle==2.6.0",
        "pyflakes==2.2.0",
        "pyparsing==2.4.7",
        "pytest==6.1.2",
        "PyYAML==5.3.1",
        "regex==2020.10.28",
        "requests==2.24.0",
        "responses==0.12.1",
        "six==1.15.0",
        "toml==0.10.2",
        "typed-ast==1.4.1",
        "typing-extensions==3.7.4.3",
        "urllib3==1.25.11",
        "virtualenv==20.1.0",
    ],
    packages=find_packages(exclude=("tests",)),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    entry_points={"console_scripts": ["cligon=src.cligon:main"]},
    python_requires=">=3.8",
)
