from dnastack.client import *
from .runs import commands as runs_commands
from .run import commands as run_commands
from dnastack.cli.utils import *
from dnastack.cli.auth import get_oauth_token

from ..utils import get_auth_params


@click.group()
@click.pass_context
def wes(ctx):
    pass


@wes.command(name="info")
@click.pass_context
def get_service_info(ctx):
    oauth_token = get_config(ctx, "oauth_token")
    auth_params = get_auth_params(ctx, False)

    try:
        click.echo(
            json.dumps(
                wes_client.get_service_info(
                    get_config(ctx=ctx, var_name="wes-url", do_assert=True),
                    oauth_token,
                    auth_params,
                ),
                indent=4,
            )
        )
    except:
        click.secho(
            f"Error occurred while getting service info",
            fg="red",
        )
        sys.exit(1)


wes.add_command(runs_commands.runs)
wes.add_command(run_commands.run)
