# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.rendering
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .x_color_space import XColorSpace as XColorSpace_e3940d09


class FloatingPointBitmapLayout(object):
    """
    Struct Class

    This structure describes the memory layout of a bitmap having floating point color channels.
    
    This structure collects all necessary information to describe the memory layout of a bitmap having floating point color channels
    
    **since**
    
        OOo 2.0

    See Also:
        `API FloatingPointBitmapLayout <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1rendering_1_1FloatingPointBitmapLayout.html>`_
    """
    typeName: Literal['com.sun.star.rendering.FloatingPointBitmapLayout']

    def __init__(self, ScanLines: typing.Optional[int] = ..., ScanLineBytes: typing.Optional[int] = ..., ScanLineStride: typing.Optional[int] = ..., PlaneStride: typing.Optional[int] = ..., ColorSpace: typing.Optional[XColorSpace_e3940d09] = ..., NumComponents: typing.Optional[int] = ..., Endianness: typing.Optional[int] = ..., Format: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            ScanLines (int, optional): ScanLines value.
            ScanLineBytes (int, optional): ScanLineBytes value.
            ScanLineStride (int, optional): ScanLineStride value.
            PlaneStride (int, optional): PlaneStride value.
            ColorSpace (XColorSpace, optional): ColorSpace value.
            NumComponents (int, optional): NumComponents value.
            Endianness (int, optional): Endianness value.
            Format (int, optional): Format value.
        """


    @property
    def ScanLines(self) -> int:
        """
        Number of scanlines for this bitmap.
        
        This value must not be negative
        """


    @property
    def ScanLineBytes(self) -> int:
        """
        Number of data bytes per scanline.
        
        This value must not be negative
        """


    @property
    def ScanLineStride(self) -> int:
        """
        Byte offset between the start of two consecutive scanlines.
        
        This value is permitted to be negative, denoting a bitmap whose content is flipped at the x axis.
        """


    @property
    def PlaneStride(self) -> int:
        """
        Byte offset between the start of two consecutive planes.
        
        This value is permitted to be negative. If this value is zero, the bitmap is assumed to be in chunky format, otherwise it is assumed to be planar. The difference between chunky and planar layout lies in the way how color channels are interleaved. For a chunky format, all channel data for a single pixel lies consecutively in memory. For a planar layout, the first channel of all pixel is stored consecutive, followed by the second channel, and so forth.
        """


    @property
    def ColorSpace(self) -> XColorSpace_e3940d09:
        """
        Color space the bitmap colors shall be interpreted within.
        """


    @property
    def NumComponents(self) -> int:
        """
        Number of color components per pixel.
        
        This value must not be negative
        """


    @property
    def Endianness(self) -> int:
        """
        Endianness of the pixel values.
        
        This value must be one of the Endianness constants
        """


    @property
    def Format(self) -> int:
        """
        Format type of this bitmap.
        
        This value must be one of the FloatingPointBitmapFormat constants.
        """


