# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['notiondb']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.5.0,<2.0.0', 'requests>=2.27.1,<3.0.0', 'urllib3>=1.25.12,<2.0.0']

extras_require = \
{'docs': ['autodocsumm>=0.2.9,<0.3.0']}

setup_kwargs = {
    'name': 'notion-toolkit',
    'version': '0.1.1',
    'description': 'A powerful object-oriented Python library for easy interaction with Notion.so databases',
    'long_description': '<!-- Improved compatibility of back to top link: See: https://github.com/othneildrew/Best-README-Template/pull/73 -->\n<a name="readme-top"></a>\n<!--\n*** Thanks for checking out the Best-README-Template. If you have a suggestion\n*** that would make this better, please fork the repo and create a pull request\n*** or simply open an issue with the tag "enhancement".\n*** Don\'t forget to give the project a star!\n*** Thanks again! Now go create something AMAZING! :D\n-->\n\n\n\n<!-- PROJECT SHIELDS -->\n<!--\n*** I\'m using markdown "reference style" links for readability.\n*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).\n*** See the bottom of this document for the declaration of the reference variables\n*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.\n*** https://www.markdownguide.org/basic-syntax/#reference-style-links\n-->\n[![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![MIT License][license-shield]][license-url]\n[![LinkedIn][linkedin-shield]][linkedin-url]\n\n\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/mattprodani/notion-db">\n    <img src="https://github.com/mattprodani/notion-db/raw/6e881060ffebffbb24fcb6f41262907f3f72219e/assets/notion_logo.png" alt="Logo" width="80" height="80">\n  </a>\n\n<h3 align="center">Notion-DB</h3>\n\n  <p align="center">\n    Notion-DB is a powerful object-oriented client for the Notion API that allows you to easily access and work with notion Databases. Learn how to use it and create your own Notion integrations in minutes!\n    <br />\n    <a href="https://notion-db.rtfd.io"><strong>Explore the docs »</strong></a>\n    <br />\n    <br />\n    <!-- <a href="https://github.com/mattprodani/notion-db">View Demo</a> -->\n    <!-- · -->\n    <a href="https://github.com/mattprodani/notion-db/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/mattprodani/notion-db/issues">Request Feature</a>\n  </p>\n</div>\n\n\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n  </ol>\n</details>\n\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\n\n<!-- [![Product Name Screen Shot][product-screenshot]](https://example.com) -->\nNotion-DB is a powerful object-oriented client for the Notion API that allows you to easily access and work with notion Databases. Learn how to use it and create your own Notion integrations in minutes!\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n<!-- GETTING STARTED -->\n## Getting Started\nThis is an example on how to get started with using the API client. To see more specific uses\nplease refer to the [Documentation](https://notion-db.rtfd.io). Also refer to the Notion API documentation for more information on the API itself.\n\n### Installation\n\n1. Install the package using pip\n   ```sh\n   pip install notion-db\n   ```\n\n2. Get an API key at [https://www.notion.so/my-integrations](https://www.notion.so/my-integrations)\n\n\n### Example Usage\n\n<img src = "https://github.com/mattprodani/notion-db/raw/6e881060ffebffbb24fcb6f41262907f3f72219e/assets/example_code.svg" height = 300>\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n## Package Overview\n\n### The main classes are: **Connector, Database, Row, and Schema**.\n\n- **Connector** objects are used to connect to the Notion API and work with the API.\n\n- **Schema** objects are used to create new databases and rows. They are also used to update existing databases and rows. Schema objects only contain the structure of the database or row, not the data.\n\n- **Row**  objects contain values, and work with existing rows and create new ones. They are similar to Pandas series,\n\n- **Database** objects are used to work with existing databases and create new ones, as a collection of rows.\n\n### Schema and Row objects contain Properties:\n\n**Property Values** make up each entry in a Row object, and they contain values and properties for a row cell. The client supports all property types that are supported by the Notion API and makes it easy to automatically parse Python types.\n\n**Schema Properties** are used to create new databases and rows, or to validate row objects. They do not hold any values, but hold attributes about the column type in the database, such as the name, and format. The client supports all property types that are supported by the Notion API.\n\n\n_For more examples, please refer to the [Documentation](https://notion-db.rtfd.io)_\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- CONTRIBUTING -->\n## Contributing\nPlease feel free to contribute in any way!\n\n\n\n<!-- LICENSE -->\n## License\n\nDistributed under the GNU 3 License.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- CONTACT -->\n## Contact\n\nMatt Prodani - mattp@nyu.edu\n\nRepository Link: [https://github.com/mattprodani/notion-db](https://github.com/mattprodani/notion-db)\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[contributors-shield]: https://img.shields.io/github/contributors/mattprodani/notion-db.svg?style=for-the-badge\n[contributors-url]: https://github.com/mattprodani/notion-db/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/mattprodani/notion-db.svg?style=for-the-badge\n[forks-url]: https://github.com/mattprodani/notion-db/network/members\n[stars-shield]: https://img.shields.io/github/stars/mattprodani/notion-db.svg?style=for-the-badge\n[stars-url]: https://github.com/mattprodani/notion-db/stargazers\n[issues-shield]: https://img.shields.io/github/issues/mattprodani/notion-db.svg?style=for-the-badge\n[issues-url]: https://github.com/mattprodani/notion-db/issues\n[license-shield]: https://img.shields.io/github/license/mattprodani/notion-db.svg?style=for-the-badge\n[license-url]: https://github.com/mattprodani/notion-db/blob/master/src/LICENSE\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://linkedin.com/in/mattprodani\n[product-screenshot]: images/screenshot.png\n[Next.js]: https://img.shields.io/badge/next.js-000000?style=for-the-badge&logo=nextdotjs&logoColor=white\n[Next-url]: https://nextjs.org/\n[React.js]: https://img.shields.io/badge/React-20232A?style=for-the-badge&logo=react&logoColor=61DAFB\n[React-url]: https://reactjs.org/\n[Vue.js]: https://img.shields.io/badge/Vue.js-35495E?style=for-the-badge&logo=vuedotjs&logoColor=4FC08D\n[Vue-url]: https://vuejs.org/\n[Angular.io]: https://img.shields.io/badge/Angular-DD0031?style=for-the-badge&logo=angular&logoColor=white\n[Angular-url]: https://angular.io/\n[Svelte.dev]: https://img.shields.io/badge/Svelte-4A4A55?style=for-the-badge&logo=svelte&logoColor=FF3E00\n[Svelte-url]: https://svelte.dev/\n[Laravel.com]: https://img.shields.io/badge/Laravel-FF2D20?style=for-the-badge&logo=laravel&logoColor=white\n[Laravel-url]: https://laravel.com\n[Bootstrap.com]: https://img.shields.io/badge/Bootstrap-563D7C?style=for-the-badge&logo=bootstrap&logoColor=white\n[Bootstrap-url]: https://getbootstrap.com\n[JQuery.com]: https://img.shields.io/badge/jQuery-0769AD?style=for-the-badge&logo=jquery&logoColor=white\n[JQuery-url]: https://jquery.com \n',
    'author': 'Matt Prodani',
    'author_email': 'mattp@nyu.edu',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://notion-db.rtfd.io',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
