// Tencent is pleased to support the open source community by making ncnn available.
//
// Copyright (C) 2021 THL A29 Limited, a Tencent company. All rights reserved.
//
// Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// https://opensource.org/licenses/BSD-3-Clause
//
// Unless required by applicable law or agreed to in writing, software distributed
// under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
// CONDITIONS OF ANY KIND, either express or implied. See the License for the
// specific language governing permissions and limitations under the License.

#include "pass_level3.h"

#include "pass_level3/eliminate_tuple_pair.h"
#include "pass_level3/expand_quantization_modules.h"
#include "pass_level3/fuse_attribute_expression.h"
#include "pass_level3/fuse_cat_tensors.h"
#include "pass_level3/fuse_chunk_split_unpack.h"
#include "pass_level3/fuse_expression.h"
#include "pass_level3/fuse_rnn_unpack.h"

// #include "pass_level4/canonicalize.h"
// #include "pass_level4/fuse_custom_op.h"
// #include "pass_level4/dead_code_elimination.h"

namespace pnnx {

void pass_level3(Graph& g)
{
    fuse_cat_tensors(g);

    fuse_chunk_split_unpack(g);

    fuse_rnn_unpack(g);

    expand_quantization_modules(g);

    fuse_attribute_expression(g);

    eliminate_tuple_pair(g);

    fuse_expression(g);

    //     dead_code_elimination(g);

    //     canonicalize(g);
}

} // namespace pnnx
