# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_wp2md.ipynb (unless otherwise specified).

__all__ = ['WP', 'wp2md']

# Cell
from fastcore.utils import urljson, AttrDict, Path, first, test_eq
from fastcore.script import call_parse
from IPython.display import Markdown
from markdownify import markdownify as md

# Cell
def _getpost(post_id:int, baseurl:str):
    return AttrDict(urljson(f'{baseurl}/{post_id}'))

# Cell
class WP:
    def __init__(self, id:int, baseurl:str):
        self.post = _getpost(id, baseurl=baseurl)

    _props = ['title', 'date', 'tags', 'draft', 'description', 'image', 'slug']

    @property
    def draft(self) -> str:
        return str(self.post.draft != 'publish').lower()

    @property
    def title(self) -> str:
        title = self.post.get('title', None)
        return title.get('rendered', None) if title else title

    @property
    def image(self) -> str:
        img = self.post.get('uagb_featured_image_src', None)
        return first(img.get('large', [])) if img else img

    @property
    def frontmatter(self) -> str:
        fm = '---\n'
        for p in self._props:
            attr = getattr(self, p, None)
            if attr: fm+=f'{p}: "{attr}"\n'
        return fm+'---\n'

    def __getattr__(self, name):
        return self.post.get(name, None)

    @property
    def markdown(self) -> str:
        "Return the markdown representation of the body of the post."
        return self.frontmatter + md(self.post.content['rendered'])

    def tomd(self, dest_path:str=None, dest_file:str=None) -> None:
        "Write markdown representation of wordpress post"
        if not dest_path: dest_path = '.'
        if not dest_file: dest_file = self.slug+'.md'
        p = Path(dest_path)/dest_file
        print(f'Writing: {p}')
        p.write_text(self.markdown)

# Cell
@call_parse
def wp2md(id:int,
          baseurl:str='https://outerbounds.com/wp-json/wp/v2/posts', # the baseurl that corresponds to the wp api
          dest_path:str='.', # The path to save the markdown file to
          dest_file:str=None # Optional, if not given defaults to the slug indicated in wordpress
         ):
    "Convert A wordpress post into markdown file with front matter."
    post = WP(id=id, baseurl=baseurl)
    post.tomd(dest_path=dest_path, dest_file=dest_file)