#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['asyncapi', 'asyncapi._tests']

package_data = \
{'': ['*']}

install_requires = \
['circuitbreaker', 'cachetools', 'broadcaster']

extras_require = \
{'doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'http': ['requests'],
 'kafka': ['broadcaster[kafka]'],
 'postgres': ['broadcaster[postgres]'],
 'redis': ['broadcaster[redis]'],
 'test': ['black',
          'isort',
          'ipython',
          'mypy',
          'pytest-asyncio',
          'pytest-cov',
          'pytest-mock',
          'pytest',
          'flake8',
          'bumpversion',
          'jsonschema',
          'asynctest'],
 'yaml': ['pyyaml']}

setup(name='asyncapi',
      version='0.2.0',
      description='asyncapi',
      author='Diogo Dutra',
      author_email='diogodutradamata@gmail.com',
      url='https://github.com/dutradda/asyncapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
