# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.43.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_envoy_cli.configuration import Configuration


class OrderProduct(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'product': 'Product',
        'quantity': 'int',
        'price': 'float',
        'discount': 'float',
        'tax': 'float'
    }

    attribute_map = {
        'product': 'product',
        'quantity': 'quantity',
        'price': 'price',
        'discount': 'discount',
        'tax': 'tax'
    }

    def __init__(self, product=None, quantity=None, price=None, discount=None, tax=None, local_vars_configuration=None):  # noqa: E501
        """OrderProduct - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._product = None
        self._quantity = None
        self._price = None
        self._discount = None
        self._tax = None
        self.discriminator = None

        if product is not None:
            self.product = product
        if quantity is not None:
            self.quantity = quantity
        if price is not None:
            self.price = price
        if discount is not None:
            self.discount = discount
        if tax is not None:
            self.tax = tax

    @property
    def product(self):
        """Gets the product of this OrderProduct.  # noqa: E501


        :return: The product of this OrderProduct.  # noqa: E501
        :rtype: Product
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this OrderProduct.


        :param product: The product of this OrderProduct.  # noqa: E501
        :type: Product
        """

        self._product = product

    @property
    def quantity(self):
        """Gets the quantity of this OrderProduct.  # noqa: E501


        :return: The quantity of this OrderProduct.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderProduct.


        :param quantity: The quantity of this OrderProduct.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def price(self):
        """Gets the price of this OrderProduct.  # noqa: E501

        It's unit price of current product, but not the total price. And it's the sell price exactly, not original or pre-tax.  # noqa: E501

        :return: The price of this OrderProduct.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderProduct.

        It's unit price of current product, but not the total price. And it's the sell price exactly, not original or pre-tax.  # noqa: E501

        :param price: The price of this OrderProduct.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def discount(self):
        """Gets the discount of this OrderProduct.  # noqa: E501

        It's unit discount of current product  # noqa: E501

        :return: The discount of this OrderProduct.  # noqa: E501
        :rtype: float
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """Sets the discount of this OrderProduct.

        It's unit discount of current product  # noqa: E501

        :param discount: The discount of this OrderProduct.  # noqa: E501
        :type: float
        """

        self._discount = discount

    @property
    def tax(self):
        """Gets the tax of this OrderProduct.  # noqa: E501

        The tax of current product.  # noqa: E501

        :return: The tax of this OrderProduct.  # noqa: E501
        :rtype: float
        """
        return self._tax

    @tax.setter
    def tax(self, tax):
        """Sets the tax of this OrderProduct.

        The tax of current product.  # noqa: E501

        :param tax: The tax of this OrderProduct.  # noqa: E501
        :type: float
        """

        self._tax = tax

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderProduct):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderProduct):
            return True

        return self.to_dict() != other.to_dict()
