# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.43.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_envoy_cli.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'str',
        'client_order_ref': 'str',
        'client_parent_order_ref': 'str',
        'platform_transaction_id': 'str',
        'platform_name': 'str',
        'is_sub_order': 'bool',
        'is_distribution_order': 'bool',
        'distributor_name': 'str',
        'order_type': 'str',
        'items': 'list[OrderProduct]',
        'customer': 'Address',
        'customer_id_ref': 'str',
        'seller': 'Address',
        'payer': 'Address',
        'status': 'str',
        'tracking_reference': 'str',
        'destination_code': 'str',
        'node_code': 'str',
        'express_company': 'str',
        'express_type': 'str',
        'currency': 'str',
        'customs_code': 'str',
        'customs_filing_id': 'str',
        'created_at': 'str',
        'updated_at': 'str',
        'pay_method': 'str',
        'pay_merchant_name': 'str',
        'pay_amount': 'float',
        'pay_id': 'str',
        'payment_pay_id': 'str',
        'paid_at': 'str',
        'pay_customs_no': 'str',
        'products_total_tax': 'float',
        'shipping_cost': 'float',
        'non_cash_deduction_amount': 'float',
        'insurance_fee': 'float',
        'customer_note': 'str',
        'delivery_slip_url': 'str'
    }

    attribute_map = {
        'order_id': 'orderId',
        'client_order_ref': 'clientOrderRef',
        'client_parent_order_ref': 'clientParentOrderRef',
        'platform_transaction_id': 'platformTransactionId',
        'platform_name': 'platformName',
        'is_sub_order': 'isSubOrder',
        'is_distribution_order': 'isDistributionOrder',
        'distributor_name': 'distributorName',
        'order_type': 'orderType',
        'items': 'items',
        'customer': 'customer',
        'customer_id_ref': 'customerIdRef',
        'seller': 'seller',
        'payer': 'payer',
        'status': 'status',
        'tracking_reference': 'trackingReference',
        'destination_code': 'destinationCode',
        'node_code': 'nodeCode',
        'express_company': 'expressCompany',
        'express_type': 'expressType',
        'currency': 'currency',
        'customs_code': 'customsCode',
        'customs_filing_id': 'customsFilingId',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'pay_method': 'payMethod',
        'pay_merchant_name': 'payMerchantName',
        'pay_amount': 'payAmount',
        'pay_id': 'payId',
        'payment_pay_id': 'paymentPayId',
        'paid_at': 'paidAt',
        'pay_customs_no': 'payCustomsNo',
        'products_total_tax': 'productsTotalTax',
        'shipping_cost': 'shippingCost',
        'non_cash_deduction_amount': 'nonCashDeductionAmount',
        'insurance_fee': 'insuranceFee',
        'customer_note': 'customerNote',
        'delivery_slip_url': 'deliverySlipUrl'
    }

    def __init__(self, order_id=None, client_order_ref=None, client_parent_order_ref=None, platform_transaction_id=None, platform_name=None, is_sub_order=False, is_distribution_order=False, distributor_name=None, order_type='DEFAULT', items=None, customer=None, customer_id_ref=None, seller=None, payer=None, status=None, tracking_reference=None, destination_code=None, node_code=None, express_company=None, express_type=None, currency='RMB', customs_code='SH', customs_filing_id=None, created_at=None, updated_at=None, pay_method=None, pay_merchant_name=None, pay_amount=None, pay_id=None, payment_pay_id=None, paid_at=None, pay_customs_no=None, products_total_tax=None, shipping_cost=None, non_cash_deduction_amount=None, insurance_fee=None, customer_note=None, delivery_slip_url=None, local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._client_order_ref = None
        self._client_parent_order_ref = None
        self._platform_transaction_id = None
        self._platform_name = None
        self._is_sub_order = None
        self._is_distribution_order = None
        self._distributor_name = None
        self._order_type = None
        self._items = None
        self._customer = None
        self._customer_id_ref = None
        self._seller = None
        self._payer = None
        self._status = None
        self._tracking_reference = None
        self._destination_code = None
        self._node_code = None
        self._express_company = None
        self._express_type = None
        self._currency = None
        self._customs_code = None
        self._customs_filing_id = None
        self._created_at = None
        self._updated_at = None
        self._pay_method = None
        self._pay_merchant_name = None
        self._pay_amount = None
        self._pay_id = None
        self._payment_pay_id = None
        self._paid_at = None
        self._pay_customs_no = None
        self._products_total_tax = None
        self._shipping_cost = None
        self._non_cash_deduction_amount = None
        self._insurance_fee = None
        self._customer_note = None
        self._delivery_slip_url = None
        self.discriminator = None

        if order_id is not None:
            self.order_id = order_id
        if client_order_ref is not None:
            self.client_order_ref = client_order_ref
        if client_parent_order_ref is not None:
            self.client_parent_order_ref = client_parent_order_ref
        if platform_transaction_id is not None:
            self.platform_transaction_id = platform_transaction_id
        self.platform_name = platform_name
        if is_sub_order is not None:
            self.is_sub_order = is_sub_order
        if is_distribution_order is not None:
            self.is_distribution_order = is_distribution_order
        if distributor_name is not None:
            self.distributor_name = distributor_name
        if order_type is not None:
            self.order_type = order_type
        if items is not None:
            self.items = items
        if customer is not None:
            self.customer = customer
        if customer_id_ref is not None:
            self.customer_id_ref = customer_id_ref
        if seller is not None:
            self.seller = seller
        if payer is not None:
            self.payer = payer
        if status is not None:
            self.status = status
        if tracking_reference is not None:
            self.tracking_reference = tracking_reference
        if destination_code is not None:
            self.destination_code = destination_code
        if node_code is not None:
            self.node_code = node_code
        if express_company is not None:
            self.express_company = express_company
        if express_type is not None:
            self.express_type = express_type
        self.currency = currency
        if customs_code is not None:
            self.customs_code = customs_code
        if customs_filing_id is not None:
            self.customs_filing_id = customs_filing_id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if pay_method is not None:
            self.pay_method = pay_method
        if pay_merchant_name is not None:
            self.pay_merchant_name = pay_merchant_name
        if pay_amount is not None:
            self.pay_amount = pay_amount
        if pay_id is not None:
            self.pay_id = pay_id
        if payment_pay_id is not None:
            self.payment_pay_id = payment_pay_id
        if paid_at is not None:
            self.paid_at = paid_at
        if pay_customs_no is not None:
            self.pay_customs_no = pay_customs_no
        if products_total_tax is not None:
            self.products_total_tax = products_total_tax
        if shipping_cost is not None:
            self.shipping_cost = shipping_cost
        if non_cash_deduction_amount is not None:
            self.non_cash_deduction_amount = non_cash_deduction_amount
        if insurance_fee is not None:
            self.insurance_fee = insurance_fee
        if customer_note is not None:
            self.customer_note = customer_note
        if delivery_slip_url is not None:
            self.delivery_slip_url = delivery_slip_url

    @property
    def order_id(self):
        """Gets the order_id of this Order.  # noqa: E501

        Order ID ref (Odoo platform).  # noqa: E501

        :return: The order_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this Order.

        Order ID ref (Odoo platform).  # noqa: E501

        :param order_id: The order_id of this Order.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def client_order_ref(self):
        """Gets the client_order_ref of this Order.  # noqa: E501

        Client order ref (third party platform)  # noqa: E501

        :return: The client_order_ref of this Order.  # noqa: E501
        :rtype: str
        """
        return self._client_order_ref

    @client_order_ref.setter
    def client_order_ref(self, client_order_ref):
        """Sets the client_order_ref of this Order.

        Client order ref (third party platform)  # noqa: E501

        :param client_order_ref: The client_order_ref of this Order.  # noqa: E501
        :type: str
        """

        self._client_order_ref = client_order_ref

    @property
    def client_parent_order_ref(self):
        """Gets the client_parent_order_ref of this Order.  # noqa: E501

        Client parent order ref (third party platform)  # noqa: E501

        :return: The client_parent_order_ref of this Order.  # noqa: E501
        :rtype: str
        """
        return self._client_parent_order_ref

    @client_parent_order_ref.setter
    def client_parent_order_ref(self, client_parent_order_ref):
        """Sets the client_parent_order_ref of this Order.

        Client parent order ref (third party platform)  # noqa: E501

        :param client_parent_order_ref: The client_parent_order_ref of this Order.  # noqa: E501
        :type: str
        """

        self._client_parent_order_ref = client_parent_order_ref

    @property
    def platform_transaction_id(self):
        """Gets the platform_transaction_id of this Order.  # noqa: E501

        Client transaction id (third party platform), e.g. PDD for customs purpose payment  # noqa: E501

        :return: The platform_transaction_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._platform_transaction_id

    @platform_transaction_id.setter
    def platform_transaction_id(self, platform_transaction_id):
        """Sets the platform_transaction_id of this Order.

        Client transaction id (third party platform), e.g. PDD for customs purpose payment  # noqa: E501

        :param platform_transaction_id: The platform_transaction_id of this Order.  # noqa: E501
        :type: str
        """

        self._platform_transaction_id = platform_transaction_id

    @property
    def platform_name(self):
        """Gets the platform_name of this Order.  # noqa: E501

        platform name, available options: pdd, youzan, littleredbook, nomad.  # noqa: E501

        :return: The platform_name of this Order.  # noqa: E501
        :rtype: str
        """
        return self._platform_name

    @platform_name.setter
    def platform_name(self, platform_name):
        """Sets the platform_name of this Order.

        platform name, available options: pdd, youzan, littleredbook, nomad.  # noqa: E501

        :param platform_name: The platform_name of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and platform_name is None:  # noqa: E501
            raise ValueError("Invalid value for `platform_name`, must not be `None`")  # noqa: E501

        self._platform_name = platform_name

    @property
    def is_sub_order(self):
        """Gets the is_sub_order of this Order.  # noqa: E501

        declare if current order is a sub order.  # noqa: E501

        :return: The is_sub_order of this Order.  # noqa: E501
        :rtype: bool
        """
        return self._is_sub_order

    @is_sub_order.setter
    def is_sub_order(self, is_sub_order):
        """Sets the is_sub_order of this Order.

        declare if current order is a sub order.  # noqa: E501

        :param is_sub_order: The is_sub_order of this Order.  # noqa: E501
        :type: bool
        """

        self._is_sub_order = is_sub_order

    @property
    def is_distribution_order(self):
        """Gets the is_distribution_order of this Order.  # noqa: E501

        declare if current order is a distribution order.  # noqa: E501

        :return: The is_distribution_order of this Order.  # noqa: E501
        :rtype: bool
        """
        return self._is_distribution_order

    @is_distribution_order.setter
    def is_distribution_order(self, is_distribution_order):
        """Sets the is_distribution_order of this Order.

        declare if current order is a distribution order.  # noqa: E501

        :param is_distribution_order: The is_distribution_order of this Order.  # noqa: E501
        :type: bool
        """

        self._is_distribution_order = is_distribution_order

    @property
    def distributor_name(self):
        """Gets the distributor_name of this Order.  # noqa: E501

        Distributor Name  # noqa: E501

        :return: The distributor_name of this Order.  # noqa: E501
        :rtype: str
        """
        return self._distributor_name

    @distributor_name.setter
    def distributor_name(self, distributor_name):
        """Sets the distributor_name of this Order.

        Distributor Name  # noqa: E501

        :param distributor_name: The distributor_name of this Order.  # noqa: E501
        :type: str
        """

        self._distributor_name = distributor_name

    @property
    def order_type(self):
        """Gets the order_type of this Order.  # noqa: E501

        Current order type, could be one of DEFAULT/DISTRIBUTOR/SUPPLIER  # noqa: E501

        :return: The order_type of this Order.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this Order.

        Current order type, could be one of DEFAULT/DISTRIBUTOR/SUPPLIER  # noqa: E501

        :param order_type: The order_type of this Order.  # noqa: E501
        :type: str
        """

        self._order_type = order_type

    @property
    def items(self):
        """Gets the items of this Order.  # noqa: E501

        Products in order.  # noqa: E501

        :return: The items of this Order.  # noqa: E501
        :rtype: list[OrderProduct]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this Order.

        Products in order.  # noqa: E501

        :param items: The items of this Order.  # noqa: E501
        :type: list[OrderProduct]
        """

        self._items = items

    @property
    def customer(self):
        """Gets the customer of this Order.  # noqa: E501


        :return: The customer of this Order.  # noqa: E501
        :rtype: Address
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this Order.


        :param customer: The customer of this Order.  # noqa: E501
        :type: Address
        """

        self._customer = customer

    @property
    def customer_id_ref(self):
        """Gets the customer_id_ref of this Order.  # noqa: E501

        The ID of buyer on current third party platform.  # noqa: E501

        :return: The customer_id_ref of this Order.  # noqa: E501
        :rtype: str
        """
        return self._customer_id_ref

    @customer_id_ref.setter
    def customer_id_ref(self, customer_id_ref):
        """Sets the customer_id_ref of this Order.

        The ID of buyer on current third party platform.  # noqa: E501

        :param customer_id_ref: The customer_id_ref of this Order.  # noqa: E501
        :type: str
        """

        self._customer_id_ref = customer_id_ref

    @property
    def seller(self):
        """Gets the seller of this Order.  # noqa: E501


        :return: The seller of this Order.  # noqa: E501
        :rtype: Address
        """
        return self._seller

    @seller.setter
    def seller(self, seller):
        """Sets the seller of this Order.


        :param seller: The seller of this Order.  # noqa: E501
        :type: Address
        """

        self._seller = seller

    @property
    def payer(self):
        """Gets the payer of this Order.  # noqa: E501


        :return: The payer of this Order.  # noqa: E501
        :rtype: Address
        """
        return self._payer

    @payer.setter
    def payer(self, payer):
        """Sets the payer of this Order.


        :param payer: The payer of this Order.  # noqa: E501
        :type: Address
        """

        self._payer = payer

    @property
    def status(self):
        """Gets the status of this Order.  # noqa: E501

        View valid status at get /order query params  # noqa: E501

        :return: The status of this Order.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Order.

        View valid status at get /order query params  # noqa: E501

        :param status: The status of this Order.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def tracking_reference(self):
        """Gets the tracking_reference of this Order.  # noqa: E501

        package tracking reference.  # noqa: E501

        :return: The tracking_reference of this Order.  # noqa: E501
        :rtype: str
        """
        return self._tracking_reference

    @tracking_reference.setter
    def tracking_reference(self, tracking_reference):
        """Sets the tracking_reference of this Order.

        package tracking reference.  # noqa: E501

        :param tracking_reference: The tracking_reference of this Order.  # noqa: E501
        :type: str
        """

        self._tracking_reference = tracking_reference

    @property
    def destination_code(self):
        """Gets the destination_code of this Order.  # noqa: E501

        Proposed by Onion, original Chinese phrase is 三段码.  # noqa: E501

        :return: The destination_code of this Order.  # noqa: E501
        :rtype: str
        """
        return self._destination_code

    @destination_code.setter
    def destination_code(self, destination_code):
        """Sets the destination_code of this Order.

        Proposed by Onion, original Chinese phrase is 三段码.  # noqa: E501

        :param destination_code: The destination_code of this Order.  # noqa: E501
        :type: str
        """

        self._destination_code = destination_code

    @property
    def node_code(self):
        """Gets the node_code of this Order.  # noqa: E501

        Proposed by Onion, original Chinese phrase is 集包地.  # noqa: E501

        :return: The node_code of this Order.  # noqa: E501
        :rtype: str
        """
        return self._node_code

    @node_code.setter
    def node_code(self, node_code):
        """Sets the node_code of this Order.

        Proposed by Onion, original Chinese phrase is 集包地.  # noqa: E501

        :param node_code: The node_code of this Order.  # noqa: E501
        :type: str
        """

        self._node_code = node_code

    @property
    def express_company(self):
        """Gets the express_company of this Order.  # noqa: E501

        Logistic companies, e.g. STO, Goldjet.  # noqa: E501

        :return: The express_company of this Order.  # noqa: E501
        :rtype: str
        """
        return self._express_company

    @express_company.setter
    def express_company(self, express_company):
        """Sets the express_company of this Order.

        Logistic companies, e.g. STO, Goldjet.  # noqa: E501

        :param express_company: The express_company of this Order.  # noqa: E501
        :type: str
        """

        self._express_company = express_company

    @property
    def express_type(self):
        """Gets the express_type of this Order.  # noqa: E501

        BC/BBC.  BC means business-customer, BBC means business-business-customer, like distribution sell mode.  # noqa: E501

        :return: The express_type of this Order.  # noqa: E501
        :rtype: str
        """
        return self._express_type

    @express_type.setter
    def express_type(self, express_type):
        """Sets the express_type of this Order.

        BC/BBC.  BC means business-customer, BBC means business-business-customer, like distribution sell mode.  # noqa: E501

        :param express_type: The express_type of this Order.  # noqa: E501
        :type: str
        """

        self._express_type = express_type

    @property
    def currency(self):
        """Gets the currency of this Order.  # noqa: E501

        The currency used in current order, it makes sense if we declare it explicitly.  # noqa: E501

        :return: The currency of this Order.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Order.

        The currency used in current order, it makes sense if we declare it explicitly.  # noqa: E501

        :param currency: The currency of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def customs_code(self):
        """Gets the customs_code of this Order.  # noqa: E501

        海关编号 ZZ:郑州新郑综合保税区；GZ：广州海关；HZ：杭州海关；SH：上海海关  # noqa: E501

        :return: The customs_code of this Order.  # noqa: E501
        :rtype: str
        """
        return self._customs_code

    @customs_code.setter
    def customs_code(self, customs_code):
        """Sets the customs_code of this Order.

        海关编号 ZZ:郑州新郑综合保税区；GZ：广州海关；HZ：杭州海关；SH：上海海关  # noqa: E501

        :param customs_code: The customs_code of this Order.  # noqa: E501
        :type: str
        """

        self._customs_code = customs_code

    @property
    def customs_filing_id(self):
        """Gets the customs_filing_id of this Order.  # noqa: E501

        The filing id that returned from Customs  # noqa: E501

        :return: The customs_filing_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._customs_filing_id

    @customs_filing_id.setter
    def customs_filing_id(self, customs_filing_id):
        """Sets the customs_filing_id of this Order.

        The filing id that returned from Customs  # noqa: E501

        :param customs_filing_id: The customs_filing_id of this Order.  # noqa: E501
        :type: str
        """

        self._customs_filing_id = customs_filing_id

    @property
    def created_at(self):
        """Gets the created_at of this Order.  # noqa: E501

        The time when current order was created. ISO_8601 format  # noqa: E501

        :return: The created_at of this Order.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Order.

        The time when current order was created. ISO_8601 format  # noqa: E501

        :param created_at: The created_at of this Order.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Order.  # noqa: E501

        The time when current order was updated. ISO_8601 format  # noqa: E501

        :return: The updated_at of this Order.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Order.

        The time when current order was updated. ISO_8601 format  # noqa: E501

        :param updated_at: The updated_at of this Order.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    @property
    def pay_method(self):
        """Gets the pay_method of this Order.  # noqa: E501


        :return: The pay_method of this Order.  # noqa: E501
        :rtype: str
        """
        return self._pay_method

    @pay_method.setter
    def pay_method(self, pay_method):
        """Sets the pay_method of this Order.


        :param pay_method: The pay_method of this Order.  # noqa: E501
        :type: str
        """

        self._pay_method = pay_method

    @property
    def pay_merchant_name(self):
        """Gets the pay_merchant_name of this Order.  # noqa: E501


        :return: The pay_merchant_name of this Order.  # noqa: E501
        :rtype: str
        """
        return self._pay_merchant_name

    @pay_merchant_name.setter
    def pay_merchant_name(self, pay_merchant_name):
        """Sets the pay_merchant_name of this Order.


        :param pay_merchant_name: The pay_merchant_name of this Order.  # noqa: E501
        :type: str
        """

        self._pay_merchant_name = pay_merchant_name

    @property
    def pay_amount(self):
        """Gets the pay_amount of this Order.  # noqa: E501

        The amount of final paid.  # noqa: E501

        :return: The pay_amount of this Order.  # noqa: E501
        :rtype: float
        """
        return self._pay_amount

    @pay_amount.setter
    def pay_amount(self, pay_amount):
        """Sets the pay_amount of this Order.

        The amount of final paid.  # noqa: E501

        :param pay_amount: The pay_amount of this Order.  # noqa: E501
        :type: float
        """

        self._pay_amount = pay_amount

    @property
    def pay_id(self):
        """Gets the pay_id of this Order.  # noqa: E501

        The pay number generated by the eCommerce platform such as Youzan  # noqa: E501

        :return: The pay_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._pay_id

    @pay_id.setter
    def pay_id(self, pay_id):
        """Sets the pay_id of this Order.

        The pay number generated by the eCommerce platform such as Youzan  # noqa: E501

        :param pay_id: The pay_id of this Order.  # noqa: E501
        :type: str
        """

        self._pay_id = pay_id

    @property
    def payment_pay_id(self):
        """Gets the payment_pay_id of this Order.  # noqa: E501

        the payment number generated by payment tool such as WeChat Pay  # noqa: E501

        :return: The payment_pay_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._payment_pay_id

    @payment_pay_id.setter
    def payment_pay_id(self, payment_pay_id):
        """Sets the payment_pay_id of this Order.

        the payment number generated by payment tool such as WeChat Pay  # noqa: E501

        :param payment_pay_id: The payment_pay_id of this Order.  # noqa: E501
        :type: str
        """

        self._payment_pay_id = payment_pay_id

    @property
    def paid_at(self):
        """Gets the paid_at of this Order.  # noqa: E501

        The time when the pay was made. ISO_8601 format  # noqa: E501

        :return: The paid_at of this Order.  # noqa: E501
        :rtype: str
        """
        return self._paid_at

    @paid_at.setter
    def paid_at(self, paid_at):
        """Sets the paid_at of this Order.

        The time when the pay was made. ISO_8601 format  # noqa: E501

        :param paid_at: The paid_at of this Order.  # noqa: E501
        :type: str
        """

        self._paid_at = paid_at

    @property
    def pay_customs_no(self):
        """Gets the pay_customs_no of this Order.  # noqa: E501

        The payment declaration number from customs.  # noqa: E501

        :return: The pay_customs_no of this Order.  # noqa: E501
        :rtype: str
        """
        return self._pay_customs_no

    @pay_customs_no.setter
    def pay_customs_no(self, pay_customs_no):
        """Sets the pay_customs_no of this Order.

        The payment declaration number from customs.  # noqa: E501

        :param pay_customs_no: The pay_customs_no of this Order.  # noqa: E501
        :type: str
        """

        self._pay_customs_no = pay_customs_no

    @property
    def products_total_tax(self):
        """Gets the products_total_tax of this Order.  # noqa: E501

        The sum tax of all products in current order, including Non-cash deduction amount.  # noqa: E501

        :return: The products_total_tax of this Order.  # noqa: E501
        :rtype: float
        """
        return self._products_total_tax

    @products_total_tax.setter
    def products_total_tax(self, products_total_tax):
        """Sets the products_total_tax of this Order.

        The sum tax of all products in current order, including Non-cash deduction amount.  # noqa: E501

        :param products_total_tax: The products_total_tax of this Order.  # noqa: E501
        :type: float
        """

        self._products_total_tax = products_total_tax

    @property
    def shipping_cost(self):
        """Gets the shipping_cost of this Order.  # noqa: E501

        The shipping cost of current order, excluding the shipping cost on each contained products. If delivery free, just set 0.  # noqa: E501

        :return: The shipping_cost of this Order.  # noqa: E501
        :rtype: float
        """
        return self._shipping_cost

    @shipping_cost.setter
    def shipping_cost(self, shipping_cost):
        """Sets the shipping_cost of this Order.

        The shipping cost of current order, excluding the shipping cost on each contained products. If delivery free, just set 0.  # noqa: E501

        :param shipping_cost: The shipping_cost of this Order.  # noqa: E501
        :type: float
        """

        self._shipping_cost = shipping_cost

    @property
    def non_cash_deduction_amount(self):
        """Gets the non_cash_deduction_amount of this Order.  # noqa: E501

        Amount that deducted by non-cash, e.g. member points, virtual currency, voucher code, etc.  # noqa: E501

        :return: The non_cash_deduction_amount of this Order.  # noqa: E501
        :rtype: float
        """
        return self._non_cash_deduction_amount

    @non_cash_deduction_amount.setter
    def non_cash_deduction_amount(self, non_cash_deduction_amount):
        """Sets the non_cash_deduction_amount of this Order.

        Amount that deducted by non-cash, e.g. member points, virtual currency, voucher code, etc.  # noqa: E501

        :param non_cash_deduction_amount: The non_cash_deduction_amount of this Order.  # noqa: E501
        :type: float
        """

        self._non_cash_deduction_amount = non_cash_deduction_amount

    @property
    def insurance_fee(self):
        """Gets the insurance_fee of this Order.  # noqa: E501

        The insurance fee of current shipping.  # noqa: E501

        :return: The insurance_fee of this Order.  # noqa: E501
        :rtype: float
        """
        return self._insurance_fee

    @insurance_fee.setter
    def insurance_fee(self, insurance_fee):
        """Sets the insurance_fee of this Order.

        The insurance fee of current shipping.  # noqa: E501

        :param insurance_fee: The insurance_fee of this Order.  # noqa: E501
        :type: float
        """

        self._insurance_fee = insurance_fee

    @property
    def customer_note(self):
        """Gets the customer_note of this Order.  # noqa: E501

        The special note from the buyer.  # noqa: E501

        :return: The customer_note of this Order.  # noqa: E501
        :rtype: str
        """
        return self._customer_note

    @customer_note.setter
    def customer_note(self, customer_note):
        """Sets the customer_note of this Order.

        The special note from the buyer.  # noqa: E501

        :param customer_note: The customer_note of this Order.  # noqa: E501
        :type: str
        """

        self._customer_note = customer_note

    @property
    def delivery_slip_url(self):
        """Gets the delivery_slip_url of this Order.  # noqa: E501

        The URL of delivery slip.  # noqa: E501

        :return: The delivery_slip_url of this Order.  # noqa: E501
        :rtype: str
        """
        return self._delivery_slip_url

    @delivery_slip_url.setter
    def delivery_slip_url(self, delivery_slip_url):
        """Sets the delivery_slip_url of this Order.

        The URL of delivery slip.  # noqa: E501

        :param delivery_slip_url: The delivery_slip_url of this Order.  # noqa: E501
        :type: str
        """

        self._delivery_slip_url = delivery_slip_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
