# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.43.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_envoy_cli.api_client import ApiClient
from nomad_envoy_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CustomsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def post_customs_order(self, region, order, **kwargs):  # noqa: E501
        """postCustomsOrder  # noqa: E501

        Register order to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_order(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_customs_order_with_http_info(region, order, **kwargs)  # noqa: E501

    def post_customs_order_with_http_info(self, region, order, **kwargs):  # noqa: E501
        """postCustomsOrder  # noqa: E501

        Register order to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_order_with_http_info(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['region', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customs_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'region' is set
        if self.api_client.client_side_validation and ('region' not in local_var_params or  # noqa: E501
                                                        local_var_params['region'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `region` when calling `post_customs_order`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `post_customs_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region' in local_var_params:
            path_params['region'] = local_var_params['region']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/customs/{region}/order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_customs_payment(self, region, order, **kwargs):  # noqa: E501
        """postCustomsPayment  # noqa: E501

        Register payment to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_payment(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_customs_payment_with_http_info(region, order, **kwargs)  # noqa: E501

    def post_customs_payment_with_http_info(self, region, order, **kwargs):  # noqa: E501
        """postCustomsPayment  # noqa: E501

        Register payment to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_payment_with_http_info(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['region', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customs_payment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'region' is set
        if self.api_client.client_side_validation and ('region' not in local_var_params or  # noqa: E501
                                                        local_var_params['region'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `region` when calling `post_customs_payment`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `post_customs_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region' in local_var_params:
            path_params['region'] = local_var_params['region']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/customs/{region}/payment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_customs_product(self, region, product, **kwargs):  # noqa: E501
        """postCustomsProduct  # noqa: E501

        Register products to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_product(region, product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Product product: Product detail (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_customs_product_with_http_info(region, product, **kwargs)  # noqa: E501

    def post_customs_product_with_http_info(self, region, product, **kwargs):  # noqa: E501
        """postCustomsProduct  # noqa: E501

        Register products to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_customs_product_with_http_info(region, product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Product product: Product detail (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['region', 'product']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customs_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'region' is set
        if self.api_client.client_side_validation and ('region' not in local_var_params or  # noqa: E501
                                                        local_var_params['region'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `region` when calling `post_customs_product`")  # noqa: E501
        # verify the required parameter 'product' is set
        if self.api_client.client_side_validation and ('product' not in local_var_params or  # noqa: E501
                                                        local_var_params['product'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `product` when calling `post_customs_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region' in local_var_params:
            path_params['region'] = local_var_params['region']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'product' in local_var_params:
            body_params = local_var_params['product']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/customs/{region}/product', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_customs_order(self, region, order, **kwargs):  # noqa: E501
        """putCustomsOrder  # noqa: E501

        update order to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_customs_order(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_customs_order_with_http_info(region, order, **kwargs)  # noqa: E501

    def put_customs_order_with_http_info(self, region, order, **kwargs):  # noqa: E501
        """putCustomsOrder  # noqa: E501

        update order to Shanghai Customs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_customs_order_with_http_info(region, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str region: The region of the customs. e.g. shanghai (required)
        :param Order order: Order detail (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['region', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_customs_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'region' is set
        if self.api_client.client_side_validation and ('region' not in local_var_params or  # noqa: E501
                                                        local_var_params['region'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `region` when calling `put_customs_order`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `put_customs_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'region' in local_var_params:
            path_params['region'] = local_var_params['region']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/customs/{region}/order', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
