"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Spacer = exports.Column = exports.Row = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const widget_1 = require("./widget");
// This file contains widgets that exist for layout purposes
/**
 * A widget that contains other widgets in a horizontal row
 *
 * Widgets will be laid out next to each other
 */
class Row {
    constructor(...widgets) {
        /**
         * Relative position of each widget inside this row
         */
        this.offsets = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_IWidget(widgets);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Row);
            }
            throw error;
        }
        this.widgets = widgets;
        this.width = 0;
        this.height = 0;
        let x = 0;
        let y = 0;
        for (const widget of widgets) {
            // See if we need to horizontally wrap to add this widget
            if (x + widget.width > widget_1.GRID_WIDTH) {
                y = this.height;
                x = 0;
            }
            this.offsets.push({ x, y });
            this.width = Math.max(this.width, x + widget.width);
            this.height = Math.max(this.height, y + widget.height);
            x += widget.width;
        }
    }
    position(x, y) {
        for (let i = 0; i < this.widgets.length; i++) {
            this.widgets[i].position(x + this.offsets[i].x, y + this.offsets[i].y);
        }
    }
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Row = Row;
_a = JSII_RTTI_SYMBOL_1;
Row[_a] = { fqn: "@aws-cdk/aws-cloudwatch.Row", version: "1.165.0" };
/**
 * A widget that contains other widgets in a vertical column
 *
 * Widgets will be laid out next to each other
 */
class Column {
    constructor(...widgets) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_IWidget(widgets);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Column);
            }
            throw error;
        }
        this.widgets = widgets;
        // There's no vertical wrapping so this one's a lot easier
        this.width = Math.max(...this.widgets.map(w => w.width));
        this.height = sum(...this.widgets.map(w => w.height));
    }
    position(x, y) {
        let widgetY = y;
        for (const widget of this.widgets) {
            widget.position(x, widgetY);
            widgetY += widget.height;
        }
    }
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Column = Column;
_b = JSII_RTTI_SYMBOL_1;
Column[_b] = { fqn: "@aws-cdk/aws-cloudwatch.Column", version: "1.165.0" };
/**
 * A widget that doesn't display anything but takes up space
 */
class Spacer {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_SpacerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Spacer);
            }
            throw error;
        }
        this.width = props.width || 1;
        this.height = props.height || 1;
    }
    position(_x, _y) {
    }
    toJson() {
        return [];
    }
}
exports.Spacer = Spacer;
_c = JSII_RTTI_SYMBOL_1;
Spacer[_c] = { fqn: "@aws-cdk/aws-cloudwatch.Spacer", version: "1.165.0" };
/**
 * Return the sum of a list of numbers
 */
function sum(...xs) {
    let ret = 0;
    for (const x of xs) {
        ret += x;
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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