"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = exports.PeriodOverride = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads
 */
var PeriodOverride;
(function (PeriodOverride) {
    /**
     * Period of all graphs on the dashboard automatically adapt to the time range of the dashboard.
     */
    PeriodOverride["AUTO"] = "auto";
    /**
     * Period set for each graph will be used
     */
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_DashboardProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Dashboard);
            }
            throw error;
        }
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        const dashboard = new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.string({
                produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                },
            }),
        });
        this.dashboardName = this.getResourceNameAttribute(dashboard.ref);
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
        this.dashboardArn = core_1.Stack.of(this).formatArn({
            service: 'cloudwatch',
            resource: 'dashboard',
            resourceName: this.physicalName,
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_IWidget(widgets);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addWidgets);
            }
            throw error;
        }
        if (widgets.length === 0) {
            return;
        }
        const warnings = allWidgetsDeep(widgets).flatMap(w => w.warnings ?? []);
        for (const w of warnings) {
            core_1.Annotations.of(this).addWarning(w);
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "@aws-cdk/aws-cloudwatch.Dashboard", version: "1.165.0" };
function allWidgetsDeep(ws) {
    const ret = new Array();
    ws.forEach(recurse);
    return ret;
    function recurse(w) {
        ret.push(w);
        if (hasSubWidgets(w)) {
            w.widgets.forEach(recurse);
        }
    }
}
function hasSubWidgets(w) {
    return 'widgets' in w;
}
//# sourceMappingURL=data:application/json;base64,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