# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator


class VideoSubscriptionPostBody(BaseModel):
    """
    VideoSubscriptionPostBody
    """

    subscription_id: Optional[StrictStr] = Field(
        None, alias="subscriptionId", description="The unique identifier of the video stream subscription"
    )
    customer_id: Optional[StrictInt] = Field(None, alias="customerId", description="Customer of the subscription")
    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    provider: constr(strict=True, max_length=100) = Field(..., description="The code for the provider of the file")
    locale: constr(strict=True, max_length=5, min_length=5) = Field(..., description="The locale of the video")
    source_number: StrictInt = Field(
        ...,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    feed_type: constr(strict=True, max_length=30) = Field(
        ...,
        alias="feedType",
        description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary ",
    )
    output_resolution: constr(strict=True, max_length=30) = Field(
        ...,
        alias="outputResolution",
        description="The resolution that you want to receive the video in.  This is only valid if outputFormat is `RTMP`.  If outputFormat is not `RTMP` then the output resolution is the same as the input resolution.  If specified the output resolution cannot be higher than the input resolution. You must have specific permission to chose anything other than 720p or 1080p. >- `1080` 1920 x 1080 >- `1080i50@10M` SRT 1080i50@10M >- `1080p25@10M` SRT 1080p25@10M >- `1080p50@10M` SRT 1080p50@10M >- `1280x720@2000k` 1280x720@2000k >- `1280x720@3000k` 1280x720@3000k >- `1280x720@3000k25fps` 1280x720@3000k25fps >- `1920x1080@4000k` 1920x1080@4000k >- `1920x1080@4000k25fps` 1920x1080@4000k25fps >- `1920x1080@4500k` 1920x1080@4500k >- `1920x1080@5000k30fps` 1920x1080@5000k30fps >- `2000` 2000 >- `288` 512 x 288 >- `640x320@850k` 640x320@850k >- `720` 1280 x 720 >- `DESKTOP_384x216@280k` DESKTOP_384x216@280k >- `DESKTOP_512x288@500k` DESKTOP_512x288@500k >- `DESKTOP_768x432@1000k` DESKTOP_768x432@1000k >- `MOBILE_320x180@102k` MOBILE_320x180@102k >- `MOBILE_320x180@102k_BUFFERED` MOBILE_320x180@102k_BUFFERED >- `MOBILE_320x180@232k` MOBILE_320x180@232k >- `MOBILE_320x180@232k_BUFFERED` MOBILE_320x180@232k_BUFFERED >- `MOBILE_480x270@464k` MOBILE_480x270@464k >- `MOBILE_480x270@464k_BUFFERED` MOBILE_480x270@464k_BUFFERED >- `MOBILE_768x432@1000k` MOBILE_768x432@1000k >- `MOBILE_768x432@1000k_BUFFERED` MOBILE_768x432@1000k_BUFFERED ",
    )
    output_format: constr(strict=True, max_length=30) = Field(
        ...,
        alias="outputFormat",
        description="The output format >- `HLS` HLS >- `RTMP` RTMP >- `RTMP_PULL` RTMP Pull >- `SRT` SRT ",
    )
    stream_name: Optional[constr(strict=True, max_length=250)] = Field(
        None,
        alias="streamName",
        description="The name/stream key of the RTMP stream. This is an optional part of the RTMP url - not a text description.",
    )
    subscription_name: Optional[constr(strict=True, max_length=250)] = Field(
        None, alias="subscriptionName", description="The name of the subscription"
    )
    output_url: Optional[constr(strict=True, max_length=200)] = Field(
        None,
        alias="outputURL",
        description="The URL to send the output to. Only valid if outputFormat is 'RTMP' or 'SRT'",
    )
    audio: Optional[constr(strict=True, max_length=30)] = Field(
        "BOTH",
        description="Audio >- `AMBIENCE` Only ambience / crowd noise >- `BOTH` Both combined >- `BOTH_SPLIT_LR` Both (Ambience left channel, Commentary right channel) >- `COMMENTARY` Only commentary ",
    )
    content: constr(strict=True, max_length=30) = Field(
        ...,
        description="Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream ",
    )
    mux_rate: Optional[StrictInt] = Field(
        None, alias="muxRate", description="The muxRate of the stream. Required for SRT outputFormat only."
    )
    __properties = [
        "subscriptionId",
        "customerId",
        "fixtureId",
        "provider",
        "locale",
        "sourceNumber",
        "feedType",
        "outputResolution",
        "outputFormat",
        "streamName",
        "subscriptionName",
        "outputURL",
        "audio",
        "content",
        "muxRate",
    ]

    @validator("locale")
    def locale_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", value):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return value

    @validator("feed_type")
    def feed_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("PRIMARY", "ADDITIONAL_ANGLE", "LOW_LATENCY"):
            raise ValueError("must be one of enum values ('PRIMARY', 'ADDITIONAL_ANGLE', 'LOW_LATENCY')")
        return value

    @validator("output_resolution")
    def output_resolution_validate_enum(cls, value):
        """Validates the enum"""
        if value not in (
            "288",
            "720",
            "1080",
            "2000",
            "DESKTOP_768x432@1000k",
            "DESKTOP_512x288@500k",
            "DESKTOP_384x216@280k",
            "MOBILE_768x432@1000k",
            "MOBILE_480x270@464k",
            "MOBILE_320x180@232k",
            "MOBILE_320x180@102k",
            "1920x1080@4000k",
            "1280x720@2000k",
            "640x320@850k",
            "1280x720@3000k25fps",
            "1920x1080@4000k25fps",
            "1920x1080@4500k",
            "1280x720@3000k",
            "1920x1080@5000k30fps",
            "MOBILE_768x432@1000k_BUFFERED",
            "MOBILE_480x270@464k_BUFFERED",
            "MOBILE_320x180@232k_BUFFERED",
            "MOBILE_320x180@102k_BUFFERED",
            "1080i50@10M",
            "1080p25@10M",
            "1080p50@10M",
        ):
            raise ValueError(
                "must be one of enum values ('288', '720', '1080', '2000', 'DESKTOP_768x432@1000k', 'DESKTOP_512x288@500k', 'DESKTOP_384x216@280k', 'MOBILE_768x432@1000k', 'MOBILE_480x270@464k', 'MOBILE_320x180@232k', 'MOBILE_320x180@102k', '1920x1080@4000k', '1280x720@2000k', '640x320@850k', '1280x720@3000k25fps', '1920x1080@4000k25fps', '1920x1080@4500k', '1280x720@3000k', '1920x1080@5000k30fps', 'MOBILE_768x432@1000k_BUFFERED', 'MOBILE_480x270@464k_BUFFERED', 'MOBILE_320x180@232k_BUFFERED', 'MOBILE_320x180@102k_BUFFERED', '1080i50@10M', '1080p25@10M', '1080p50@10M')"
            )
        return value

    @validator("output_format")
    def output_format_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("RTMP", "RTMP_PULL", "HLS", "SRT"):
            raise ValueError("must be one of enum values ('RTMP', 'RTMP_PULL', 'HLS', 'SRT')")
        return value

    @validator("stream_name")
    def stream_name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z.:\/&_?=\-;@]*$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z.:\/&_?=\-;@]*$/")
        return value

    @validator("output_url")
    def output_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z.:\/&_?=\-;@]*$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z.:\/&_?=\-;@]*$/")
        return value

    @validator("audio")
    def audio_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("COMMENTARY", "AMBIENCE", "BOTH", "BOTH_SPLIT_LR"):
            raise ValueError("must be one of enum values ('COMMENTARY', 'AMBIENCE', 'BOTH', 'BOTH_SPLIT_LR')")
        return value

    @validator("content")
    def content_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("CLEAN", "PROGRAM"):
            raise ValueError("must be one of enum values ('CLEAN', 'PROGRAM')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoSubscriptionPostBody:
        """Create an instance of VideoSubscriptionPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if customer_id (nullable) is None
        # and __fields_set__ contains the field
        if self.customer_id is None and "customer_id" in self.__fields_set__:
            _dict["customerId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoSubscriptionPostBody:
        """Create an instance of VideoSubscriptionPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoSubscriptionPostBody.parse_obj(obj)

        _obj = VideoSubscriptionPostBody.parse_obj(
            {
                "subscription_id": obj.get("subscriptionId"),
                "customer_id": obj.get("customerId"),
                "fixture_id": obj.get("fixtureId"),
                "provider": obj.get("provider"),
                "locale": obj.get("locale"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "feed_type": obj.get("feedType"),
                "output_resolution": obj.get("outputResolution"),
                "output_format": obj.get("outputFormat"),
                "stream_name": obj.get("streamName"),
                "subscription_name": obj.get("subscriptionName"),
                "output_url": obj.get("outputURL"),
                "audio": obj.get("audio") if obj.get("audio") is not None else "BOTH",
                "content": obj.get("content"),
                "mux_rate": obj.get("muxRate"),
            }
        )
        return _obj
