# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator


class VideoStreamLocalPostBody(BaseModel):
    """
    VideoStreamLocalPostBody
    """

    url_id: Optional[StrictStr] = Field(None, alias="urlId", description="The unique identifier of the video")
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    provider: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The code for the provider of the file"
    )
    source_number: Optional[StrictInt] = Field(
        1,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    format: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file "
    )
    url: constr(strict=True, max_length=200) = Field(..., description="The URL where the file can be found")
    __properties = ["urlId", "fixtureId", "provider", "sourceNumber", "format", "url"]

    @validator("format")
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("HLS", "MP4"):
            raise ValueError("must be one of enum values ('HLS', 'MP4')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoStreamLocalPostBody:
        """Create an instance of VideoStreamLocalPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoStreamLocalPostBody:
        """Create an instance of VideoStreamLocalPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoStreamLocalPostBody.parse_obj(obj)

        _obj = VideoStreamLocalPostBody.parse_obj(
            {
                "url_id": obj.get("urlId"),
                "fixture_id": obj.get("fixtureId"),
                "provider": obj.get("provider"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "format": obj.get("format"),
                "url": obj.get("url"),
            }
        )
        return _obj
