# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.video_stream_local_model_organization import VideoStreamLocalModelOrganization


class VideoStreamLocalModel(BaseModel):
    """
    VideoStreamLocalModel
    """

    url_id: Optional[StrictStr] = Field(None, alias="urlId", description="The unique identifier of the video")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[VideoStreamLocalModelOrganization] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    provider: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The code for the provider of the file"
    )
    source_number: Optional[StrictInt] = Field(
        1,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    format: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file "
    )
    url: Optional[constr(strict=True, max_length=200)] = Field(None, description="The URL where the file can be found")
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "urlId",
        "organizationId",
        "organization",
        "fixtureId",
        "fixture",
        "provider",
        "sourceNumber",
        "format",
        "url",
        "updated",
        "added",
    ]

    @validator("format")
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("HLS", "MP4"):
            raise ValueError("must be one of enum values ('HLS', 'MP4')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoStreamLocalModel:
        """Create an instance of VideoStreamLocalModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoStreamLocalModel:
        """Create an instance of VideoStreamLocalModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoStreamLocalModel.parse_obj(obj)

        _obj = VideoStreamLocalModel.parse_obj(
            {
                "url_id": obj.get("urlId"),
                "organization_id": obj.get("organizationId"),
                "organization": VideoStreamLocalModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "provider": obj.get("provider"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "format": obj.get("format"),
                "url": obj.get("url"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
