# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.fixtures_model_venue import FixturesModelVenue
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition
from atriumsports.datacore.openapi.models.video_stream_inputs_model_organization import (
    VideoStreamInputsModelOrganization,
)


class VideoStreamInputsModel(BaseModel):
    """
    VideoStreamInputsModel
    """

    video_input_id: Optional[StrictStr] = Field(
        None, alias="videoInputId", description="The unique identifier of the video input"
    )
    master_venue_id: Optional[StrictStr] = Field(
        None, alias="masterVenueId", description="The unique identifier of the master venue"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[VideoStreamInputsModelOrganization] = None
    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    venue: Optional[FixturesModelVenue] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    start_time_local: Optional[datetime] = Field(None, alias="startTimeLocal", description="Start time (Local).")
    start_time_utc: Optional[datetime] = Field(
        None,
        alias="startTimeUTC",
        description="Start time (UTC). This is automatically generated based on the timezone of the venue.",
    )
    finish_recording_time_utc: Optional[datetime] = Field(
        None,
        alias="finishRecordingTimeUTC",
        description="(TO BE REMOVED) Finish Recording time of the stream (if not set, is calculated as startTimeUTC + durationFull from fixtures)",
    )
    estimated_finish_time_utc: Optional[datetime] = Field(
        None,
        alias="estimatedFinishTimeUTC",
        description="Finish Recording time of the stream (if not set, is calculated as startTimeUTC + durationFull from fixtures)",
    )
    provider: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The code for the provider of the file"
    )
    locale: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, description="The locale of the video"
    )
    source_number: Optional[StrictInt] = Field(
        1,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    feed_type: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="feedType",
        description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary ",
    )
    input_resolution: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="inputResolution",
        description="The resolution of the video input >- `1080` 1920 x 1080 >- `288` 512 x 288 >- `720` 1280 x 720 ",
    )
    name: Optional[constr(strict=True, max_length=200)] = Field(None, description="The name of the video source")
    audio_ambience_channel: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="audioAmbienceChannel",
        description="audioAmbienceChannel >- `CHANNEL_BOTH` Both channels >- `CHANNEL_LEFT` Channel left >- `CHANNEL_RIGHT` Channel right >- `NONE` None ",
    )
    audio_commentary_channel: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="audioCommentaryChannel",
        description="audioCommentaryChannel >- `CHANNEL_BOTH` Both channels >- `CHANNEL_LEFT` Channel left >- `CHANNEL_RIGHT` Channel right >- `NONE` None ",
    )
    input_url: Optional[StrictStr] = Field(None, alias="inputURL", description="The URL where the video should be sent")
    stream_name: Optional[constr(strict=True, max_length=250)] = Field(
        None,
        alias="streamName",
        description="The name/stream key of the RTMP stream. This is an optional part of the RTMP url - not a text description.",
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "videoInputId",
        "masterVenueId",
        "organizationId",
        "organization",
        "venueId",
        "venue",
        "competitionId",
        "competition",
        "fixtureId",
        "fixture",
        "startTimeLocal",
        "startTimeUTC",
        "finishRecordingTimeUTC",
        "estimatedFinishTimeUTC",
        "provider",
        "locale",
        "sourceNumber",
        "feedType",
        "inputResolution",
        "name",
        "audioAmbienceChannel",
        "audioCommentaryChannel",
        "inputURL",
        "streamName",
        "updated",
        "added",
    ]

    @validator("locale")
    def locale_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", value):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return value

    @validator("feed_type")
    def feed_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("PRIMARY", "ADDITIONAL_ANGLE", "LOW_LATENCY"):
            raise ValueError("must be one of enum values ('PRIMARY', 'ADDITIONAL_ANGLE', 'LOW_LATENCY')")
        return value

    @validator("input_resolution")
    def input_resolution_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("288", "720", "1080"):
            raise ValueError("must be one of enum values ('288', '720', '1080')")
        return value

    @validator("audio_ambience_channel")
    def audio_ambience_channel_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("CHANNEL_LEFT", "CHANNEL_RIGHT", "CHANNEL_BOTH", "NONE"):
            raise ValueError("must be one of enum values ('CHANNEL_LEFT', 'CHANNEL_RIGHT', 'CHANNEL_BOTH', 'NONE')")
        return value

    @validator("audio_commentary_channel")
    def audio_commentary_channel_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("CHANNEL_LEFT", "CHANNEL_RIGHT", "CHANNEL_BOTH", "NONE"):
            raise ValueError("must be one of enum values ('CHANNEL_LEFT', 'CHANNEL_RIGHT', 'CHANNEL_BOTH', 'NONE')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoStreamInputsModel:
        """Create an instance of VideoStreamInputsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of venue
        if self.venue:
            _dict["venue"] = self.venue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoStreamInputsModel:
        """Create an instance of VideoStreamInputsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoStreamInputsModel.parse_obj(obj)

        _obj = VideoStreamInputsModel.parse_obj(
            {
                "video_input_id": obj.get("videoInputId"),
                "master_venue_id": obj.get("masterVenueId"),
                "organization_id": obj.get("organizationId"),
                "organization": VideoStreamInputsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "venue_id": obj.get("venueId"),
                "venue": FixturesModelVenue.from_dict(obj.get("venue")) if obj.get("venue") is not None else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "start_time_local": obj.get("startTimeLocal"),
                "start_time_utc": obj.get("startTimeUTC"),
                "finish_recording_time_utc": obj.get("finishRecordingTimeUTC"),
                "estimated_finish_time_utc": obj.get("estimatedFinishTimeUTC"),
                "provider": obj.get("provider"),
                "locale": obj.get("locale"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "feed_type": obj.get("feedType"),
                "input_resolution": obj.get("inputResolution"),
                "name": obj.get("name"),
                "audio_ambience_channel": obj.get("audioAmbienceChannel"),
                "audio_commentary_channel": obj.get("audioCommentaryChannel"),
                "input_url": obj.get("inputURL"),
                "stream_name": obj.get("streamName"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
