# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr, validator


class VideoFilePostBody(BaseModel):
    """
    VideoFilePostBody
    """

    video_id: Optional[StrictStr] = Field(None, alias="videoId", description="The unique identifier of the video")
    provider: constr(strict=True, max_length=100) = Field(..., description="The code for the provider of the file")
    locale: constr(strict=True, max_length=5, min_length=5) = Field(..., description="The locale of the video")
    source_number: StrictInt = Field(
        ...,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    fixture_id: StrictStr = Field(..., alias="fixtureId", description="The unique identifier of the fixture")
    resolution: constr(strict=True, max_length=30) = Field(
        ...,
        description="The resolution of the video input >- `1080` 1920 x 1080 >- `288` 512 x 288 >- `720` 1280 x 720 ",
    )
    name: Optional[constr(strict=True, max_length=200)] = Field(
        None, description="The name/description of the video file"
    )
    feed_type: constr(strict=True, max_length=30) = Field(
        ...,
        alias="feedType",
        description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary ",
    )
    content: constr(strict=True, max_length=30) = Field(
        ...,
        description="Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream ",
    )
    fps: StrictInt = Field(..., description="fps for the video stream")
    origin: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        description="The origin of the video file >- None None >- `STREAM` Streamed >- `UPLOAD` Uploaded >- `VENUE` Recorded in venue ",
    )
    format: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="The format of the video file >- `HLS` A HLS play list >- `MP4` One MP4 file "
    )
    storage_provider: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="storageProvider",
        description="Where the video file is stored? >- None None >- `5STREAM` 5stream >- `KEEMOTION` Keemotion >- `SYNERGY` Synergy ",
    )
    size: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Size (Mb) of the video (only given if a single file)"
    )
    length: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Lenth (mins) of the video")
    encoding: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="How is the video/audio encoded. codecs etc."
    )
    url: constr(strict=True, max_length=200) = Field(..., description="The URL where the file can be found")
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        description="What is the status of the file? >- None None >- `AVAILABLE` Available for access >- `BUILDABLE` Not currently available - but can be built on request >- `PENDING` Being added - some parts may be available ",
    )
    start_time: datetime = Field(..., alias="startTime", description="The time this recording started (UTC)")
    expiry: Optional[datetime] = Field(None, description="When does this file expire? (UTC)")
    __properties = [
        "videoId",
        "provider",
        "locale",
        "sourceNumber",
        "fixtureId",
        "resolution",
        "name",
        "feedType",
        "content",
        "fps",
        "origin",
        "format",
        "storageProvider",
        "size",
        "length",
        "encoding",
        "url",
        "status",
        "startTime",
        "expiry",
    ]

    @validator("locale")
    def locale_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", value):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return value

    @validator("resolution")
    def resolution_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("288", "720", "1080"):
            raise ValueError("must be one of enum values ('288', '720', '1080')")
        return value

    @validator("feed_type")
    def feed_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("PRIMARY", "ADDITIONAL_ANGLE", "LOW_LATENCY"):
            raise ValueError("must be one of enum values ('PRIMARY', 'ADDITIONAL_ANGLE', 'LOW_LATENCY')")
        return value

    @validator("content")
    def content_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("CLEAN", "PROGRAM"):
            raise ValueError("must be one of enum values ('CLEAN', 'PROGRAM')")
        return value

    @validator("origin")
    def origin_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("STREAM", "VENUE", "UPLOAD", "null"):
            raise ValueError("must be one of enum values ('STREAM', 'VENUE', 'UPLOAD', 'null')")
        return value

    @validator("format")
    def format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("HLS", "MP4"):
            raise ValueError("must be one of enum values ('HLS', 'MP4')")
        return value

    @validator("storage_provider")
    def storage_provider_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("5STREAM", "KEEMOTION", "SYNERGY", "null"):
            raise ValueError("must be one of enum values ('5STREAM', 'KEEMOTION', 'SYNERGY', 'null')")
        return value

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("AVAILABLE", "BUILDABLE", "PENDING", "null"):
            raise ValueError("must be one of enum values ('AVAILABLE', 'BUILDABLE', 'PENDING', 'null')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoFilePostBody:
        """Create an instance of VideoFilePostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if origin (nullable) is None
        # and __fields_set__ contains the field
        if self.origin is None and "origin" in self.__fields_set__:
            _dict["origin"] = None

        # set to None if storage_provider (nullable) is None
        # and __fields_set__ contains the field
        if self.storage_provider is None and "storage_provider" in self.__fields_set__:
            _dict["storageProvider"] = None

        # set to None if size (nullable) is None
        # and __fields_set__ contains the field
        if self.size is None and "size" in self.__fields_set__:
            _dict["size"] = None

        # set to None if length (nullable) is None
        # and __fields_set__ contains the field
        if self.length is None and "length" in self.__fields_set__:
            _dict["length"] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict["status"] = None

        # set to None if expiry (nullable) is None
        # and __fields_set__ contains the field
        if self.expiry is None and "expiry" in self.__fields_set__:
            _dict["expiry"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoFilePostBody:
        """Create an instance of VideoFilePostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoFilePostBody.parse_obj(obj)

        _obj = VideoFilePostBody.parse_obj(
            {
                "video_id": obj.get("videoId"),
                "provider": obj.get("provider"),
                "locale": obj.get("locale"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "fixture_id": obj.get("fixtureId"),
                "resolution": obj.get("resolution"),
                "name": obj.get("name"),
                "feed_type": obj.get("feedType"),
                "content": obj.get("content"),
                "fps": obj.get("fps") if obj.get("fps") is not None else 25,
                "origin": obj.get("origin"),
                "format": obj.get("format"),
                "storage_provider": obj.get("storageProvider"),
                "size": obj.get("size"),
                "length": obj.get("length"),
                "encoding": obj.get("encoding"),
                "url": obj.get("url"),
                "status": obj.get("status"),
                "start_time": obj.get("startTime"),
                "expiry": obj.get("expiry"),
            }
        )
        return _obj
