# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import List, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.social_media import SocialMedia
from atriumsports.datacore.openapi.models.venue_address import VenueAddress
from atriumsports.datacore.openapi.models.venue_historical_name import VenueHistoricalName
from atriumsports.datacore.openapi.models.venues_model_organization import VenuesModelOrganization
from atriumsports.datacore.openapi.models.venues_model_site import VenuesModelSite


class VenuesModel(BaseModel):
    """
    VenuesModel
    """

    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    site_id: Optional[StrictStr] = Field(None, alias="siteId", description="The site that this venue belongs to")
    site: Optional[VenuesModelSite] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[VenuesModelOrganization] = None
    abbreviation_local: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the venue in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        "ACTIVE", description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    alternate_name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="alternateNameLocal", description="The alternate name of the venue, in Local Language"
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the venue in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    alternate_name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="alternateNameLatin", description="The alternate name of the venue, in Latin characters"
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the venue. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    timezone: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        description="Timezone of the venue.  The name of the zone as defined by the IANA TZ database. https://en.wikipedia.org/wiki/List_of_tz_database_time_zones",
    )
    address: Optional[VenueAddress] = None
    social: Optional[SocialMedia] = None
    capacity: Optional[StrictInt] = Field(
        None,
        description="This is the maximum number of people allowed for the venue in normal use. Certain events/configurations of the venue may cause this capacity to be increased/decreased - this is not reflected in this value.",
    )
    historical_names: Optional[conlist(VenueHistoricalName)] = Field(
        None, alias="historicalNames", description="Array of venue historical names"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    master_venue_id: Optional[StrictStr] = Field(
        None, alias="masterVenueId", description="The unique identifier of the master venue"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "venueId",
        "siteId",
        "site",
        "organizationId",
        "organization",
        "abbreviationLocal",
        "nameLocal",
        "status",
        "alternateNameLocal",
        "abbreviationLatin",
        "nameLatin",
        "alternateNameLatin",
        "countryCode",
        "timezone",
        "address",
        "social",
        "capacity",
        "historicalNames",
        "externalId",
        "masterVenueId",
        "updated",
        "added",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VenuesModel:
        """Create an instance of VenuesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "master_venue_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict["site"] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # set to None if site_id (nullable) is None
        # and __fields_set__ contains the field
        if self.site_id is None and "site_id" in self.__fields_set__:
            _dict["siteId"] = None

        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if alternate_name_local (nullable) is None
        # and __fields_set__ contains the field
        if self.alternate_name_local is None and "alternate_name_local" in self.__fields_set__:
            _dict["alternateNameLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if alternate_name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.alternate_name_latin is None and "alternate_name_latin" in self.__fields_set__:
            _dict["alternateNameLatin"] = None

        # set to None if country_code (nullable) is None
        # and __fields_set__ contains the field
        if self.country_code is None and "country_code" in self.__fields_set__:
            _dict["countryCode"] = None

        # set to None if address (nullable) is None
        # and __fields_set__ contains the field
        if self.address is None and "address" in self.__fields_set__:
            _dict["address"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if capacity (nullable) is None
        # and __fields_set__ contains the field
        if self.capacity is None and "capacity" in self.__fields_set__:
            _dict["capacity"] = None

        # set to None if historical_names (nullable) is None
        # and __fields_set__ contains the field
        if self.historical_names is None and "historical_names" in self.__fields_set__:
            _dict["historicalNames"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VenuesModel:
        """Create an instance of VenuesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VenuesModel.parse_obj(obj)

        _obj = VenuesModel.parse_obj(
            {
                "venue_id": obj.get("venueId"),
                "site_id": obj.get("siteId"),
                "site": VenuesModelSite.from_dict(obj.get("site")) if obj.get("site") is not None else None,
                "organization_id": obj.get("organizationId"),
                "organization": VenuesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "status": obj.get("status") if obj.get("status") is not None else "ACTIVE",
                "alternate_name_local": obj.get("alternateNameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "alternate_name_latin": obj.get("alternateNameLatin"),
                "country_code": obj.get("countryCode"),
                "timezone": obj.get("timezone"),
                "address": VenueAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "capacity": obj.get("capacity"),
                "historical_names": [VenueHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "external_id": obj.get("externalId"),
                "master_venue_id": obj.get("masterVenueId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
