# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition
from atriumsports.datacore.openapi.models.transfer_component import TransferComponent
from atriumsports.datacore.openapi.models.transfers_model_organization import TransfersModelOrganization


class TransfersModel(BaseModel):
    """
    TransfersModel
    """

    transfer_id: Optional[StrictStr] = Field(
        None, alias="transferId", description="The unique identifier of the transfer"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[TransfersModelOrganization] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    components: Optional[conlist(TransferComponent)] = Field(None, description="List of transfer components")
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        description="Transfer Status >- None None >- `APPROVED` Approved >- `DECLINED` Decline >- `PENDING` Pending ",
    )
    reference: Optional[constr(strict=True, max_length=100)] = Field(None, description="Transfer reference number")
    transfer_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="transferType",
        description="Type of transfer >- `DROPPED` Dropped >- `OTHER` Other >- `PERMIT` Permit >- `TRADE` Trade >- `TRANSFER` Transfer ",
    )
    date_transfer: Optional[date] = Field(None, alias="dateTransfer", description="Date of transfer")
    date_permit_from: Optional[date] = Field(None, alias="datePermitFrom", description="Date the permit started")
    date_permit_to: Optional[date] = Field(None, alias="datePermitTo", description="Date the permit ended")
    notes: Optional[constr(strict=True, max_length=1000)] = Field(None, description="Notes")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "transferId",
        "organizationId",
        "organization",
        "competitionId",
        "competition",
        "seasonId",
        "season",
        "components",
        "status",
        "reference",
        "transferType",
        "dateTransfer",
        "datePermitFrom",
        "datePermitTo",
        "notes",
        "externalId",
        "updated",
        "added",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("APPROVED", "PENDING", "DECLINED", "null"):
            raise ValueError("must be one of enum values ('APPROVED', 'PENDING', 'DECLINED', 'null')")
        return value

    @validator("transfer_type")
    def transfer_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("TRADE", "TRANSFER", "DROPPED", "PERMIT", "OTHER"):
            raise ValueError("must be one of enum values ('TRADE', 'TRANSFER', 'DROPPED', 'PERMIT', 'OTHER')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransfersModel:
        """Create an instance of TransfersModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in components (list)
        _items = []
        if self.components:
            for _item in self.components:
                if _item:
                    _items.append(_item.to_dict())
            _dict["components"] = _items
        # set to None if components (nullable) is None
        # and __fields_set__ contains the field
        if self.components is None and "components" in self.__fields_set__:
            _dict["components"] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict["status"] = None

        # set to None if date_transfer (nullable) is None
        # and __fields_set__ contains the field
        if self.date_transfer is None and "date_transfer" in self.__fields_set__:
            _dict["dateTransfer"] = None

        # set to None if date_permit_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_permit_from is None and "date_permit_from" in self.__fields_set__:
            _dict["datePermitFrom"] = None

        # set to None if date_permit_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_permit_to is None and "date_permit_to" in self.__fields_set__:
            _dict["datePermitTo"] = None

        # set to None if notes (nullable) is None
        # and __fields_set__ contains the field
        if self.notes is None and "notes" in self.__fields_set__:
            _dict["notes"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransfersModel:
        """Create an instance of TransfersModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransfersModel.parse_obj(obj)

        _obj = TransfersModel.parse_obj(
            {
                "transfer_id": obj.get("transferId"),
                "organization_id": obj.get("organizationId"),
                "organization": TransfersModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "components": [TransferComponent.from_dict(_item) for _item in obj.get("components")]
                if obj.get("components") is not None
                else None,
                "status": obj.get("status"),
                "reference": obj.get("reference"),
                "transfer_type": obj.get("transferType"),
                "date_transfer": obj.get("dateTransfer"),
                "date_permit_from": obj.get("datePermitFrom"),
                "date_permit_to": obj.get("datePermitTo"),
                "notes": obj.get("notes"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
