# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_conference import FixtureEntitiesModelConference
from atriumsports.datacore.openapi.models.fixture_entities_model_division import FixtureEntitiesModelDivision
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.fixtures_model_round import FixturesModelRound
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_pool import (
    SeasonFixtureStagesPoolsListModelPool,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)
from atriumsports.datacore.openapi.models.seasons_model_standing_configuration import SeasonsModelStandingConfiguration
from atriumsports.datacore.openapi.models.standing_post_body_calculated_value import StandingPostBodyCalculatedValue
from atriumsports.datacore.openapi.models.standing_post_body_points_value import StandingPostBodyPointsValue
from atriumsports.datacore.openapi.models.standings_model_organization import StandingsModelOrganization


class StandingsModel(BaseModel):
    """
    StandingsModel
    """

    standing_id: Optional[StrictStr] = Field(
        None, alias="standingId", description="The unique identifier of the standing"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[StandingsModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    division: Optional[FixtureEntitiesModelDivision] = None
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    conference: Optional[FixtureEntitiesModelConference] = None
    in_progress: Optional[StrictBool] = Field(
        None, alias="inProgress", description="Is the competitor in a current In-Progress fixture?"
    )
    live: Optional[StrictBool] = Field(None, description="Is this including live fixtures?")
    locked: Optional[StrictBool] = Field(None, description="Has the standing been locked (to prevent editing)?")
    grouping_base: Optional[constr(strict=True, max_length=50)] = Field(
        None, alias="groupingBase", description="Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round "
    )
    grouping_conference_division: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="groupingConferenceDivision",
        description="Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall ",
    )
    grouping_stage_pool: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="groupingStagePool",
        description="Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool ",
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    pool: Optional[SeasonFixtureStagesPoolsListModelPool] = None
    round_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    round: Optional[FixturesModelRound] = None
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the ~standingConfiguration~"
    )
    standing_configuration: Optional[SeasonsModelStandingConfiguration] = Field(None, alias="standingConfiguration")
    fixture_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    position: Optional[StrictInt] = Field(None, description="Position of the competitors standing record")
    secured_finals: Optional[StrictStr] = Field(
        None, alias="securedFinals", description="Has competitor secured a finals position"
    )
    points: Optional[Dict[str, StandingPostBodyPointsValue]] = Field(None, description="standings points fields")
    calculated: Optional[Dict[str, StandingPostBodyCalculatedValue]] = Field(
        None, description="standings points fields"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    auto_generated: Optional[StrictBool] = Field(
        None, alias="autoGenerated", description="Was this row auto generated?"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "standingId",
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "entityId",
        "entity",
        "divisionId",
        "division",
        "conferenceId",
        "conference",
        "inProgress",
        "live",
        "locked",
        "groupingBase",
        "groupingConferenceDivision",
        "groupingStagePool",
        "stageCode",
        "stage",
        "poolCode",
        "pool",
        "roundCode",
        "round",
        "roundNumber",
        "standingConfigurationId",
        "standingConfiguration",
        "fixtureType",
        "position",
        "securedFinals",
        "points",
        "calculated",
        "externalId",
        "autoGenerated",
        "updated",
        "added",
    ]

    @validator("grouping_base")
    def grouping_base_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "ROUND"):
            raise ValueError("must be one of enum values ('OVERALL', 'ROUND')")
        return value

    @validator("grouping_conference_division")
    def grouping_conference_division_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "CONFERENCE", "DIVISION"):
            raise ValueError("must be one of enum values ('OVERALL', 'CONFERENCE', 'DIVISION')")
        return value

    @validator("grouping_stage_pool")
    def grouping_stage_pool_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "STAGE", "STAGEPOOL"):
            raise ValueError("must be one of enum values ('OVERALL', 'STAGE', 'STAGEPOOL')")
        return value

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must be one of enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingsModel:
        """Create an instance of StandingsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "auto_generated",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of division
        if self.division:
            _dict["division"] = self.division.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference
        if self.conference:
            _dict["conference"] = self.conference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict["pool"] = self.pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of round
        if self.round:
            _dict["round"] = self.round.to_dict()
        # override the default output from pydantic by calling `to_dict()` of standing_configuration
        if self.standing_configuration:
            _dict["standingConfiguration"] = self.standing_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in points (dict)
        _field_dict = {}
        if self.points:
            for _key in self.points:
                if self.points[_key]:
                    _field_dict[_key] = self.points[_key].to_dict()
            _dict["points"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in calculated (dict)
        _field_dict = {}
        if self.calculated:
            for _key in self.calculated:
                if self.calculated[_key]:
                    _field_dict[_key] = self.calculated[_key].to_dict()
            _dict["calculated"] = _field_dict
        # set to None if division_id (nullable) is None
        # and __fields_set__ contains the field
        if self.division_id is None and "division_id" in self.__fields_set__:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        # and __fields_set__ contains the field
        if self.conference_id is None and "conference_id" in self.__fields_set__:
            _dict["conferenceId"] = None

        # set to None if stage_code (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_code is None and "stage_code" in self.__fields_set__:
            _dict["stageCode"] = None

        # set to None if pool_code (nullable) is None
        # and __fields_set__ contains the field
        if self.pool_code is None and "pool_code" in self.__fields_set__:
            _dict["poolCode"] = None

        # set to None if round_code (nullable) is None
        # and __fields_set__ contains the field
        if self.round_code is None and "round_code" in self.__fields_set__:
            _dict["roundCode"] = None

        # set to None if round_number (nullable) is None
        # and __fields_set__ contains the field
        if self.round_number is None and "round_number" in self.__fields_set__:
            _dict["roundNumber"] = None

        # set to None if standing_configuration_id (nullable) is None
        # and __fields_set__ contains the field
        if self.standing_configuration_id is None and "standing_configuration_id" in self.__fields_set__:
            _dict["standingConfigurationId"] = None

        # set to None if position (nullable) is None
        # and __fields_set__ contains the field
        if self.position is None and "position" in self.__fields_set__:
            _dict["position"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingsModel:
        """Create an instance of StandingsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StandingsModel.parse_obj(obj)

        _obj = StandingsModel.parse_obj(
            {
                "standing_id": obj.get("standingId"),
                "organization_id": obj.get("organizationId"),
                "organization": StandingsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "division_id": obj.get("divisionId"),
                "division": FixtureEntitiesModelDivision.from_dict(obj.get("division"))
                if obj.get("division") is not None
                else None,
                "conference_id": obj.get("conferenceId"),
                "conference": FixtureEntitiesModelConference.from_dict(obj.get("conference"))
                if obj.get("conference") is not None
                else None,
                "in_progress": obj.get("inProgress"),
                "live": obj.get("live"),
                "locked": obj.get("locked"),
                "grouping_base": obj.get("groupingBase"),
                "grouping_conference_division": obj.get("groupingConferenceDivision"),
                "grouping_stage_pool": obj.get("groupingStagePool"),
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "pool_code": obj.get("poolCode"),
                "pool": SeasonFixtureStagesPoolsListModelPool.from_dict(obj.get("pool"))
                if obj.get("pool") is not None
                else None,
                "round_code": obj.get("roundCode"),
                "round": FixturesModelRound.from_dict(obj.get("round")) if obj.get("round") is not None else None,
                "round_number": obj.get("roundNumber"),
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "standing_configuration": SeasonsModelStandingConfiguration.from_dict(obj.get("standingConfiguration"))
                if obj.get("standingConfiguration") is not None
                else None,
                "fixture_type": obj.get("fixtureType"),
                "position": obj.get("position"),
                "secured_finals": obj.get("securedFinals"),
                "points": dict((_k, StandingPostBodyPointsValue.from_dict(_v)) for _k, _v in obj.get("points").items())
                if obj.get("points") is not None
                else None,
                "calculated": dict(
                    (_k, StandingPostBodyCalculatedValue.from_dict(_v)) for _k, _v in obj.get("calculated").items()
                )
                if obj.get("calculated") is not None
                else None,
                "external_id": obj.get("externalId"),
                "auto_generated": obj.get("autoGenerated"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
