# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.standing_post_body_calculated_value import StandingPostBodyCalculatedValue
from atriumsports.datacore.openapi.models.standing_post_body_points_value import StandingPostBodyPointsValue


class StandingPutBody(BaseModel):
    """
    StandingPutBody
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    in_progress: Optional[StrictBool] = Field(
        None, alias="inProgress", description="Is the competitor in a current In-Progress fixture?"
    )
    live: Optional[StrictBool] = Field(None, description="Is this including live fixtures?")
    locked: Optional[StrictBool] = Field(None, description="Has the standing been locked (to prevent editing)?")
    grouping_base: Optional[constr(strict=True, max_length=50)] = Field(
        None, alias="groupingBase", description="Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round "
    )
    grouping_conference_division: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="groupingConferenceDivision",
        description="Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall ",
    )
    grouping_stage_pool: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="groupingStagePool",
        description="Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool ",
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    round_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundCode", description="A unique code for the round. (Unique for season)"
    )
    round_number: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="roundNumber", description="The number given to the round"
    )
    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the ~standingConfiguration~"
    )
    fixture_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    position: Optional[StrictInt] = Field(None, description="Position of the competitors standing record")
    secured_finals: Optional[StrictStr] = Field(
        None, alias="securedFinals", description="Has competitor secured a finals position"
    )
    points: Optional[Dict[str, StandingPostBodyPointsValue]] = Field(None, description="standings points fields")
    calculated: Optional[Dict[str, StandingPostBodyCalculatedValue]] = Field(
        None, description="standings points fields"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "seasonId",
        "entityId",
        "divisionId",
        "conferenceId",
        "inProgress",
        "live",
        "locked",
        "groupingBase",
        "groupingConferenceDivision",
        "groupingStagePool",
        "stageCode",
        "poolCode",
        "roundCode",
        "roundNumber",
        "standingConfigurationId",
        "fixtureType",
        "position",
        "securedFinals",
        "points",
        "calculated",
        "externalId",
    ]

    @validator("grouping_base")
    def grouping_base_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "ROUND"):
            raise ValueError("must be one of enum values ('OVERALL', 'ROUND')")
        return value

    @validator("grouping_conference_division")
    def grouping_conference_division_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "CONFERENCE", "DIVISION"):
            raise ValueError("must be one of enum values ('OVERALL', 'CONFERENCE', 'DIVISION')")
        return value

    @validator("grouping_stage_pool")
    def grouping_stage_pool_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("OVERALL", "STAGE", "STAGEPOOL"):
            raise ValueError("must be one of enum values ('OVERALL', 'STAGE', 'STAGEPOOL')")
        return value

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must be one of enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingPutBody:
        """Create an instance of StandingPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in points (dict)
        _field_dict = {}
        if self.points:
            for _key in self.points:
                if self.points[_key]:
                    _field_dict[_key] = self.points[_key].to_dict()
            _dict["points"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in calculated (dict)
        _field_dict = {}
        if self.calculated:
            for _key in self.calculated:
                if self.calculated[_key]:
                    _field_dict[_key] = self.calculated[_key].to_dict()
            _dict["calculated"] = _field_dict
        # set to None if division_id (nullable) is None
        # and __fields_set__ contains the field
        if self.division_id is None and "division_id" in self.__fields_set__:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        # and __fields_set__ contains the field
        if self.conference_id is None and "conference_id" in self.__fields_set__:
            _dict["conferenceId"] = None

        # set to None if stage_code (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_code is None and "stage_code" in self.__fields_set__:
            _dict["stageCode"] = None

        # set to None if pool_code (nullable) is None
        # and __fields_set__ contains the field
        if self.pool_code is None and "pool_code" in self.__fields_set__:
            _dict["poolCode"] = None

        # set to None if round_code (nullable) is None
        # and __fields_set__ contains the field
        if self.round_code is None and "round_code" in self.__fields_set__:
            _dict["roundCode"] = None

        # set to None if round_number (nullable) is None
        # and __fields_set__ contains the field
        if self.round_number is None and "round_number" in self.__fields_set__:
            _dict["roundNumber"] = None

        # set to None if standing_configuration_id (nullable) is None
        # and __fields_set__ contains the field
        if self.standing_configuration_id is None and "standing_configuration_id" in self.__fields_set__:
            _dict["standingConfigurationId"] = None

        # set to None if position (nullable) is None
        # and __fields_set__ contains the field
        if self.position is None and "position" in self.__fields_set__:
            _dict["position"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingPutBody:
        """Create an instance of StandingPutBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StandingPutBody.parse_obj(obj)

        _obj = StandingPutBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "division_id": obj.get("divisionId"),
                "conference_id": obj.get("conferenceId"),
                "in_progress": obj.get("inProgress"),
                "live": obj.get("live"),
                "locked": obj.get("locked"),
                "grouping_base": obj.get("groupingBase"),
                "grouping_conference_division": obj.get("groupingConferenceDivision"),
                "grouping_stage_pool": obj.get("groupingStagePool"),
                "stage_code": obj.get("stageCode"),
                "pool_code": obj.get("poolCode"),
                "round_code": obj.get("roundCode"),
                "round_number": obj.get("roundNumber"),
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "fixture_type": obj.get("fixtureType"),
                "position": obj.get("position"),
                "secured_finals": obj.get("securedFinals"),
                "points": dict((_k, StandingPostBodyPointsValue.from_dict(_v)) for _k, _v in obj.get("points").items())
                if obj.get("points") is not None
                else None,
                "calculated": dict(
                    (_k, StandingPostBodyCalculatedValue.from_dict(_v)) for _k, _v in obj.get("calculated").items()
                )
                if obj.get("calculated") is not None
                else None,
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
