# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr


class StandingPostBodyCalculatedValue(BaseModel):
    """
    Type of points
    """

    played: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Fixtures played")
    played_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="playedHome", description="Fixtures played at home"
    )
    played_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="playedAway", description="Fixtures played away"
    )
    washouts: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Number of washed out fixtures")
    wins: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Fixtures Won")
    wins_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winsHome", description="Fixtures Won at home"
    )
    wins_away: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="winsAway", description="Fixtures Won away")
    losses: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Fixtures Lost")
    losses_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lossesHome", description="Fixtures Lost at home"
    )
    losses_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lossesAway", description="Fixtures Lost away"
    )
    draws: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Fixtures Drawn")
    draws_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="drawsHome", description="Fixtures Drawn at home"
    )
    draws_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="drawsAway", description="Fixtures Drawn away"
    )
    byes: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Fixtures Byes")
    forfeits_given: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="forfeitsGiven", description="Fixtures Forfeits Given"
    )
    forfeits_won_by: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="forfeitsWonBy", description="Fixtures Forfeits Won"
    )
    win_percentage_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentageDisplay", description="Win Percentage (wins/played) (Display Value)"
    )
    win_percentage_home_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentageHomeDisplay", description="Win Percentage Home (wins/played) (Display Value)"
    )
    win_percentage_away_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentageAwayDisplay", description="Win Percentage Away (wins/played) (Display Value)"
    )
    win_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentage", description="Win Percentage (wins/played)"
    )
    win_percentage_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentageHome", description="Win Percentage Home (wins/played)"
    )
    win_percentage_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="winPercentageAway", description="Win Percentage Away (wins/played)"
    )
    scored_for: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="scoredFor", description="Scored For")
    scored_for_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="scoredForHome", description="Scored For at home"
    )
    scored_for_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="scoredForAway", description="Scored For away"
    )
    scored_against: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="scoredAgainst", description="Scored For"
    )
    scored_against_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="scoredAgainstHome", description="Scored Against at home"
    )
    scored_against_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="scoredAgainstAway", description="Scored Against away"
    )
    percentage_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="percentageDisplay", description="For versus Against (Display Value)"
    )
    percentage_home_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="percentageHomeDisplay", description="For versus Against at home (Display Value)"
    )
    percentage_away_display: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="percentageAwayDisplay", description="For versus Against away (Display Value)"
    )
    percentage: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="For versus Against")
    percentage_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="percentageHome", description="For versus Against at home"
    )
    percentage_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="percentageAway", description="For versus Against away"
    )
    point_difference: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="pointDifference", description="Point Difference for competitor"
    )
    point_difference_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="pointDifferenceHome", description="Point Difference for competitor at Home"
    )
    point_difference_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="pointDifferenceAway", description="Point Difference for competitor away"
    )
    lowest_score_for: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreFor", description="Lowest Score for competitor"
    )
    lowest_score_for_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreForHome", description="Lowest Score for competitor at Home"
    )
    lowest_score_for_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreForAway", description="Lowest Score for competitor away"
    )
    highest_score_for: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreFor", description="Highest Score for competitor"
    )
    highest_score_for_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreForHome", description="Highest Score for competitor at Home"
    )
    highest_score_for_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreForAway", description="Highest Score for competitor away"
    )
    lowest_score_against: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreAgainst", description="Lowest Score against competitor"
    )
    lowest_score_against_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreAgainstHome", description="Lowest Score against competitor at Home"
    )
    lowest_score_against_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="lowestScoreAgainstAway", description="Lowest Score against competitor away"
    )
    highest_score_against: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreAgainst", description="Highest Score against competitor"
    )
    highest_score_against_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreAgainstHome", description="Highest Score against competitor at Home"
    )
    highest_score_against_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="highestScoreAgainstAway", description="Highest Score against competitor away"
    )
    streak: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Winning streak for competitor")
    streak_home: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="streakHome", description="Winning streak for competitor at Home"
    )
    streak_away: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="streakAway", description="Winning streak for competitor away"
    )
    result_string: Optional[StrictStr] = Field(
        None, alias="resultString", description="Result string for competitor (W,L,D per match)"
    )
    result_string_home: Optional[StrictStr] = Field(
        None, alias="resultStringHome", description="Result string for competitor at Home (W,L,D per match)"
    )
    result_string_away: Optional[StrictStr] = Field(
        None, alias="resultStringAway", description="Result string for competitor away (W,L,D per match)"
    )
    __properties = [
        "played",
        "playedHome",
        "playedAway",
        "washouts",
        "wins",
        "winsHome",
        "winsAway",
        "losses",
        "lossesHome",
        "lossesAway",
        "draws",
        "drawsHome",
        "drawsAway",
        "byes",
        "forfeitsGiven",
        "forfeitsWonBy",
        "winPercentageDisplay",
        "winPercentageHomeDisplay",
        "winPercentageAwayDisplay",
        "winPercentage",
        "winPercentageHome",
        "winPercentageAway",
        "scoredFor",
        "scoredForHome",
        "scoredForAway",
        "scoredAgainst",
        "scoredAgainstHome",
        "scoredAgainstAway",
        "percentageDisplay",
        "percentageHomeDisplay",
        "percentageAwayDisplay",
        "percentage",
        "percentageHome",
        "percentageAway",
        "pointDifference",
        "pointDifferenceHome",
        "pointDifferenceAway",
        "lowestScoreFor",
        "lowestScoreForHome",
        "lowestScoreForAway",
        "highestScoreFor",
        "highestScoreForHome",
        "highestScoreForAway",
        "lowestScoreAgainst",
        "lowestScoreAgainstHome",
        "lowestScoreAgainstAway",
        "highestScoreAgainst",
        "highestScoreAgainstHome",
        "highestScoreAgainstAway",
        "streak",
        "streakHome",
        "streakAway",
        "resultString",
        "resultStringHome",
        "resultStringAway",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingPostBodyCalculatedValue:
        """Create an instance of StandingPostBodyCalculatedValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if lowest_score_for (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_for is None and "lowest_score_for" in self.__fields_set__:
            _dict["lowestScoreFor"] = None

        # set to None if lowest_score_for_home (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_for_home is None and "lowest_score_for_home" in self.__fields_set__:
            _dict["lowestScoreForHome"] = None

        # set to None if lowest_score_for_away (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_for_away is None and "lowest_score_for_away" in self.__fields_set__:
            _dict["lowestScoreForAway"] = None

        # set to None if highest_score_for (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_for is None and "highest_score_for" in self.__fields_set__:
            _dict["highestScoreFor"] = None

        # set to None if highest_score_for_home (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_for_home is None and "highest_score_for_home" in self.__fields_set__:
            _dict["highestScoreForHome"] = None

        # set to None if highest_score_for_away (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_for_away is None and "highest_score_for_away" in self.__fields_set__:
            _dict["highestScoreForAway"] = None

        # set to None if lowest_score_against (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_against is None and "lowest_score_against" in self.__fields_set__:
            _dict["lowestScoreAgainst"] = None

        # set to None if lowest_score_against_home (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_against_home is None and "lowest_score_against_home" in self.__fields_set__:
            _dict["lowestScoreAgainstHome"] = None

        # set to None if lowest_score_against_away (nullable) is None
        # and __fields_set__ contains the field
        if self.lowest_score_against_away is None and "lowest_score_against_away" in self.__fields_set__:
            _dict["lowestScoreAgainstAway"] = None

        # set to None if highest_score_against (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_against is None and "highest_score_against" in self.__fields_set__:
            _dict["highestScoreAgainst"] = None

        # set to None if highest_score_against_home (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_against_home is None and "highest_score_against_home" in self.__fields_set__:
            _dict["highestScoreAgainstHome"] = None

        # set to None if highest_score_against_away (nullable) is None
        # and __fields_set__ contains the field
        if self.highest_score_against_away is None and "highest_score_against_away" in self.__fields_set__:
            _dict["highestScoreAgainstAway"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingPostBodyCalculatedValue:
        """Create an instance of StandingPostBodyCalculatedValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StandingPostBodyCalculatedValue.parse_obj(obj)

        _obj = StandingPostBodyCalculatedValue.parse_obj(
            {
                "played": obj.get("played"),
                "played_home": obj.get("playedHome"),
                "played_away": obj.get("playedAway"),
                "washouts": obj.get("washouts"),
                "wins": obj.get("wins"),
                "wins_home": obj.get("winsHome"),
                "wins_away": obj.get("winsAway"),
                "losses": obj.get("losses"),
                "losses_home": obj.get("lossesHome"),
                "losses_away": obj.get("lossesAway"),
                "draws": obj.get("draws"),
                "draws_home": obj.get("drawsHome"),
                "draws_away": obj.get("drawsAway"),
                "byes": obj.get("byes"),
                "forfeits_given": obj.get("forfeitsGiven"),
                "forfeits_won_by": obj.get("forfeitsWonBy"),
                "win_percentage_display": obj.get("winPercentageDisplay"),
                "win_percentage_home_display": obj.get("winPercentageHomeDisplay"),
                "win_percentage_away_display": obj.get("winPercentageAwayDisplay"),
                "win_percentage": obj.get("winPercentage"),
                "win_percentage_home": obj.get("winPercentageHome"),
                "win_percentage_away": obj.get("winPercentageAway"),
                "scored_for": obj.get("scoredFor"),
                "scored_for_home": obj.get("scoredForHome"),
                "scored_for_away": obj.get("scoredForAway"),
                "scored_against": obj.get("scoredAgainst"),
                "scored_against_home": obj.get("scoredAgainstHome"),
                "scored_against_away": obj.get("scoredAgainstAway"),
                "percentage_display": obj.get("percentageDisplay"),
                "percentage_home_display": obj.get("percentageHomeDisplay"),
                "percentage_away_display": obj.get("percentageAwayDisplay"),
                "percentage": obj.get("percentage"),
                "percentage_home": obj.get("percentageHome"),
                "percentage_away": obj.get("percentageAway"),
                "point_difference": obj.get("pointDifference"),
                "point_difference_home": obj.get("pointDifferenceHome"),
                "point_difference_away": obj.get("pointDifferenceAway"),
                "lowest_score_for": obj.get("lowestScoreFor"),
                "lowest_score_for_home": obj.get("lowestScoreForHome"),
                "lowest_score_for_away": obj.get("lowestScoreForAway"),
                "highest_score_for": obj.get("highestScoreFor"),
                "highest_score_for_home": obj.get("highestScoreForHome"),
                "highest_score_for_away": obj.get("highestScoreForAway"),
                "lowest_score_against": obj.get("lowestScoreAgainst"),
                "lowest_score_against_home": obj.get("lowestScoreAgainstHome"),
                "lowest_score_against_away": obj.get("lowestScoreAgainstAway"),
                "highest_score_against": obj.get("highestScoreAgainst"),
                "highest_score_against_home": obj.get("highestScoreAgainstHome"),
                "highest_score_against_away": obj.get("highestScoreAgainstAway"),
                "streak": obj.get("streak"),
                "streak_home": obj.get("streakHome"),
                "streak_away": obj.get("streakAway"),
                "result_string": obj.get("resultString"),
                "result_string_home": obj.get("resultStringHome"),
                "result_string_away": obj.get("resultStringAway"),
            }
        )
        return _obj
