# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.standing_building import StandingBuilding
from atriumsports.datacore.openapi.models.standing_configuration import StandingConfiguration


class StandingConfigurationsPostBody(BaseModel):
    """
    StandingConfigurationsPostBody
    """

    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the configuration"
    )
    name_local: constr(strict=True, max_length=150) = Field(
        ...,
        alias="nameLocal",
        description="The name of the ~standing_configurations~ in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the ~standing_configurations~ in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    build_rules: Optional[StandingBuilding] = Field(None, alias="buildRules")
    configuration: Optional[StandingConfiguration] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = ["standingConfigurationId", "nameLocal", "nameLatin", "buildRules", "configuration", "externalId"]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingConfigurationsPostBody:
        """Create an instance of StandingConfigurationsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of build_rules
        if self.build_rules:
            _dict["buildRules"] = self.build_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict["configuration"] = self.configuration.to_dict()
        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingConfigurationsPostBody:
        """Create an instance of StandingConfigurationsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StandingConfigurationsPostBody.parse_obj(obj)

        _obj = StandingConfigurationsPostBody.parse_obj(
            {
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "build_rules": StandingBuilding.from_dict(obj.get("buildRules"))
                if obj.get("buildRules") is not None
                else None,
                "configuration": StandingConfiguration.from_dict(obj.get("configuration"))
                if obj.get("configuration") is not None
                else None,
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
