# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import List, Optional, Union

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, validator


class StandingBuilding(BaseModel):
    """
    Suilding definitions
    """

    build_type: StrictStr = Field(
        ..., alias="buildType", description="Overall standing Type (ROUND not used on live Standings)"
    )
    build_overall: Optional[StrictBool] = Field(None, alias="buildOverall", description="Build overall standings")
    build_conferences: Optional[StrictBool] = Field(
        None, alias="buildConferences", description="Build standings by conference"
    )
    build_divisions: Optional[StrictBool] = Field(
        None, alias="buildDivisions", description="Build standings by division"
    )
    grouping: StrictStr = Field(..., description="How to Group")
    blank_standing: Optional[StrictBool] = Field(
        None, alias="blankStanding", description="Give entity blank row if no played"
    )
    include_live_fixtures: Optional[StrictBool] = Field(
        None, alias="includeLiveFixtures", description="Include live fixtures"
    )
    generate_live_standings: Optional[StrictBool] = Field(
        None, alias="generateLiveStandings", description="Generate only live fixtures"
    )
    fixture_types: conlist(StrictStr) = Field(..., alias="fixtureTypes")
    decimal_places: Optional[Union[StrictFloat, StrictInt]] = Field(
        4, alias="decimalPlaces", description="Number of decimal places for percentage calculations"
    )
    __properties = [
        "buildType",
        "buildOverall",
        "buildConferences",
        "buildDivisions",
        "grouping",
        "blankStanding",
        "includeLiveFixtures",
        "generateLiveStandings",
        "fixtureTypes",
        "decimalPlaces",
    ]

    @validator("build_type")
    def build_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("ROUND", "OVERALL"):
            raise ValueError("must be one of enum values ('ROUND', 'OVERALL')")
        return value

    @validator("grouping")
    def grouping_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("STAGE", "STAGEPOOL", "NONE"):
            raise ValueError("must be one of enum values ('STAGE', 'STAGEPOOL', 'NONE')")
        return value

    @validator("fixture_types")
    def fixture_types_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
                raise ValueError(
                    "each list item must be one of ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
                )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingBuilding:
        """Create an instance of StandingBuilding from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingBuilding:
        """Create an instance of StandingBuilding from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StandingBuilding.parse_obj(obj)

        _obj = StandingBuilding.parse_obj(
            {
                "build_type": obj.get("buildType"),
                "build_overall": obj.get("buildOverall"),
                "build_conferences": obj.get("buildConferences"),
                "build_divisions": obj.get("buildDivisions"),
                "grouping": obj.get("grouping"),
                "blank_standing": obj.get("blankStanding"),
                "include_live_fixtures": obj.get("includeLiveFixtures"),
                "generate_live_standings": obj.get("generateLiveStandings"),
                "fixture_types": obj.get("fixtureTypes"),
                "decimal_places": obj.get("decimalPlaces") if obj.get("decimalPlaces") is not None else 4,
            }
        )
        return _obj
