# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, StrictStr


class SocialMedia(BaseModel):
    """
    Social Media contacts
    """

    website: Optional[StrictStr] = None
    facebook: Optional[StrictStr] = None
    twitter: Optional[StrictStr] = None
    wikipedia: Optional[StrictStr] = None
    instagram: Optional[StrictStr] = None
    __properties = ["website", "facebook", "twitter", "wikipedia", "instagram"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SocialMedia:
        """Create an instance of SocialMedia from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if website (nullable) is None
        # and __fields_set__ contains the field
        if self.website is None and "website" in self.__fields_set__:
            _dict["website"] = None

        # set to None if facebook (nullable) is None
        # and __fields_set__ contains the field
        if self.facebook is None and "facebook" in self.__fields_set__:
            _dict["facebook"] = None

        # set to None if twitter (nullable) is None
        # and __fields_set__ contains the field
        if self.twitter is None and "twitter" in self.__fields_set__:
            _dict["twitter"] = None

        # set to None if wikipedia (nullable) is None
        # and __fields_set__ contains the field
        if self.wikipedia is None and "wikipedia" in self.__fields_set__:
            _dict["wikipedia"] = None

        # set to None if instagram (nullable) is None
        # and __fields_set__ contains the field
        if self.instagram is None and "instagram" in self.__fields_set__:
            _dict["instagram"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SocialMedia:
        """Create an instance of SocialMedia from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SocialMedia.parse_obj(obj)

        _obj = SocialMedia.parse_obj(
            {
                "website": obj.get("website"),
                "facebook": obj.get("facebook"),
                "twitter": obj.get("twitter"),
                "wikipedia": obj.get("wikipedia"),
                "instagram": obj.get("instagram"),
            }
        )
        return _obj
