# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, constr, validator

from atriumsports.datacore.openapi.models.site_address import SiteAddress
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class SitePutBody(BaseModel):
    """
    SitePutBody
    """

    abbreviation_local: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the site in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the site in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the site. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    address: Optional[SiteAddress] = None
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "abbreviationLocal",
        "nameLocal",
        "abbreviationLatin",
        "nameLatin",
        "countryCode",
        "address",
        "social",
        "externalId",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SitePutBody:
        """Create an instance of SitePutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if country_code (nullable) is None
        # and __fields_set__ contains the field
        if self.country_code is None and "country_code" in self.__fields_set__:
            _dict["countryCode"] = None

        # set to None if address (nullable) is None
        # and __fields_set__ contains the field
        if self.address is None and "address" in self.__fields_set__:
            _dict["address"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SitePutBody:
        """Create an instance of SitePutBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SitePutBody.parse_obj(obj)

        _obj = SitePutBody.parse_obj(
            {
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "country_code": obj.get("countryCode"),
                "address": SiteAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
