# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr


class SiteAddress(BaseModel):
    """
    Street Address for the site
    """

    address1: Optional[StrictStr] = Field(None, description="First line of the address")
    address2: Optional[StrictStr] = Field(None, description="Second line of the address")
    address3: Optional[StrictStr] = Field(None, description="Third line of the address")
    city: Optional[StrictStr] = Field(None, description="The city/suburb of the address")
    state: Optional[StrictStr] = Field(None, description="The state of the address")
    postal_code: Optional[StrictStr] = Field(None, alias="postalCode", description="The postal code for the address")
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="ISO Country code of the address.  We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    longitude: Optional[Union[StrictFloat, StrictInt]] = None
    latitude: Optional[Union[StrictFloat, StrictInt]] = None
    __properties = [
        "address1",
        "address2",
        "address3",
        "city",
        "state",
        "postalCode",
        "countryCode",
        "longitude",
        "latitude",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SiteAddress:
        """Create an instance of SiteAddress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if address1 (nullable) is None
        # and __fields_set__ contains the field
        if self.address1 is None and "address1" in self.__fields_set__:
            _dict["address1"] = None

        # set to None if address2 (nullable) is None
        # and __fields_set__ contains the field
        if self.address2 is None and "address2" in self.__fields_set__:
            _dict["address2"] = None

        # set to None if address3 (nullable) is None
        # and __fields_set__ contains the field
        if self.address3 is None and "address3" in self.__fields_set__:
            _dict["address3"] = None

        # set to None if city (nullable) is None
        # and __fields_set__ contains the field
        if self.city is None and "city" in self.__fields_set__:
            _dict["city"] = None

        # set to None if state (nullable) is None
        # and __fields_set__ contains the field
        if self.state is None and "state" in self.__fields_set__:
            _dict["state"] = None

        # set to None if postal_code (nullable) is None
        # and __fields_set__ contains the field
        if self.postal_code is None and "postal_code" in self.__fields_set__:
            _dict["postalCode"] = None

        # set to None if country_code (nullable) is None
        # and __fields_set__ contains the field
        if self.country_code is None and "country_code" in self.__fields_set__:
            _dict["countryCode"] = None

        # set to None if longitude (nullable) is None
        # and __fields_set__ contains the field
        if self.longitude is None and "longitude" in self.__fields_set__:
            _dict["longitude"] = None

        # set to None if latitude (nullable) is None
        # and __fields_set__ contains the field
        if self.latitude is None and "latitude" in self.__fields_set__:
            _dict["latitude"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SiteAddress:
        """Create an instance of SiteAddress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SiteAddress.parse_obj(obj)

        _obj = SiteAddress.parse_obj(
            {
                "address1": obj.get("address1"),
                "address2": obj.get("address2"),
                "address3": obj.get("address3"),
                "city": obj.get("city"),
                "state": obj.get("state"),
                "postal_code": obj.get("postalCode"),
                "country_code": obj.get("countryCode"),
                "longitude": obj.get("longitude"),
                "latitude": obj.get("latitude"),
            }
        )
        return _obj
