# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr, validator

from atriumsports.datacore.openapi.models.season_series_competitor import SeasonSeriesCompetitor


class SeriesPutBody(BaseModel):
    """
    SeriesPutBody
    """

    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the series in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the series in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `COMPLETE` Complete >- `NOT_STARTED` Not Started "
    )
    series_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="seriesType",
        description="The type of series >- `BEST_OF` Best of >- `HOME_AND_AWAY` Home and Away >- `KNOCKOUT` Knockout ",
    )
    auto_calculated: Optional[StrictBool] = Field(
        None, alias="autoCalculated", description="Is the winner auto calculated?"
    )
    best_of: Optional[conint(strict=True)] = Field(None, alias="bestOf", description="Best of number")
    series_number: Optional[conint(strict=True)] = Field(
        None, alias="seriesNumber", description="User defined series number"
    )
    max_fixtures_number: Optional[StrictInt] = Field(
        None, alias="maxFixturesNumber", description="The maximum number of games within a playoff series"
    )
    winner: Optional[StrictStr] = Field(None, description="The unique identifier of the winner, person or entity")
    series_order: Optional[conint(strict=True)] = Field(
        None, alias="seriesOrder", description="User defined sort order of the series"
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    start_date: Optional[date] = Field(None, alias="startDate", description="Series start date")
    end_date: Optional[date] = Field(None, alias="endDate", description="Series end date")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    competitors: Optional[conlist(SeasonSeriesCompetitor)] = Field(
        None, description="Array of competitors in the series. A competitor may have a results and a ranking"
    )
    __properties = [
        "conferenceId",
        "divisionId",
        "nameLocal",
        "abbreviationLocal",
        "nameLatin",
        "abbreviationLatin",
        "status",
        "seriesType",
        "autoCalculated",
        "bestOf",
        "seriesNumber",
        "maxFixturesNumber",
        "winner",
        "seriesOrder",
        "stageCode",
        "poolCode",
        "startDate",
        "endDate",
        "externalId",
        "competitors",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("NOT_STARTED", "ACTIVE", "COMPLETE"):
            raise ValueError("must be one of enum values ('NOT_STARTED', 'ACTIVE', 'COMPLETE')")
        return value

    @validator("series_type")
    def series_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("BEST_OF", "HOME_AND_AWAY", "KNOCKOUT"):
            raise ValueError("must be one of enum values ('BEST_OF', 'HOME_AND_AWAY', 'KNOCKOUT')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeriesPutBody:
        """Create an instance of SeriesPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in competitors (list)
        _items = []
        if self.competitors:
            for _item in self.competitors:
                if _item:
                    _items.append(_item.to_dict())
            _dict["competitors"] = _items
        # set to None if conference_id (nullable) is None
        # and __fields_set__ contains the field
        if self.conference_id is None and "conference_id" in self.__fields_set__:
            _dict["conferenceId"] = None

        # set to None if division_id (nullable) is None
        # and __fields_set__ contains the field
        if self.division_id is None and "division_id" in self.__fields_set__:
            _dict["divisionId"] = None

        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if best_of (nullable) is None
        # and __fields_set__ contains the field
        if self.best_of is None and "best_of" in self.__fields_set__:
            _dict["bestOf"] = None

        # set to None if series_number (nullable) is None
        # and __fields_set__ contains the field
        if self.series_number is None and "series_number" in self.__fields_set__:
            _dict["seriesNumber"] = None

        # set to None if max_fixtures_number (nullable) is None
        # and __fields_set__ contains the field
        if self.max_fixtures_number is None and "max_fixtures_number" in self.__fields_set__:
            _dict["maxFixturesNumber"] = None

        # set to None if winner (nullable) is None
        # and __fields_set__ contains the field
        if self.winner is None and "winner" in self.__fields_set__:
            _dict["winner"] = None

        # set to None if series_order (nullable) is None
        # and __fields_set__ contains the field
        if self.series_order is None and "series_order" in self.__fields_set__:
            _dict["seriesOrder"] = None

        # set to None if stage_code (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_code is None and "stage_code" in self.__fields_set__:
            _dict["stageCode"] = None

        # set to None if pool_code (nullable) is None
        # and __fields_set__ contains the field
        if self.pool_code is None and "pool_code" in self.__fields_set__:
            _dict["poolCode"] = None

        # set to None if start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.start_date is None and "start_date" in self.__fields_set__:
            _dict["startDate"] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict["endDate"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        # set to None if competitors (nullable) is None
        # and __fields_set__ contains the field
        if self.competitors is None and "competitors" in self.__fields_set__:
            _dict["competitors"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeriesPutBody:
        """Create an instance of SeriesPutBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeriesPutBody.parse_obj(obj)

        _obj = SeriesPutBody.parse_obj(
            {
                "conference_id": obj.get("conferenceId"),
                "division_id": obj.get("divisionId"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "status": obj.get("status"),
                "series_type": obj.get("seriesType"),
                "auto_calculated": obj.get("autoCalculated"),
                "best_of": obj.get("bestOf"),
                "series_number": obj.get("seriesNumber"),
                "max_fixtures_number": obj.get("maxFixturesNumber"),
                "winner": obj.get("winner"),
                "series_order": obj.get("seriesOrder"),
                "stage_code": obj.get("stageCode"),
                "pool_code": obj.get("poolCode"),
                "start_date": obj.get("startDate"),
                "end_date": obj.get("endDate"),
                "external_id": obj.get("externalId"),
                "competitors": [SeasonSeriesCompetitor.from_dict(_item) for _item in obj.get("competitors")]
                if obj.get("competitors") is not None
                else None,
            }
        )
        return _obj
