# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date, datetime
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr, validator

from atriumsports.datacore.openapi.models.images_model import ImagesModel
from atriumsports.datacore.openapi.models.seasonroster_configuration import SEASONROSTERConfiguration
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition
from atriumsports.datacore.openapi.models.seasons_model_fixture_profile import SeasonsModelFixtureProfile
from atriumsports.datacore.openapi.models.seasons_model_organization import SeasonsModelOrganization
from atriumsports.datacore.openapi.models.seasons_model_standing_configuration import SeasonsModelStandingConfiguration
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class SeasonsModel(BaseModel):
    """
    SeasonsModel
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonsModelOrganization] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    leader_criteria_id: Optional[StrictStr] = Field(
        None, alias="leaderCriteriaId", description="The unique identifier of the leader criteria"
    )
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this season given by the sport governing body",
    )
    event_type: Optional[constr(strict=True, max_length=30)] = Field(
        "FIXTURE",
        alias="eventType",
        description="Primary Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice ",
    )
    season_type: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="seasonType",
        description="The type of fixtures added to this season >- `ONE_OFF` One off >- `SEASON` Season >- `TOURNAMENT` Tournament ",
    )
    year: Optional[conint(strict=True)] = Field(None, description="Year of the season")
    grade: Optional[constr(strict=True, max_length=50)] = Field(
        None, description="The playing grade of the fixtures in this season"
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    include_in_statistics: Optional[StrictBool] = Field(
        True, alias="includeInStatistics", description="Include this season in calculated statistics?"
    )
    live_video_available: Optional[StrictBool] = Field(
        None,
        alias="liveVideoAvailable",
        description="If no 'liveVideoAvailable' flag passed to a new fixture this value is used",
    )
    live_data_available: Optional[StrictBool] = Field(
        None,
        alias="liveDataAvailable",
        description="If no 'liveDataAvailable' flag passed to a new fixture this value is used",
    )
    duration_full: Optional[StrictInt] = Field(
        None, alias="durationFull", description="If no 'durationFull' is passed to a new fixture this value is used"
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the season in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the season in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_short_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLocal",
        description="The abbreviated name of the season in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_short_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLatin",
        description="The abbreviated name of the season in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    start_date: Optional[date] = Field(None, alias="startDate", description="Season start date")
    end_date: Optional[date] = Field(None, alias="endDate", description="Season end date")
    gender: Optional[constr(strict=True, max_length=20)] = Field(
        None,
        description="The gender of the participants in the season >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown ",
    )
    age_group: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="ageGroup",
        description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth ",
    )
    standard: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        description="The playing standard of the season >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship ",
    )
    representation: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person >- `REGION` Region >- `STATE` State ",
    )
    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the ~standingConfiguration~"
    )
    standing_configuration: Optional[SeasonsModelStandingConfiguration] = Field(None, alias="standingConfiguration")
    lock_standings: Optional[StrictBool] = Field(
        None, alias="lockStandings", description="Is the standings generation locked ?"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    social: Optional[SocialMedia] = None
    configuration: Optional[Dict[str, Any]] = Field(None, description="Season Configuration settings")
    profile_id: Optional[StrictStr] = Field(
        None, alias="profileId", description="The profile that this season belongs to"
    )
    fixture_profile: Optional[SeasonsModelFixtureProfile] = Field(None, alias="fixtureProfile")
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    images: Optional[conlist(ImagesModel)] = None
    video_production: Optional[constr(strict=True, max_length=50)] = Field(
        "NONE",
        alias="videoProduction",
        description="Data synchronization strategy with video production systems >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None ",
    )
    roster_configuration: Optional[SEASONROSTERConfiguration] = Field(None, alias="rosterConfiguration")
    __properties = [
        "seasonId",
        "organizationId",
        "organization",
        "competitionId",
        "competition",
        "leaderCriteriaId",
        "internationalReference",
        "eventType",
        "seasonType",
        "year",
        "grade",
        "status",
        "includeInStatistics",
        "liveVideoAvailable",
        "liveDataAvailable",
        "durationFull",
        "nameLocal",
        "nameLatin",
        "nameShortLocal",
        "nameShortLatin",
        "startDate",
        "endDate",
        "gender",
        "ageGroup",
        "standard",
        "representation",
        "standingConfigurationId",
        "standingConfiguration",
        "lockStandings",
        "externalId",
        "social",
        "configuration",
        "profileId",
        "fixtureProfile",
        "updated",
        "added",
        "images",
        "videoProduction",
        "rosterConfiguration",
    ]

    @validator("event_type")
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("FIXTURE", "PRACTICE"):
            raise ValueError("must be one of enum values ('FIXTURE', 'PRACTICE')")
        return value

    @validator("season_type")
    def season_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("SEASON", "TOURNAMENT", "ONE_OFF"):
            raise ValueError("must be one of enum values ('SEASON', 'TOURNAMENT', 'ONE_OFF')")
        return value

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("gender")
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("FEMALE", "MALE", "MIXED", "UNKNOWN"):
            raise ValueError("must be one of enum values ('FEMALE', 'MALE', 'MIXED', 'UNKNOWN')")
        return value

    @validator("age_group")
    def age_group_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "JUNIOR",
            "YOUTH",
            "UNDER_15",
            "UNDER_16",
            "UNDER_17",
            "UNDER_18",
            "UNDER_19",
            "UNDER_20",
            "UNDER_21",
            "UNDER_22",
            "UNDER_23",
            "SENIOR",
            "MASTERS",
        ):
            raise ValueError(
                "must be one of enum values ('JUNIOR', 'YOUTH', 'UNDER_15', 'UNDER_16', 'UNDER_17', 'UNDER_18', 'UNDER_19', 'UNDER_20', 'UNDER_21', 'UNDER_22', 'UNDER_23', 'SENIOR', 'MASTERS')"
            )
        return value

    @validator("standard")
    def standard_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in (
            "ELITE",
            "FRIENDLY",
            "GRASS_ROOT",
            "INTERNATIONAL",
            "NONCONTINENTAL_CHAMPIONSHIP",
            "OLYMPIC",
            "REGION",
            "TIER2",
            "TIER3",
            "WORLD_CHAMPIONSHIP",
            "ZONE_CHAMPIONSHIP",
        ):
            raise ValueError(
                "must be one of enum values ('ELITE', 'FRIENDLY', 'GRASS_ROOT', 'INTERNATIONAL', 'NONCONTINENTAL_CHAMPIONSHIP', 'OLYMPIC', 'REGION', 'TIER2', 'TIER3', 'WORLD_CHAMPIONSHIP', 'ZONE_CHAMPIONSHIP')"
            )
        return value

    @validator("representation")
    def representation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("CLUB", "STATE", "REGION", "COUNTRY", "PERSON"):
            raise ValueError("must be one of enum values ('CLUB', 'STATE', 'REGION', 'COUNTRY', 'PERSON')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    @validator("video_production")
    def video_production_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("NONE", "AUTOMATED", "MANUAL"):
            raise ValueError("must be one of enum values ('NONE', 'AUTOMATED', 'MANUAL')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonsModel:
        """Create an instance of SeasonsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of standing_configuration
        if self.standing_configuration:
            _dict["standingConfiguration"] = self.standing_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture_profile
        if self.fixture_profile:
            _dict["fixtureProfile"] = self.fixture_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["images"] = _items
        # override the default output from pydantic by calling `to_dict()` of roster_configuration
        if self.roster_configuration:
            _dict["rosterConfiguration"] = self.roster_configuration.to_dict()
        # set to None if leader_criteria_id (nullable) is None
        # and __fields_set__ contains the field
        if self.leader_criteria_id is None and "leader_criteria_id" in self.__fields_set__:
            _dict["leaderCriteriaId"] = None

        # set to None if international_reference (nullable) is None
        # and __fields_set__ contains the field
        if self.international_reference is None and "international_reference" in self.__fields_set__:
            _dict["internationalReference"] = None

        # set to None if grade (nullable) is None
        # and __fields_set__ contains the field
        if self.grade is None and "grade" in self.__fields_set__:
            _dict["grade"] = None

        # set to None if duration_full (nullable) is None
        # and __fields_set__ contains the field
        if self.duration_full is None and "duration_full" in self.__fields_set__:
            _dict["durationFull"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if name_short_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_short_local is None and "name_short_local" in self.__fields_set__:
            _dict["nameShortLocal"] = None

        # set to None if name_short_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_short_latin is None and "name_short_latin" in self.__fields_set__:
            _dict["nameShortLatin"] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict["endDate"] = None

        # set to None if standing_configuration_id (nullable) is None
        # and __fields_set__ contains the field
        if self.standing_configuration_id is None and "standing_configuration_id" in self.__fields_set__:
            _dict["standingConfigurationId"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        # set to None if social (nullable) is None
        # and __fields_set__ contains the field
        if self.social is None and "social" in self.__fields_set__:
            _dict["social"] = None

        # set to None if configuration (nullable) is None
        # and __fields_set__ contains the field
        if self.configuration is None and "configuration" in self.__fields_set__:
            _dict["configuration"] = None

        # set to None if profile_id (nullable) is None
        # and __fields_set__ contains the field
        if self.profile_id is None and "profile_id" in self.__fields_set__:
            _dict["profileId"] = None

        # set to None if roster_configuration (nullable) is None
        # and __fields_set__ contains the field
        if self.roster_configuration is None and "roster_configuration" in self.__fields_set__:
            _dict["rosterConfiguration"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonsModel:
        """Create an instance of SeasonsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonsModel.parse_obj(obj)

        _obj = SeasonsModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "organization_id": obj.get("organizationId"),
                "organization": SeasonsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "leader_criteria_id": obj.get("leaderCriteriaId"),
                "international_reference": obj.get("internationalReference"),
                "event_type": obj.get("eventType") if obj.get("eventType") is not None else "FIXTURE",
                "season_type": obj.get("seasonType"),
                "year": obj.get("year"),
                "grade": obj.get("grade"),
                "status": obj.get("status"),
                "include_in_statistics": obj.get("includeInStatistics")
                if obj.get("includeInStatistics") is not None
                else True,
                "live_video_available": obj.get("liveVideoAvailable"),
                "live_data_available": obj.get("liveDataAvailable"),
                "duration_full": obj.get("durationFull"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "name_short_local": obj.get("nameShortLocal"),
                "name_short_latin": obj.get("nameShortLatin"),
                "start_date": obj.get("startDate"),
                "end_date": obj.get("endDate"),
                "gender": obj.get("gender"),
                "age_group": obj.get("ageGroup"),
                "standard": obj.get("standard"),
                "representation": obj.get("representation"),
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "standing_configuration": SeasonsModelStandingConfiguration.from_dict(obj.get("standingConfiguration"))
                if obj.get("standingConfiguration") is not None
                else None,
                "lock_standings": obj.get("lockStandings"),
                "external_id": obj.get("externalId"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "configuration": obj.get("configuration"),
                "profile_id": obj.get("profileId"),
                "fixture_profile": SeasonsModelFixtureProfile.from_dict(obj.get("fixtureProfile"))
                if obj.get("fixtureProfile") is not None
                else None,
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "images": [ImagesModel.from_dict(_item) for _item in obj.get("images")]
                if obj.get("images") is not None
                else None,
                "video_production": obj.get("videoProduction") if obj.get("videoProduction") is not None else "NONE",
                "roster_configuration": SEASONROSTERConfiguration.from_dict(obj.get("rosterConfiguration"))
                if obj.get("rosterConfiguration") is not None
                else None,
            }
        )
        return _obj
