# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from typing import Optional

from pydantic import BaseModel, Field, StrictBool


class SEASONROSTERConfiguration(BaseModel):
    """
    Configuration for the SEASON ROSTER
    """

    window_open_date: Optional[date] = Field(
        None, alias="windowOpenDate", description="What date can a SEASON ROSTER be submitted from for this SEASON?"
    )
    window_close_date: Optional[date] = Field(
        None,
        alias="windowCloseDate",
        description="What is the last date a SEASON ROSTER can be submitted from for this SEASON?",
    )
    season_roster_lock: Optional[StrictBool] = Field(
        None,
        alias="seasonRosterLock",
        description="Make SEASON ROSTERS un-editable when SEASON ROSTER Registration Window Close Date has elapsed.",
    )
    fixture_roster_lock: Optional[StrictBool] = Field(
        None,
        alias="fixtureRosterLock",
        description="Make FIXTURE ROSTERS un-editable when FIXTURE Status is set to Scheduled",
    )
    __properties = ["windowOpenDate", "windowCloseDate", "seasonRosterLock", "fixtureRosterLock"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SEASONROSTERConfiguration:
        """Create an instance of SEASONROSTERConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if window_open_date (nullable) is None
        # and __fields_set__ contains the field
        if self.window_open_date is None and "window_open_date" in self.__fields_set__:
            _dict["windowOpenDate"] = None

        # set to None if window_close_date (nullable) is None
        # and __fields_set__ contains the field
        if self.window_close_date is None and "window_close_date" in self.__fields_set__:
            _dict["windowCloseDate"] = None

        # set to None if season_roster_lock (nullable) is None
        # and __fields_set__ contains the field
        if self.season_roster_lock is None and "season_roster_lock" in self.__fields_set__:
            _dict["seasonRosterLock"] = None

        # set to None if fixture_roster_lock (nullable) is None
        # and __fields_set__ contains the field
        if self.fixture_roster_lock is None and "fixture_roster_lock" in self.__fields_set__:
            _dict["fixtureRosterLock"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SEASONROSTERConfiguration:
        """Create an instance of SEASONROSTERConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SEASONROSTERConfiguration.parse_obj(obj)

        _obj = SEASONROSTERConfiguration.parse_obj(
            {
                "window_open_date": obj.get("windowOpenDate"),
                "window_close_date": obj.get("windowCloseDate"),
                "season_roster_lock": obj.get("seasonRosterLock"),
                "fixture_roster_lock": obj.get("fixtureRosterLock"),
            }
        )
        return _obj
