# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class SEASONENTITYPlacingsPostBody(BaseModel):
    """
    SEASONENTITYPlacingsPostBody
    """

    placing_id: Optional[StrictStr] = Field(
        None, alias="placingId", description="The unique identifier of the SEASON ENTITY placing"
    )
    organization_id: constr(strict=True, max_length=5, min_length=5) = Field(
        ..., alias="organizationId", description="The unique identifier of the organization"
    )
    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    entity_id: StrictStr = Field(..., alias="entityId", description="The unique identifier of the entity")
    result_place: Optional[StrictInt] = Field(None, alias="resultPlace", description="Result place")
    points: Optional[StrictInt] = Field(None, description="Points awarded")
    prize_money: Optional[StrictInt] = Field(None, alias="prizeMoney", description="Prize money awarded")
    __properties = ["placingId", "organizationId", "seasonId", "entityId", "resultPlace", "points", "prizeMoney"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SEASONENTITYPlacingsPostBody:
        """Create an instance of SEASONENTITYPlacingsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if points (nullable) is None
        # and __fields_set__ contains the field
        if self.points is None and "points" in self.__fields_set__:
            _dict["points"] = None

        # set to None if prize_money (nullable) is None
        # and __fields_set__ contains the field
        if self.prize_money is None and "prize_money" in self.__fields_set__:
            _dict["prizeMoney"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SEASONENTITYPlacingsPostBody:
        """Create an instance of SEASONENTITYPlacingsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SEASONENTITYPlacingsPostBody.parse_obj(obj)

        _obj = SEASONENTITYPlacingsPostBody.parse_obj(
            {
                "placing_id": obj.get("placingId"),
                "organization_id": obj.get("organizationId"),
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "result_place": obj.get("resultPlace"),
                "points": obj.get("points"),
                "prize_money": obj.get("prizeMoney"),
            }
        )
        return _obj
