# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conint, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_stages_model_organization import SeasonStagesModelOrganization


class SeasonStagesModel(BaseModel):
    """
    SeasonStagesModel
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonStagesModelOrganization] = None
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    name_local: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLocal",
        description="The name of the season stage in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLatin",
        description="The name of the season stage in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    stage_order: Optional[conint(strict=True)] = Field(
        None, alias="stageOrder", description="User defined sort order of the stage"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "stageCode",
        "nameLocal",
        "abbreviationLocal",
        "nameLatin",
        "abbreviationLatin",
        "stageOrder",
        "externalId",
        "updated",
        "added",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonStagesModel:
        """Create an instance of SeasonStagesModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # set to None if name_local (nullable) is None
        # and __fields_set__ contains the field
        if self.name_local is None and "name_local" in self.__fields_set__:
            _dict["nameLocal"] = None

        # set to None if abbreviation_local (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_local is None and "abbreviation_local" in self.__fields_set__:
            _dict["abbreviationLocal"] = None

        # set to None if name_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.name_latin is None and "name_latin" in self.__fields_set__:
            _dict["nameLatin"] = None

        # set to None if abbreviation_latin (nullable) is None
        # and __fields_set__ contains the field
        if self.abbreviation_latin is None and "abbreviation_latin" in self.__fields_set__:
            _dict["abbreviationLatin"] = None

        # set to None if stage_order (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_order is None and "stage_order" in self.__fields_set__:
            _dict["stageOrder"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonStagesModel:
        """Create an instance of SeasonStagesModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonStagesModel.parse_obj(obj)

        _obj = SeasonStagesModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonStagesModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "stage_code": obj.get("stageCode"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "stage_order": obj.get("stageOrder"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
