# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional, Union

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator


class SeasonSeriesCompetitor(BaseModel):
    """
    SeasonSeriesCompetitor
    """

    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The uuid of the entity")
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The uuid of the person")
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The uuid of the conference the competitor represents"
    )
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The uuid of the conference the competitor represents"
    )
    pre_series_ranking: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="preSeriesRanking", description="The rank of the competitor coming into the series"
    )
    string_record: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="stringRecord", description="String record of the competitor"
    )
    series_wins: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="seriesWins", description="Number of wins in the series for the competitor"
    )
    series_losses: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="seriesLosses", description="Number of losses in the series for the competitor"
    )
    series_draws: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, alias="seriesDraws", description="Number of draws in the series for the competitor"
    )
    series_result: Optional[StrictStr] = Field(
        None, alias="seriesResult", description="Result for the competitor in the series"
    )
    __properties = [
        "entityId",
        "personId",
        "conferenceId",
        "divisionId",
        "preSeriesRanking",
        "stringRecord",
        "seriesWins",
        "seriesLosses",
        "seriesDraws",
        "seriesResult",
    ]

    @validator("series_result")
    def series_result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("PENDING", "WON", "LOST", "DRAW"):
            raise ValueError("must be one of enum values ('PENDING', 'WON', 'LOST', 'DRAW')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonSeriesCompetitor:
        """Create an instance of SeasonSeriesCompetitor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonSeriesCompetitor:
        """Create an instance of SeasonSeriesCompetitor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonSeriesCompetitor.parse_obj(obj)

        _obj = SeasonSeriesCompetitor.parse_obj(
            {
                "entity_id": obj.get("entityId"),
                "person_id": obj.get("personId"),
                "conference_id": obj.get("conferenceId"),
                "division_id": obj.get("divisionId"),
                "pre_series_ranking": obj.get("preSeriesRanking"),
                "string_record": obj.get("stringRecord"),
                "series_wins": obj.get("seriesWins"),
                "series_losses": obj.get("seriesLosses"),
                "series_draws": obj.get("seriesDraws"),
                "series_result": obj.get("seriesResult"),
            }
        )
        return _obj
