# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conint, constr, validator


class SeasonPersonsPostBody(BaseModel):
    """
    SeasonPersonsPostBody
    """

    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    seed: Optional[conint(strict=True)] = Field(None, description="Initial seeding")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = ["seasonId", "personId", "entityGroupId", "status", "seed", "externalId"]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPersonsPostBody:
        """Create an instance of SeasonPersonsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if seed (nullable) is None
        # and __fields_set__ contains the field
        if self.seed is None and "seed" in self.__fields_set__:
            _dict["seed"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPersonsPostBody:
        """Create an instance of SeasonPersonsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonPersonsPostBody.parse_obj(obj)

        _obj = SeasonPersonsPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "status": obj.get("status"),
                "seed": obj.get("seed"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
