# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, conint, constr, validator

from atriumsports.datacore.openapi.models.entities_model_entity_group import EntitiesModelEntityGroup
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_persons_list_model_organization import (
    SeasonPersonsListModelOrganization,
)


class SeasonPersonsModel(BaseModel):
    """
    SeasonPersonsModel
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonPersonsListModelOrganization] = None
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    entity_group: Optional[EntitiesModelEntityGroup] = Field(None, alias="entityGroup")
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    seed: Optional[conint(strict=True)] = Field(None, description="Initial seeding")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "personId",
        "person",
        "entityGroupId",
        "entityGroup",
        "status",
        "seed",
        "externalId",
        "updated",
        "added",
    ]

    @validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must be one of enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return value

    @validator("external_id")
    def external_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9A-Za-z\/_-]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPersonsModel:
        """Create an instance of SeasonPersonsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity_group
        if self.entity_group:
            _dict["entityGroup"] = self.entity_group.to_dict()
        # set to None if seed (nullable) is None
        # and __fields_set__ contains the field
        if self.seed is None and "seed" in self.__fields_set__:
            _dict["seed"] = None

        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPersonsModel:
        """Create an instance of SeasonPersonsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonPersonsModel.parse_obj(obj)

        _obj = SeasonPersonsModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonPersonsListModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "entity_group_id": obj.get("entityGroupId"),
                "entity_group": EntitiesModelEntityGroup.from_dict(obj.get("entityGroup"))
                if obj.get("entityGroup") is not None
                else None,
                "status": obj.get("status"),
                "seed": obj.get("seed"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
