# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr

from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_person_statistics_model_organization import (
    SeasonPersonStatisticsModelOrganization,
)
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition


class SeasonPersonStatisticsPeriodsModel(BaseModel):
    """
    SeasonPersonStatisticsPeriodsModel
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonPersonStatisticsModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    statistics: Optional[Dict[str, Any]] = None
    __properties = [
        "personId",
        "person",
        "entityId",
        "entity",
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "competitionId",
        "competition",
        "periodId",
        "section",
        "statistics",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPersonStatisticsPeriodsModel:
        """Create an instance of SeasonPersonStatisticsPeriodsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPersonStatisticsPeriodsModel:
        """Create an instance of SeasonPersonStatisticsPeriodsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonPersonStatisticsPeriodsModel.parse_obj(obj)

        _obj = SeasonPersonStatisticsPeriodsModel.parse_obj(
            {
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonPersonStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
