# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class SeasonPersonBaseStatisticsPostBody(BaseModel):
    """
    SeasonPersonBaseStatisticsPostBody
    """

    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    person_id: StrictStr = Field(..., alias="personId", description="The unique identifier of the person")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    fixture_type: constr(strict=True, max_length=50) = Field(
        ...,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    competitor_type: constr(strict=True, max_length=50) = Field(
        ...,
        alias="competitorType",
        description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person ",
    )
    statistics: Optional[Dict[str, Any]] = None
    __properties = ["seasonId", "personId", "entityId", "fixtureType", "competitorType", "statistics"]

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must be one of enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return value

    @validator("competitor_type")
    def competitor_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ("PERSON", "ENTITY"):
            raise ValueError("must be one of enum values ('PERSON', 'ENTITY')")
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPersonBaseStatisticsPostBody:
        """Create an instance of SeasonPersonBaseStatisticsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPersonBaseStatisticsPostBody:
        """Create an instance of SeasonPersonBaseStatisticsPostBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonPersonBaseStatisticsPostBody.parse_obj(obj)

        _obj = SeasonPersonBaseStatisticsPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "person_id": obj.get("personId"),
                "entity_id": obj.get("entityId"),
                "fixture_type": obj.get("fixtureType"),
                "competitor_type": obj.get("competitorType"),
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
