# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the file manually.
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_organization import (
    SeasonFixtureStagesPoolsListModelOrganization,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_pool import (
    SeasonFixtureStagesPoolsListModelPool,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)


class SeasonFixtureStagesPoolsListModel(BaseModel):
    """
    SeasonFixtureStagesPoolsListModel
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonFixtureStagesPoolsListModelOrganization] = None
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    pool: Optional[SeasonFixtureStagesPoolsListModelPool] = None
    fixture_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    __properties = [
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "stageCode",
        "stage",
        "poolCode",
        "pool",
        "fixtureType",
    ]

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must be one of enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return value

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonFixtureStagesPoolsListModel:
        """Create an instance of SeasonFixtureStagesPoolsListModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict["pool"] = self.pool.to_dict()
        # set to None if stage_code (nullable) is None
        # and __fields_set__ contains the field
        if self.stage_code is None and "stage_code" in self.__fields_set__:
            _dict["stageCode"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonFixtureStagesPoolsListModel:
        """Create an instance of SeasonFixtureStagesPoolsListModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SeasonFixtureStagesPoolsListModel.parse_obj(obj)

        _obj = SeasonFixtureStagesPoolsListModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonFixtureStagesPoolsListModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "pool_code": obj.get("poolCode"),
                "pool": SeasonFixtureStagesPoolsListModelPool.from_dict(obj.get("pool"))
                if obj.get("pool") is not None
                else None,
                "fixture_type": obj.get("fixtureType"),
            }
        )
        return _obj
